/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.starter;

import com.apple.eawt.Application;
import com.jidesoft.utils.SystemInfo;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.swing.SwingUtilities;
import mediathek.controller.Log;
import mediathek.controller.starter.RuntimeExec;
import mediathek.controller.starter.Start;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenPset;
import mediathek.gui.dialog.DialogContinueDownload;
import mediathek.gui.dialog.MeldungDownloadfehler;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVInfoFile;
import mediathek.tool.MVInputStream;
import mediathek.tool.MVNotification;
import mediathek.tool.MVSubtitle;
import msearch.daten.DatenFilm;
import msearch.tool.Datum;

public class StarterClass {
    private final Daten daten;
    private Starten starten = null;
    private boolean pause = false;

    public StarterClass(Daten daten) {
        this.daten = daten;
        this.starten = new Starten();
        this.starten.start();
    }

    public synchronized void urlMitProgrammStarten(DatenPset pSet, DatenFilm ersterFilm, String aufloesung) {
        String url = ersterFilm.arr[12];
        if (!url.equals("")) {
            DatenDownload d = new DatenDownload(pSet, ersterFilm, 1, null, "", "", aufloesung);
            d.start = new Start();
            this.starten.startStarten(d);
            this.daten.history.zeileSchreiben(ersterFilm.arr[2], ersterFilm.arr[3], d.arr[18]);
            Daten.listeFilmeHistory.add((Object)ersterFilm);
            Daten.listeDownloadsButton.addMitNummer(d);
        }
    }

    public void pause() {
        this.pause = true;
    }

    private boolean pruefen(DatenDownload datenDownload, Start start) {
        boolean ret = false;
        if (start != null && start.percent > -1 && start.percent < 995) {
            Log.fehlerMeldung(696510258, "Download fehlgeschlagen: 99,5% wurden nicht erreicht" + datenDownload.arr[29]);
            return false;
        }
        File file = new File(datenDownload.arr[29]);
        if (!file.exists()) {
            Log.fehlerMeldung(550236231, "Download fehlgeschlagen: Datei existiert nicht" + datenDownload.arr[29]);
        } else if (file.length() < 256000L) {
            Log.fehlerMeldung(795632500, "Download fehlgeschlagen: Datei zu klein" + datenDownload.arr[29]);
        } else {
            if (datenDownload.istAbo()) {
                this.daten.erledigteAbos.zeileSchreiben(datenDownload.arr[4], datenDownload.arr[5], datenDownload.arr[18]);
            }
            ret = true;
        }
        return ret;
    }

    private void deleteIfEmpty(File file) {
        try {
            if (file.exists()) {
                if (file.length() == 0L) {
                    Log.systemMeldung(new String[]{"Restart/Aufr\u00e4umen: leere Datei l\u00f6schen", file.getAbsolutePath()});
                    if (!file.delete()) {
                        throw new Exception();
                    }
                } else if (file.length() < 256000L) {
                    Log.systemMeldung(new String[]{"Restart/Aufr\u00e4umen: Zu kleine Datei l\u00f6schen", file.getAbsolutePath()});
                    if (!file.delete()) {
                        throw new Exception();
                    }
                }
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(795632500, "Fehler beim l\u00f6schen" + file.getAbsolutePath());
        }
    }

    private void startmeldung(DatenDownload datenDownload, Start start) {
        boolean abspielen;
        ArrayList<String> text = new ArrayList<String>();
        boolean bl = abspielen = datenDownload.quelle == 1;
        if (abspielen) {
            text.add("Film abspielen");
        } else {
            if (start.startcounter > 1) {
                text.add("Download starten - Restart (Summe Starts: " + start.startcounter + ")");
            } else {
                text.add("Download starten");
            }
            text.add("Programmset: " + datenDownload.arr[22]);
            text.add("Ziel: " + datenDownload.arr[29]);
        }
        text.add("URL: " + datenDownload.arr[19]);
        text.add("Startzeit: " + new SimpleDateFormat("HH:mm:ss").format((Date)start.startZeit));
        if (datenDownload.art == 1) {
            text.add("direkter Download");
        } else {
            text.add("Programmaufruf: " + datenDownload.arr[24]);
            text.add("Programmaufruf[]: " + datenDownload.arr[25]);
        }
        Log.systemMeldung(text.toArray(new String[text.size()]));
    }

    private void fertigmeldung(final DatenDownload datenDownload, final Start start, boolean abgebrochen) {
        if (Boolean.parseBoolean(Daten.mVConfig.get("Download-Beep"))) {
            try {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList<String> text = new ArrayList<String>();
        if (abgebrochen) {
            text.add("Download wurde abgebrochen");
        } else if (datenDownload.quelle == 1) {
            text.add("Film fertig");
        } else {
            if (start.stoppen) {
                text.add("Download abgebrochen");
            } else if (start.status == 3) {
                text.add("Download ist fertig und hat geklappt");
            } else if (start.status == 4) {
                text.add("Download ist fertig und war fehlerhaft");
            }
            if (datenDownload.isDownloadManager()) {
                text.add("Programm ist ein Downloadmanager");
            }
            text.add("Programmset: " + datenDownload.arr[22]);
            text.add("Ziel: " + datenDownload.arr[29]);
        }
        text.add("Startzeit: " + new SimpleDateFormat("HH:mm:ss").format((Date)start.startZeit));
        text.add("Endzeit: " + new SimpleDateFormat("HH:mm:ss").format(new Datum().getTime()));
        text.add("Dauer: " + start.startZeit.diffInSekunden() + " s");
        long dauer = start.startZeit.diffInMinuten();
        if (dauer == 0L) {
            text.add("Dauer: <1 Min.");
        } else {
            text.add("Dauer: " + start.startZeit.diffInMinuten() + " Min");
        }
        text.add("URL: " + datenDownload.arr[19]);
        if (datenDownload.art == 1) {
            text.add("direkter Download");
        } else {
            text.add("Programmaufruf: " + datenDownload.arr[24]);
            text.add("Programmaufruf[]: " + datenDownload.arr[25]);
        }
        Log.systemMeldung(text.toArray(new String[text.size()]));
        if (!start.stoppen && !abgebrochen && datenDownload.quelle != 1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MVNotification.addNotification(StarterClass.this.daten, datenDownload, start.status != 4);
                }
            });
        }
    }

    private void writeSpotlightComment(DatenDownload datenDownload, boolean wasCancelled) {
        if (wasCancelled || !SystemInfo.isMacOSX()) {
            return;
        }
        if (datenDownload.film == null) {
            return;
        }
        Path filmPath = Paths.get(datenDownload.arr[29], new String[0]);
        if (Files.exists(filmPath, new LinkOption[0])) {
            String strFilePath = filmPath.toString();
            String strComment = datenDownload.film.arr[10];
            if (strComment != null) {
                if (strComment.isEmpty()) {
                    return;
                }
                strComment = strComment.replace("\"", "\\\"");
                String script = "tell application \"Finder\"\nset my_file to POSIX file \"" + strFilePath + "\" as alias\n" + "set comment of my_file to \"" + strComment + "\"\n" + "end tell\n";
                try {
                    ScriptEngineManager mgr = new ScriptEngineManager();
                    ScriptEngine engine = mgr.getEngineByName("AppleScript");
                    engine.eval(script);
                }
                catch (Exception ex) {
                    Log.fehlerMeldung(915263987, "Fehler beim Spotlight schreiben" + filmPath.toString());
                    try {
                        if (!System.getProperty("OSX_OFFICIAL_APP").equalsIgnoreCase("true")) {
                            this.logUnofficialMacAppUse();
                        }
                    }
                    catch (NullPointerException ignored) {
                        this.logUnofficialMacAppUse();
                    }
                }
            }
        }
    }

    private void logUnofficialMacAppUse() {
        Log.fehlerMeldung(915263987, "MV wird NICHT \u00fcber die offizielle Mac App genutzt.");
    }

    private void finalizeDownload(DatenDownload datenDownload, Start start, HttpDownloadState state) {
        this.deleteIfEmpty(new File(datenDownload.arr[29]));
        if (Boolean.parseBoolean(datenDownload.arr[34])) {
            this.writeSpotlightComment(datenDownload, state == HttpDownloadState.CANCEL);
        }
        this.fertigmeldung(datenDownload, start, state == HttpDownloadState.CANCEL);
        switch (state) {
            case CANCEL: {
                datenDownload.resetDownload();
                break;
            }
            default: {
                start.restSekunden = -1L;
                start.percent = 1000;
                datenDownload.mVFilmSize.setAktSize(-1L);
            }
        }
        this.notifyStartEvent(datenDownload);
        if (SystemInfo.isMacOSX() && this.daten.mediathekGui != null) {
            Application.getApplication().requestUserAttention(false);
        }
    }

    private void notifyStartEvent(DatenDownload datenDownload) {
        ListenerMediathekView.notify(14, StarterClass.class.getSimpleName());
        if (datenDownload != null && datenDownload.quelle == 1) {
            ListenerMediathekView.notify(15, StarterClass.class.getSimpleName());
        }
    }

    private class DirectHttpDownloadThread
    extends Thread {
        private final DatenDownload datenDownload;
        private final Start start;
        private HttpURLConnection conn = null;
        private static final int TIMEOUT = 250000;
        private HttpDownloadState state = HttpDownloadState.DOWNLOAD;
        private long downloaded = 0L;
        private File file = null;
        private String responseCode;
        private String exMessage;
        private FileOutputStream fos = null;
        private final Timer bandwidthCalculationTimer;
        private boolean retAbbrechen;
        private boolean dialogAbbrechenIsVis;

        public DirectHttpDownloadThread(DatenDownload d, Timer bandwidthCalculationTimer) {
            this.bandwidthCalculationTimer = bandwidthCalculationTimer;
            this.datenDownload = d;
            this.start = this.datenDownload.start;
            this.setName("DIRECT DL THREAD_" + d.arr[5]);
            this.start.status = (byte)2;
            StarterClass.this.notifyStartEvent(this.datenDownload);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getContentLength(URL url) {
            int TIMEOUT_LENGTH = 5000;
            long ret = -1L;
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("User-Agent", Daten.getUserAgent());
                connection.setReadTimeout(5000);
                connection.setConnectTimeout(5000);
                if (connection.getResponseCode() < 400) {
                    ret = connection.getContentLengthLong();
                }
                if (ret < 300000L) {
                    ret = -1L;
                }
            }
            catch (Exception ex) {
                ret = -1L;
                Log.fehlerMeldung(643298301, ex);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            return ret;
        }

        private void setupHttpConnection(HttpURLConnection conn) {
            conn.setRequestProperty("Range", "bytes=" + this.downloaded + "-");
            conn.setRequestProperty("User-Agent", Daten.getUserAgent());
            conn.setDoInput(true);
            conn.setDoOutput(true);
        }

        private void downloadContent() throws Exception {
            int len;
            if (Boolean.parseBoolean(this.datenDownload.arr[33])) {
                MVInfoFile.writeInfoFile(this.datenDownload);
            }
            if (Boolean.parseBoolean(this.datenDownload.arr[35])) {
                MVSubtitle.writeSubtitle(this.datenDownload);
            }
            this.datenDownload.interruptRestart();
            this.start.mVInputStream = new MVInputStream(this.conn.getInputStream(), this.bandwidthCalculationTimer);
            this.fos = new FileOutputStream(this.file, this.downloaded != 0L);
            this.datenDownload.mVFilmSize.addAktSize(this.downloaded);
            byte[] buffer = new byte[4096];
            long pp = 0L;
            long startProzent = -1L;
            long aktSize = 0L;
            boolean melden = false;
            while ((len = this.start.mVInputStream.read(buffer)) != -1 && !this.start.stoppen) {
                long aktBandwidth;
                this.downloaded += (long)len;
                this.fos.write(buffer, 0, len);
                this.datenDownload.mVFilmSize.addAktSize(len);
                if (aktSize != this.datenDownload.mVFilmSize.getAktSize()) {
                    aktSize = this.datenDownload.mVFilmSize.getAktSize();
                    melden = true;
                }
                if (this.datenDownload.mVFilmSize.getSize() > 0L) {
                    long p = aktSize * 1000L / this.datenDownload.mVFilmSize.getSize();
                    if (startProzent == -1L) {
                        startProzent = p;
                    }
                    if (p == 0L) {
                        p = 1L;
                    } else if (p >= 1000L) {
                        p = 999L;
                    }
                    this.start.percent = (int)p;
                    if (p != pp) {
                        pp = p;
                        if (p > 2L && p > startProzent) {
                            int diffZeit = this.start.startZeit.diffInSekunden();
                            int restProzent = 1000 - (int)p;
                            this.start.restSekunden = (long)(diffZeit * restProzent) / (p - startProzent);
                            this.bereitsAnschauen(this.datenDownload);
                        }
                        melden = true;
                    }
                }
                if ((aktBandwidth = this.start.mVInputStream.getBandwidth()) != this.start.bandbreite) {
                    this.start.bandbreite = aktBandwidth;
                    melden = true;
                }
                if (!melden) continue;
                ListenerMediathekView.notify(13, StarterClass.class.getName());
                melden = false;
            }
            Log.systemMeldung(this.start.mVInputStream.toString());
            if (!this.start.stoppen) {
                this.start.status = this.datenDownload.quelle == 1 ? (byte)3 : (StarterClass.this.pruefen(this.datenDownload, this.start) ? (byte)3 : (byte)4);
            }
        }

        @Override
        public synchronized void run() {
            StarterClass.this.startmeldung(this.datenDownload, this.start);
            try {
                Files.createDirectories(Paths.get(this.datenDownload.arr[28], new String[0]), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                URL url = new URL(this.datenDownload.arr[19]);
                this.datenDownload.mVFilmSize.setSize(this.getContentLength(url));
                this.datenDownload.mVFilmSize.setAktSize(0L);
                this.conn = (HttpURLConnection)url.openConnection();
                this.conn.setConnectTimeout(250000);
                this.conn.setReadTimeout(250000);
                this.file = new File(this.datenDownload.arr[29]);
                if (!this.cancelDownload()) {
                    this.setupHttpConnection(this.conn);
                    this.conn.connect();
                    int httpResponseCode = this.conn.getResponseCode();
                    if (httpResponseCode >= 400) {
                        if (httpResponseCode == 416) {
                            this.conn.disconnect();
                            this.conn = (HttpURLConnection)url.openConnection();
                            this.downloaded = 0L;
                            this.setupHttpConnection(this.conn);
                            this.conn.connect();
                            this.state = this.conn.getResponseCode() >= 400 ? HttpDownloadState.ERROR : HttpDownloadState.DOWNLOAD;
                        } else {
                            this.responseCode = "Responsecode: " + this.conn.getResponseCode() + "\n" + this.conn.getResponseMessage();
                            Log.fehlerMeldung(915236798, "HTTP-Fehler: " + this.conn.getResponseCode() + " " + this.conn.getResponseMessage());
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (!Daten.auto) {
                                        new MeldungDownloadfehler((Frame)((StarterClass)StarterClass.this).daten.mediathekGui, "URL des Films:\n" + ((DirectHttpDownloadThread)DirectHttpDownloadThread.this).datenDownload.arr[19] + "\n\n" + DirectHttpDownloadThread.this.responseCode + "\n", DirectHttpDownloadThread.this.datenDownload).setVisible(true);
                                    }
                                }
                            });
                            this.state = HttpDownloadState.ERROR;
                        }
                    }
                }
                switch (this.state) {
                    case DOWNLOAD: {
                        this.downloadContent();
                        break;
                    }
                    case CANCEL: {
                        break;
                    }
                    case ERROR: {
                        this.start.status = (byte)4;
                    }
                }
            }
            catch (Exception ex) {
                this.exMessage = ex.getLocalizedMessage();
                Log.fehlerMeldung(316598941, ex, "Fehler");
                this.start.status = (byte)4;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!Daten.auto) {
                            new MeldungDownloadfehler((Frame)((StarterClass)StarterClass.this).daten.mediathekGui, DirectHttpDownloadThread.this.exMessage, DirectHttpDownloadThread.this.datenDownload).setVisible(true);
                        }
                    }
                });
            }
            try {
                if (this.start.mVInputStream != null) {
                    this.start.mVInputStream.close();
                }
                if (this.fos != null) {
                    this.fos.close();
                }
                if (this.conn != null) {
                    this.conn.disconnect();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            StarterClass.this.finalizeDownload(this.datenDownload, this.start, this.state);
        }

        private boolean cancelDownload() {
            if (!this.file.exists()) {
                return false;
            }
            if (Daten.auto) {
                return false;
            }
            this.dialogAbbrechenIsVis = true;
            this.retAbbrechen = true;
            if (SwingUtilities.isEventDispatchThread()) {
                this.retAbbrechen = this.abbrechen_();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DirectHttpDownloadThread.this.retAbbrechen = DirectHttpDownloadThread.this.abbrechen_();
                        DirectHttpDownloadThread.this.dialogAbbrechenIsVis = false;
                    }
                });
            }
            while (this.dialogAbbrechenIsVis) {
                try {
                    this.wait(100L);
                }
                catch (Exception exception) {}
            }
            return this.retAbbrechen;
        }

        private boolean abbrechen_() {
            boolean result = false;
            if (this.file.exists()) {
                DialogContinueDownload dialogContinueDownload = new DialogContinueDownload(((StarterClass)StarterClass.this).daten.mediathekGui, this.datenDownload, true);
                dialogContinueDownload.setVisible(true);
                switch (dialogContinueDownload.getResult()) {
                    case CANCELLED: {
                        this.state = HttpDownloadState.CANCEL;
                        result = true;
                        break;
                    }
                    case CONTINUE: {
                        this.downloaded = this.file.length();
                        break;
                    }
                    case RESTART_WITH_NEW_NAME: {
                        if (!dialogContinueDownload.isNewName()) break;
                        ListenerMediathekView.notify(9, this.getClass().getSimpleName());
                        try {
                            Files.createDirectories(Paths.get(this.datenDownload.arr[28], new String[0]), new FileAttribute[0]);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.file = new File(this.datenDownload.arr[29]);
                    }
                }
            }
            return result;
        }

        private void bereitsAnschauen(DatenDownload datenDownload) {
            long zeitGeladen;
            if (datenDownload.film != null && datenDownload.start != null && datenDownload.film.dauerL > 0L && datenDownload.start.restSekunden > 0L && datenDownload.mVFilmSize.getAktSize() > 0L && datenDownload.mVFilmSize.getSize() > 0L && (double)(zeitGeladen = datenDownload.film.dauerL * datenDownload.mVFilmSize.getAktSize() / datenDownload.mVFilmSize.getSize()) > (double)datenDownload.start.restSekunden * 1.1) {
                datenDownload.start.beginnAnschauen = true;
            }
        }
    }

    private class ExternalProgramDownloadThread
    extends Thread {
        private DatenDownload datenDownload;
        private Start start;
        private RuntimeExec runtimeExec;
        private File file;
        private String exMessage = "";
        private boolean retAbbrechen;
        private boolean dialogAbbrechenIsVis;
        private HttpDownloadState state = HttpDownloadState.DOWNLOAD;

        public ExternalProgramDownloadThread(DatenDownload d) {
            this.setName("PROGRAMM DL THREAD: " + d.arr[5]);
            this.datenDownload = d;
            this.start = this.datenDownload.start;
            this.start.status = (byte)2;
            this.file = new File(this.datenDownload.arr[29]);
            StarterClass.this.notifyStartEvent(this.datenDownload);
            try {
                if (Boolean.parseBoolean(this.datenDownload.arr[33])) {
                    MVInfoFile.writeInfoFile(this.datenDownload);
                }
                if (Boolean.parseBoolean(this.datenDownload.arr[35])) {
                    MVSubtitle.writeSubtitle(this.datenDownload);
                }
                Files.createDirectories(Paths.get(this.datenDownload.arr[28], new String[0]), new FileAttribute[0]);
            }
            catch (IOException iOException) {
            }
            catch (Exception ex) {
                Log.fehlerMeldung(469365281, ex);
            }
        }

        @Override
        public synchronized void run() {
            long filesize = -1L;
            boolean stat_start = false;
            boolean stat_laufen = true;
            int stat_restart = 3;
            int stat_pruefen = 4;
            int stat_fertig_ok = 10;
            int stat_fertig_fehler = 11;
            int stat_ende = 99;
            int stat = 0;
            try {
                if (!this.cancelDownload()) {
                    block14: while (stat < 99) {
                        switch (stat) {
                            case 0: {
                                if (this.starten()) {
                                    if (this.datenDownload.isDownloadManager()) {
                                        stat = 10;
                                        break;
                                    }
                                    stat = 1;
                                    break;
                                }
                                stat = 3;
                                break;
                            }
                            case 1: {
                                try {
                                    if (this.start.stoppen) {
                                        stat = 10;
                                        if (this.start.process == null) continue block14;
                                        this.start.process.destroy();
                                        break;
                                    }
                                    int exitV = this.start.process.exitValue();
                                    if (exitV != 0) {
                                        stat = 3;
                                        break;
                                    }
                                    stat = 4;
                                }
                                catch (Exception ex) {
                                    try {
                                        this.wait(2000L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                break;
                            }
                            case 3: {
                                if (!this.datenDownload.isRestart()) {
                                    stat = 11;
                                    break;
                                }
                                if (filesize == -1L) {
                                    StarterClass.this.deleteIfEmpty(this.file);
                                    if (this.file.exists()) {
                                        filesize = this.file.length();
                                        stat = 0;
                                        break;
                                    }
                                    if (this.start.startcounter < 3) {
                                        stat = 0;
                                        break;
                                    }
                                    stat = 11;
                                    break;
                                }
                                if (!this.file.exists()) {
                                    stat = 11;
                                    break;
                                }
                                if (this.file.length() > filesize) {
                                    filesize = this.file.length();
                                    stat = 0;
                                    break;
                                }
                                stat = 11;
                                break;
                            }
                            case 4: {
                                if (this.datenDownload.quelle == 1 || this.datenDownload.isDownloadManager()) {
                                    stat = 10;
                                    break;
                                }
                                if (StarterClass.this.pruefen(this.datenDownload, this.start)) {
                                    stat = 10;
                                    break;
                                }
                                stat = 11;
                                break;
                            }
                            case 11: {
                                this.start.status = (byte)4;
                                stat = 99;
                                break;
                            }
                            case 10: {
                                this.start.status = (byte)3;
                                stat = 99;
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.exMessage = ex.getLocalizedMessage();
                Log.fehlerMeldung(395623710, ex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!Daten.auto) {
                            new MeldungDownloadfehler((Frame)((StarterClass)StarterClass.this).daten.mediathekGui, ExternalProgramDownloadThread.this.exMessage, ExternalProgramDownloadThread.this.datenDownload).setVisible(true);
                        }
                    }
                });
            }
            StarterClass.this.finalizeDownload(this.datenDownload, this.start, this.state);
        }

        private boolean starten() {
            boolean ret = false;
            ++this.start.startcounter;
            StarterClass.this.startmeldung(this.datenDownload, this.start);
            this.runtimeExec = new RuntimeExec(this.datenDownload);
            this.start.process = this.runtimeExec.exec(true);
            if (this.start.process != null) {
                ret = true;
            }
            return ret;
        }

        private boolean cancelDownload() {
            if (this.datenDownload.isDownloadManager()) {
                return false;
            }
            if (!this.file.exists()) {
                return false;
            }
            if (Daten.auto) {
                try {
                    Files.deleteIfExists(this.file.toPath());
                    this.file = new File(this.datenDownload.arr[29]);
                }
                catch (IOException ex) {
                    Log.fehlerMeldung(795623145, (Exception)ex, "file exists: " + this.datenDownload.arr[29]);
                }
                return false;
            }
            this.dialogAbbrechenIsVis = true;
            this.retAbbrechen = true;
            if (SwingUtilities.isEventDispatchThread()) {
                this.retAbbrechen = this.abbrechen_();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExternalProgramDownloadThread.this.retAbbrechen = ExternalProgramDownloadThread.this.abbrechen_();
                        ExternalProgramDownloadThread.this.dialogAbbrechenIsVis = false;
                    }
                });
            }
            while (this.dialogAbbrechenIsVis) {
                try {
                    this.wait(100L);
                }
                catch (Exception exception) {}
            }
            return this.retAbbrechen;
        }

        private boolean abbrechen_() {
            boolean result = false;
            if (this.file.exists()) {
                DialogContinueDownload dialogContinueDownload = new DialogContinueDownload(((StarterClass)StarterClass.this).daten.mediathekGui, this.datenDownload, false);
                dialogContinueDownload.setVisible(true);
                switch (dialogContinueDownload.getResult()) {
                    case CANCELLED: {
                        this.state = HttpDownloadState.CANCEL;
                        result = true;
                        break;
                    }
                    case CONTINUE: {
                        try {
                            Files.deleteIfExists(this.file.toPath());
                            this.file = new File(this.datenDownload.arr[29]);
                        }
                        catch (Exception ex) {
                            Log.fehlerMeldung(945120398, ex, "file exists: " + this.datenDownload.arr[29]);
                        }
                        break;
                    }
                    case RESTART_WITH_NEW_NAME: {
                        if (!dialogContinueDownload.isNewName()) break;
                        this.datenDownload.aufrufBauen();
                        ListenerMediathekView.notify(9, this.getClass().getSimpleName());
                        try {
                            Files.createDirectories(Paths.get(this.datenDownload.arr[28], new String[0]), new FileAttribute[0]);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.file = new File(this.datenDownload.arr[29]);
                    }
                }
            }
            return result;
        }
    }

    private class Starten
    extends Thread {
        private DatenDownload datenDownload;
        private Timer bandwidthCalculationTimer;

        public Starten() {
            this.setName("DownloadStarter Daemon Thread");
            this.setDaemon(true);
            this.bandwidthCalculationTimer = new Timer("BandwidthCalculationTimer");
        }

        @Override
        public synchronized void run() {
            while (!this.isInterrupted()) {
                try {
                    while ((this.datenDownload = this.getNextStart()) != null) {
                        this.startStarten(this.datenDownload);
                        Starten.sleep(5000L);
                    }
                    Daten.listeDownloadsButton.buttonStartsPutzen();
                    Starten.sleep(3000L);
                }
                catch (Exception ex) {
                    Log.fehlerMeldung(613822015, ex);
                }
            }
        }

        private synchronized DatenDownload getNextStart() throws InterruptedException {
            if (StarterClass.this.pause) {
                Starten.sleep(5000L);
                StarterClass.this.pause = false;
            }
            return Daten.listeDownloads.getNextStart();
        }

        private void startStarten(DatenDownload datenDownload) {
            datenDownload.start.startZeit = new Datum();
            ListenerMediathekView.notify(13, StarterClass.class.getName());
            switch (datenDownload.art) {
                case 2: {
                    ExternalProgramDownloadThread downloadThread = new ExternalProgramDownloadThread(datenDownload);
                    downloadThread.start();
                    break;
                }
                case 1: {
                    DirectHttpDownloadThread downloadThread = new DirectHttpDownloadThread(datenDownload, this.bandwidthCalculationTimer);
                    downloadThread.start();
                    break;
                }
                default: {
                    Log.fehlerMeldung(789356001, "StarterClass.Starten - Switch-default");
                }
            }
        }
    }

    private static enum HttpDownloadState {
        CANCEL,
        ERROR,
        DOWNLOAD;

    }
}

