/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import com.jidesoft.utils.SystemInfo;
import com.jidesoft.utils.ThreadCheckingRepaintManager;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import mediathek.MediathekAuto;
import mediathek.MediathekGui;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.mac.MediathekGuiMac;
import mediathek.tool.MVSingleInstance;

public class Main {
    private static void cleanupOsxFiles() {
        try {
            Path oldFilmList = Paths.get(Daten.getSettingsDirectory_String() + File.separator + "filme.json", new String[0]);
            Files.deleteIfExists(oldFilmList);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(final String[] args) {
        if (SystemInfo.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            Main.cleanupOsxFiles();
        }
        StartupMode state = StartupMode.GUI;
        try {
            String tmp = System.getProperty("http.proxyUser", System.getProperty("https.proxyUser"));
            if (tmp != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        String proxyUser = System.getProperty("http.proxyUser");
                        String proxyPassword = System.getProperty("http.proxyPassword");
                        return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                    }
                });
                Log.systemMeldung("Proxy Authentication: (" + System.getProperty("http.proxyUser") + ")");
            } else {
                Log.systemMeldung("Proxy Authentication: not configured");
            }
        }
        catch (SecurityException se) {
            Log.systemMeldung("Proxy Authentication: cannot access proxyUser / proxyPassword" + se.toString());
        }
        if (args != null) {
            block21: for (String s : args) {
                switch (s = s.toLowerCase()) {
                    case "-auto": {
                        state = StartupMode.AUTO;
                        continue block21;
                    }
                    case "-fastauto": {
                        state = StartupMode.FASTAUTO;
                        continue block21;
                    }
                    case "-v": {
                        Log.versionsMeldungen();
                        System.exit(0);
                        continue block21;
                    }
                    case "-d": {
                        Daten.debug = true;
                        continue block21;
                    }
                    case "-m": {
                        Daten.startMaximized = true;
                    }
                }
            }
        }
        if (GraphicsEnvironment.isHeadless() && state == StartupMode.GUI) {
            System.err.println("MediathekView wurde nicht als Kommandozeilenprogramm gestartet.");
            System.err.println("Startmodus wurde auf -auto ge\u00e4ndert.");
            System.err.println();
            state = StartupMode.AUTO;
        }
        switch (state) {
            case AUTO: {
                new MediathekAuto(args).starten();
                break;
            }
            case FASTAUTO: {
                MediathekAuto mvAuto = new MediathekAuto(args);
                mvAuto.setFastAuto(true);
                mvAuto.starten();
                break;
            }
            case GUI: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (Daten.debug) {
                            MVSingleInstance singleInstanceWatcher;
                            RepaintManager.setCurrentManager((RepaintManager)new ThreadCheckingRepaintManager());
                            if (SystemInfo.isMacOSX() && (singleInstanceWatcher = new MVSingleInstance()).isAppAlreadyActive()) {
                                JOptionPane.showMessageDialog(null, "MediathekView is already running!");
                            }
                        }
                        if (SystemInfo.isMacOSX()) {
                            new MediathekGuiMac(args).setVisible(true);
                        } else {
                            new MediathekGui(args).setVisible(true);
                        }
                    }
                });
            }
        }
    }

    public static enum StartupMode {
        GUI,
        AUTO,
        FASTAUTO;

    }
}

