/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Utils {
    private static final ThreadLocal<SimpleDateFormat> utcDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> localDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("MMM d, yyyy h:mm a", Locale.ENGLISH);
        }
    };
    private static final ThreadLocal<SimpleDateFormat> estDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("MMM d, yyyy h:mm a", Locale.ENGLISH);
            format.setTimeZone(TimeZone.getTimeZone("EST"));
            return format;
        }
    };
    private static final Log log = LogFactory.getLog(Utils.class);
    private static final ExecutorService remoteLogPool = Executors.newFixedThreadPool(1);
    private static final String[] SENSITIVE_KEYS = new String[]{"password", "phoneHome", "phoneWork", "phoneMobile", "addressLine1", "addressLine2", "zipPostalCode", "idNo", "annualIncome", "networthLiquid", "networthTotal", "employerCompany", "employerAddressLine1", "employerAddressLine2", "employerZipPostalCode"};

    private Utils() {
    }

    public static String monetaryFormat(Double number) {
        if (Double.compare(number, 0.0) == 0) {
            return "0.00";
        }
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getCurrencyInstance();
        formatter.setNegativePrefix("-");
        formatter.setNegativeSuffix("");
        formatter.setPositivePrefix("");
        formatter.setPositiveSuffix("");
        return formatter.format(number);
    }

    public static String formatNumber(Double number, int decimal) {
        String formatter = "###,###,###,###,###,###,##0.";
        do {
            formatter = formatter.concat("#");
        } while (--decimal > 0);
        return new DecimalFormat(formatter).format(number);
    }

    public static String formatNumberNoComma(Double number, int decimal) {
        String formatter = "#.";
        do {
            formatter = formatter.concat("#");
        } while (--decimal > 0);
        return new DecimalFormat(formatter).format(number);
    }

    public static Double formattedNumtoDouble(String formattedNum) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance();
        Double result = null;
        try {
            Number number = formatter.parse(formattedNum);
            result = number.doubleValue();
        }
        catch (ParseException ex) {
            log.error(null, (Throwable)ex);
        }
        return result;
    }

    public static boolean validateNumber(String numberS) {
        if (numberS == null || numberS.isEmpty()) {
            return false;
        }
        boolean valid = false;
        try {
            if (Double.parseDouble(numberS) > 0.0) {
                valid = true;
            }
        }
        catch (NumberFormatException ex) {
            log.error(null, (Throwable)ex);
        }
        return valid;
    }

    public static String utcToLocalAndEst(String utcDate) {
        if (utcDate == null) {
            return "";
        }
        String dateTime = "";
        try {
            Date date = utcDateFormat.get().parse(utcDate);
            String localDate = localDateFormat.get().format(date);
            String estDate = estDateFormat.get().format(date);
            dateTime = String.format("%1$s (%2$s EST)", localDate, estDate);
        }
        catch (ParseException ex) {
            log.error(null, (Throwable)ex);
        }
        return dateTime;
    }

    public static Date getDateFromString(String utcDate) {
        Date date = null;
        try {
            date = utcDateFormat.get().parse(utcDate);
        }
        catch (ParseException ex) {
            log.error(null, (Throwable)ex);
        }
        return date;
    }

    public static long utcDateToTimestamp(String utcDate) {
        long timestamp = 0L;
        try {
            Date date = utcDateFormat.get().parse(utcDate);
            timestamp = date.getTime();
        }
        catch (ParseException ex) {
            log.error(null, (Throwable)ex);
        }
        return timestamp;
    }

    public static void remoteLog(String type, int statusCode, String message, Map<String, Object> params) {
    }
}

