/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.trading.ForgotPassword;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.gui.trading.TnC;
import org.yccheok.jstock.gui.trading.TradingView;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.api.SessionManager;
import org.yccheok.jstock.trading.api.User;

public class SignIn {
    private static final Log log = LogFactory.getLog(SignIn.class);
    private Button signInBtn;
    private StackPane signInStack;
    private TextField userField;
    private PasswordField pwdField;
    private Label errorText;
    private ProgressIndicator pi = null;
    private GridPane signInGrid;
    private HBox lostPwdBox;
    private HBox tncBox;
    private Hyperlink lostPwdLink;
    private CheckBox rememberChkBox;
    private BorderPane borderPane;
    private Hyperlink learnMoreLink;
    private static final SignIn INSTANCE = new SignIn();

    private SignIn() {
    }

    public static SignIn getInstance() {
        return INSTANCE;
    }

    public Node show() {
        this.initUI();
        this.signInHandler();
        this.lostPwdHandler();
        this.learnMoreHandler();
        return this.borderPane;
    }

    private void addRowConstraint() {
        RowConstraints rr = new RowConstraints();
        rr.setVgrow(Priority.ALWAYS);
        this.signInGrid.getRowConstraints().add((Object)rr);
    }

    private void initUI() {
        this.signInBtn = new Button(DriveWealthBundle.getString("Sign_in"));
        this.userField = new TextField();
        this.pwdField = new PasswordField();
        this.errorText = new Label();
        this.rememberChkBox = new CheckBox();
        this.signInGrid = new GridPane();
        this.lostPwdLink = new Hyperlink(DriveWealthBundle.getString("Forgot_password") + " ?");
        this.lostPwdBox = new HBox(new Node[]{this.lostPwdLink});
        this.borderPane = new BorderPane();
        this.learnMoreLink = new Hyperlink(DriveWealthBundle.getString("Learn_more"));
        this.signInGrid.setAlignment(Pos.CENTER);
        this.signInGrid.setPadding(new Insets(25.0, 25.0, 25.0, 25.0));
        this.signInGrid.setId("signin-grid");
        int row = 0;
        Image image = new Image(SignIn.class.getResourceAsStream("/images/trading/drivewealth-logo.png"));
        ImageView imageView = new ImageView(image);
        this.addRowConstraint();
        this.signInGrid.add((Node)imageView, 0, row++);
        GridPane.setHalignment((Node)imageView, (HPos)HPos.CENTER);
        this.addRowConstraint();
        this.userField.setPromptText(DriveWealthBundle.getString("Username"));
        this.signInGrid.add((Node)this.userField, 0, row++);
        this.addRowConstraint();
        this.pwdField.setPromptText(DriveWealthBundle.getString("Password"));
        this.signInGrid.add((Node)this.pwdField, 0, row++);
        this.addRowConstraint();
        this.errorText.managedProperty().bind((ObservableValue)this.errorText.visibleProperty());
        this.errorText.setWrapText(true);
        this.errorText.setVisible(false);
        this.signInGrid.add((Node)this.errorText, 0, row++);
        this.addRowConstraint();
        HBox rememberBox = new HBox();
        rememberBox.getStyleClass().add((Object)"hbox-border");
        rememberBox.setSpacing(5.0);
        rememberBox.getChildren().addAll((Object[])new Node[]{this.rememberChkBox, new Label(DriveWealthBundle.getString("Remember_me"))});
        AnchorPane anchorPane = new AnchorPane(new Node[]{rememberBox, this.lostPwdBox});
        AnchorPane.setLeftAnchor((Node)rememberBox, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.lostPwdBox, (Double)0.0);
        this.signInGrid.add((Node)anchorPane, 0, row++);
        StackPane.setAlignment((Node)anchorPane, (Pos)Pos.CENTER);
        this.addRowConstraint();
        this.signInBtn.getStyleClass().add((Object)"green-btn");
        this.signInBtn.setMaxWidth(Double.MAX_VALUE);
        this.signInBtn.setMaxHeight(Double.MAX_VALUE);
        this.signInBtn.setTextAlignment(TextAlignment.CENTER);
        this.signInBtn.setDefaultButton(true);
        StackPane.setAlignment((Node)this.signInBtn, (Pos)Pos.CENTER);
        this.signInStack = new StackPane();
        this.signInStack.getChildren().add((Object)this.signInBtn);
        this.signInGrid.add((Node)this.signInStack, 0, row++);
        GridPane.setHalignment((Node)this.signInStack, (HPos)HPos.CENTER);
        GridPane.setMargin((Node)this.signInStack, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
        RowConstraints rr = new RowConstraints();
        rr.setVgrow(Priority.NEVER);
        this.signInGrid.getRowConstraints().add((Object)rr);
        this.tncBox = TnC.getInstance().show();
        this.signInGrid.add((Node)this.tncBox, 0, row++);
        GridPane.setHalignment((Node)this.tncBox, (HPos)HPos.CENTER);
        GridPane.setValignment((Node)this.tncBox, (VPos)VPos.TOP);
        GridPane.setMargin((Node)this.tncBox, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
        ColumnConstraints cc = new ColumnConstraints();
        cc.setPercentWidth(50.0);
        cc.setHgrow(Priority.ALWAYS);
        this.signInGrid.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{cc});
        Label sloganLbl = new Label(DriveWealthBundle.getString("Low_cost_to_start_invest"));
        sloganLbl.setId("slogan-banner");
        this.learnMoreLink.setId("learn-more-link");
        Label noAccYetLbl = new Label(DriveWealthBundle.getString("No_account_yet"));
        noAccYetLbl.setId("slogan-banner");
        ColumnConstraints leftFiller = new ColumnConstraints();
        leftFiller.setHgrow(Priority.ALWAYS);
        ColumnConstraints rightFiller = new ColumnConstraints();
        rightFiller.setHgrow(Priority.ALWAYS);
        GridPane topGrid = new GridPane();
        topGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{leftFiller, new ColumnConstraints(), new ColumnConstraints(), new ColumnConstraints(), new ColumnConstraints(), rightFiller});
        topGrid.getStyleClass().add((Object)"red-background");
        topGrid.setPadding(new Insets(15.0, 10.0, 15.0, 10.0));
        topGrid.setHgap(2.0);
        topGrid.add((Node)sloganLbl, 1, 0);
        topGrid.add((Node)this.learnMoreLink, 2, 0);
        topGrid.add((Node)noAccYetLbl, 3, 0);
        this.borderPane.setTop((Node)topGrid);
        this.borderPane.setCenter((Node)this.signInGrid);
        Platform.runLater(() -> this.userField.requestFocus());
    }

    private void signInHandler() {
        this.signInBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SignIn.this.errorText.setVisible(false);
                String userName = SignIn.this.userField.getText();
                String password = SignIn.this.pwdField.getText();
                if (userName.isEmpty() || password.isEmpty()) {
                    SignIn.this.showError(DriveWealthBundle.getString("Enter_username_password"));
                    return;
                }
                Task loginTask = SignIn.this.createLoginTask(userName, password);
                SignIn.this.showLoggingIn(loginTask);
            }
        });
    }

    public void showLoggingIn(Task task) {
        this.removeProgIndicatorIfExist();
        this.pi = new ProgressIndicator();
        this.pi.setMaxHeight(30.0);
        this.pi.setMaxWidth(30.0);
        StackPane.setAlignment((Node)this.pi, (Pos)Pos.CENTER);
        this.signInStack.getChildren().add((Object)this.pi);
        this.pi.visibleProperty().bind((ObservableValue)task.runningProperty());
        this.signInBtn.disableProperty().bind((ObservableValue)task.runningProperty());
    }

    private Task createLoginTask(final String userName, final String password) {
        Task<Pair<String, String>> loginTask = new Task<Pair<String, String>>(){

            protected Pair<String, String> call() {
                Pair<String, String> login = SessionManager.getInstance().login(userName, password, null);
                return login;
            }
        };
        loginTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>((Task)loginTask){
            final /* synthetic */ Task val$loginTask;
            {
                this.val$loginTask = task;
            }

            public void handle(WorkerStateEvent t) {
                SignIn.this.removeProgIndicatorIfExist();
                Pair login = (Pair)this.val$loginTask.getValue();
                String error = (String)login.second;
                if (error != null) {
                    SignIn.this.showError(error);
                    return;
                }
                SignIn.this.userField.clear();
                SignIn.this.pwdField.clear();
                User user = SessionManager.getInstance().getUser();
                log.info((Object)("Successfully Sign In, userID: " + user.userID));
                TradingView.getInstance().showPortfolio();
                JStock jStock = JStock.instance();
                boolean remember = SignIn.this.rememberChkBox.selectedProperty().get();
                jStock.getJStockOptions().setDriveWealthRememberLogin(remember);
                if (remember) {
                    String sessionKey = SessionManager.getInstance().getSessionKey();
                    jStock.getJStockOptions().setDriveWealthSessionKey(sessionKey);
                }
            }
        });
        loginTask.setOnFailed(arg_0 -> this.lambda$createLoginTask$1((Task)loginTask, arg_0));
        loginTask.setOnCancelled(ev -> {
            log.error((Object)("login Task cancelled ... " + ev.toString()));
            this.removeProgIndicatorIfExist();
            this.showError("Login task is cancelled.");
        });
        new Thread((Runnable)loginTask).start();
        return loginTask;
    }

    public Task rememberSessionLogin(final String sessionKey) {
        Task<Boolean> task = new Task<Boolean>(){

            protected Boolean call() {
                return SessionManager.getInstance().loginFromSession(sessionKey);
            }
        };
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                SignIn.this.removeProgIndicatorIfExist();
                Boolean status = (Boolean)t.getSource().getValue();
                if (!status.booleanValue()) {
                    return;
                }
                TradingView.getInstance().showPortfolio();
            }
        });
        task.setOnFailed(ev -> {
            log.error((Object)("rememberSessionLogin Task failed - " + ev.toString()));
            this.removeProgIndicatorIfExist();
        });
        task.setOnCancelled(ev -> {
            log.error((Object)("rememberSessionLogin Task cancelled - " + ev.toString()));
            this.removeProgIndicatorIfExist();
        });
        new Thread((Runnable)task).start();
        Platform.runLater(() -> this.lambda$rememberSessionLogin$5((Task)task));
        return task;
    }

    private void removeProgIndicatorIfExist() {
        if (this.pi != null) {
            if (this.signInStack.getChildren().contains((Object)this.pi)) {
                this.signInStack.getChildren().remove((Object)this.pi);
            }
            this.pi.visibleProperty().unbind();
            this.pi = null;
        }
        this.signInBtn.disableProperty().unbind();
    }

    private void showError(String msg) {
        this.errorText.setText(msg);
        this.errorText.setTextFill((Paint)Color.FIREBRICK);
        this.errorText.setVisible(true);
    }

    private void lostPwdHandler() {
        this.lostPwdLink.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Dialog lostDlg = ForgotPassword.getInstance().show();
                lostDlg.showAndWait();
                log.info((Object)"Forgot password Dialog - Close / Cancel button pressed");
            }
        });
    }

    private void learnMoreHandler() {
        this.learnMoreLink.setOnAction(e -> GUIUtils.openURLInBrowser("https://drivewealth.com/app-support/"));
    }

    private /* synthetic */ void lambda$rememberSessionLogin$5(Task task) {
        this.showLoggingIn(task);
    }

    private /* synthetic */ void lambda$createLoginTask$1(Task loginTask, WorkerStateEvent ev) {
        log.error((Object)("login Task failed ... " + ev.toString()));
        loginTask.getException().printStackTrace();
        this.removeProgIndicatorIfExist();
        this.showError("Login task has failed -- " + loginTask.getException().toString());
    }
}

