/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.portfolio;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.NumberFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.portfolio.AutoDividendJPanel;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.portfolio.DecimalPlace;
import org.yccheok.jstock.portfolio.Dividend;
import org.yccheok.jstock.portfolio.Utils;

public class AutoDividendJDialog
extends JDialog {
    private static final Log log = LogFactory.getLog(AutoDividendJDialog.class);
    private final List<AutoDividendJPanel> autoDividendJPanels = new ArrayList<AutoDividendJPanel>();
    private List<Dividend> dividendsPressingOK = null;
    private JLabel jLabel3 = null;
    private JLabel jLabel5 = null;
    private JButton jButton1;
    private JButton jButton2;
    private JFormattedTextField jFormattedTextField1;
    private JFormattedTextField jFormattedTextField2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JXHeader jXHeader1;

    public AutoDividendJDialog(Frame parent, boolean modal, Map<Code, List<Dividend>> dividends) {
        super(parent, modal);
        this.initComponents();
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.setLayout(new BoxLayout(panel, 1));
        TreeMap<Code, List<Dividend>> treeMap = new TreeMap<Code, List<Dividend>>(new Comparator<Code>(){

            @Override
            public int compare(Code o1, Code o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        treeMap.putAll(dividends);
        for (Map.Entry entry : treeMap.entrySet()) {
            AutoDividendJPanel autoDividendJPanel = new AutoDividendJPanel(this, (List)entry.getValue());
            this.autoDividendJPanels.add(autoDividendJPanel);
            autoDividendJPanel.setAlignmentX(0.0f);
            panel.add(autoDividendJPanel);
            panel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        this.jScrollPane1.setViewportView(panel);
        this.updateTotalLabel();
        Dimension dimension = JStock.instance().getUIOptions().getDimension("AUTO_DIVIDEND_JDIALOG");
        if (dimension != null) {
            this.setSize(dimension);
        }
    }

    public void updateInstructionLabel() {
        String template = GUIBundle.getString("AutoDividendJDialog_Intruction_template");
        double tax = (Double)this.jFormattedTextField1.getValue();
        double taxRate = (Double)this.jFormattedTextField2.getValue();
        String text0 = Utils.toCurrency(DecimalPlace.Three, tax);
        String text1 = Utils.toCurrency(DecimalPlace.Three, taxRate);
        double value = 100.0 - tax - 100.0 * taxRate / 100.0;
        value = Math.max(value, 0.0);
        String text2 = Utils.toCurrencyWithSymbol(DecimalPlace.Three, value);
        String message = MessageFormat.format(template, text0, text1, text2);
        if (this.jLabel3 == null) {
            this.jLabel3 = new JLabel();
            this.jLabel3.setText(GUIBundle.getString("AutoDividendJDialog_Intruction"));
            this.jLabel3.setFont(this.jLabel3.getFont().deriveFont(this.jLabel3.getFont().getStyle() | 2));
            this.jPanel6.add(this.jLabel3);
        }
        if (this.jLabel5 == null) {
            this.jLabel5 = new JLabel();
            this.jLabel5.setFont(this.jLabel5.getFont().deriveFont(this.jLabel5.getFont().getStyle() | 2));
            this.jPanel6.add(this.jLabel5);
        }
        this.jLabel5.setText(message);
        this.jLabel3.setVisible(true);
        this.jLabel5.setVisible(true);
    }

    public void updateTotalLabel() {
        int selectedStock = 0;
        int selectedDividend = 0;
        double selectedAmount = 0.0;
        for (AutoDividendJPanel autoDividendJPanel : this.autoDividendJPanels) {
            if (!autoDividendJPanel.isSelected()) continue;
            ++selectedStock;
            selectedDividend += autoDividendJPanel.getSelectedCount();
            selectedAmount += autoDividendJPanel.getSelectedAmount();
        }
        String stock_text = selectedStock + " " + GUIBundle.getString(selectedStock <= 1 ? "AutoDividendJDialog_StockSingular" : "AutoDividendJDialog_StockPlural");
        String dividend_text = selectedDividend + " " + GUIBundle.getString(selectedDividend <= 1 ? "AutoDividendJDialog_DividendSingular" : "AutoDividendJDialog_DividendPlural");
        String total_text = Utils.toCurrencyWithSymbol(DecimalPlace.Three, selectedAmount);
        String message = MessageFormat.format(GUIBundle.getString("AutoDividendJDialog_Total_template"), stock_text, dividend_text, total_text);
        this.jLabel4.setText(message);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jXHeader1 = new JXHeader();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel5 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jFormattedTextField1 = this.getCurrencyJFormattedTextField();
        this.jLabel2 = new JLabel();
        this.jFormattedTextField2 = this.getCurrencyJFormattedTextField();
        this.jPanel6 = new JPanel();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("AutoDividendJDialog_Title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                AutoDividendJDialog.this.formWindowClosed(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton1.setText(bundle.getString("AutoDividendJDialog_Apply"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoDividendJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton2.setText(bundle.getString("AutoDividendJDialog_Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoDividendJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton2);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jXHeader1.setDescription(bundle.getString("AutoDividendJDialog_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/auto-dividend.png")));
        this.jXHeader1.setTitle(bundle.getString("AutoDividendJDialog_AutoDividend"));
        this.getContentPane().add((Component)this.jXHeader1, "North");
        this.jPanel2.setLayout(new BorderLayout(5, 5));
        this.jLabel4.setForeground(new Color(0, 0, 255));
        this.jPanel4.add(this.jLabel4);
        this.jPanel2.add((Component)this.jPanel4, "South");
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(bundle.getString("AutoDividendJDialog_Dividend")));
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(bundle.getString("AutoDividendJDialog_DividendTax")));
        this.jPanel5.setLayout(new BorderLayout());
        this.jLabel1.setText(bundle.getString("AutoDividendJDialog_Tax"));
        this.jFormattedTextField1.setText("0");
        this.jFormattedTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                AutoDividendJDialog.this.jFormattedTextField1KeyTyped(evt);
            }
        });
        this.jLabel2.setText(bundle.getString("AutoDividendJDialog_TaxRate"));
        this.jFormattedTextField2.setText("0");
        this.jFormattedTextField2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                AutoDividendJDialog.this.jFormattedTextField2KeyTyped(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFormattedTextField1, -2, 76, -2).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jFormattedTextField2, -2, 75, -2)).addContainerGap(186, Short.MAX_VALUE)));
        jPanel3Layout.linkSize(0, this.jFormattedTextField1, this.jFormattedTextField2);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField1, -2, -1, -2).addComponent(this.jFormattedTextField2, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel5.add((Component)this.jPanel3, "Center");
        this.jPanel6.setLayout(new GridLayout(2, 1, 5, 5));
        this.jPanel5.add((Component)this.jPanel6, "South");
        this.jPanel2.add((Component)this.jPanel5, "North");
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.setSize(new Dimension(420, 499));
        this.setLocationRelativeTo(null);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.dividendsPressingOK = null;
        this.setVisible(false);
        this.dispose();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dividendsPressingOK = new ArrayList<Dividend>();
        for (AutoDividendJPanel autoDividendJPanel : this.autoDividendJPanels) {
            this.dividendsPressingOK.addAll(autoDividendJPanel.getSelectedDividends());
        }
        this.setVisible(false);
        this.dispose();
    }

    private void jFormattedTextField2KeyTyped(KeyEvent evt) {
        this.update();
    }

    private void jFormattedTextField1KeyTyped(KeyEvent evt) {
        this.update();
    }

    private void formWindowClosed(WindowEvent evt) {
        JStock.instance().getUIOptions().setDimension("AUTO_DIVIDEND_JDIALOG", this.getSize());
    }

    public List<Dividend> getDividendsAfterPressingOK() {
        return this.dividendsPressingOK;
    }

    private void commitEdit() {
        try {
            this.jFormattedTextField1.commitEdit();
            this.jFormattedTextField2.commitEdit();
        }
        catch (ParseException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    private void update() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoDividendJDialog.this._update();
            }
        });
    }

    private void _update() {
        this.commitEdit();
        double tax = (Double)this.jFormattedTextField1.getValue();
        double taxRate = (Double)this.jFormattedTextField2.getValue();
        for (AutoDividendJPanel autoDividendJPanel : this.autoDividendJPanels) {
            autoDividendJPanel.updateTaxInfo(tax, taxRate);
        }
        this.updateTotalLabel();
        this.updateInstructionLabel();
    }

    private MouseListener getJFormattedTextFieldMouseListener() {
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent e) {
                if (e.getClickCount() == 2) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField tf = (JTextField)e.getSource();
                        int offset = tf.viewToModel(e.getPoint());
                        tf.setCaretPosition(offset);
                    }
                });
            }
        };
        return ml;
    }

    private JFormattedTextField getCurrencyJFormattedTextField() {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(3);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setMinimum(Double.valueOf(0.0));
        formatter.setValueClass(Double.class);
        JFormattedTextField formattedTextField = new JFormattedTextField(formatter);
        formattedTextField.addMouseListener(this.getJFormattedTextFieldMouseListener());
        return formattedTextField;
    }
}

