/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.file;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.file.Statements;

public class ThreadSafeFileLock {
    private static final Map<String, Lock> reentrantReadWriteLockMap = new HashMap<String, Lock>();
    private static final Object reentrantReadWriteLockMapMonitor = new Object();
    private static final Log log = LogFactory.getLog(Statements.class);

    private ThreadSafeFileLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock getLock(File file) {
        Lock lock;
        String canonicalPath;
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
        Object object = reentrantReadWriteLockMapMonitor;
        synchronized (object) {
            lock = reentrantReadWriteLockMap.get(canonicalPath);
            if (lock == null) {
                ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
                AtomicInteger atomicInteger = new AtomicInteger(1);
                Pair<ReentrantReadWriteLock, AtomicInteger> pair = Pair.create(reentrantReadWriteLock, atomicInteger);
                lock = new Lock(pair, canonicalPath);
                reentrantReadWriteLockMap.put(canonicalPath, lock);
            } else {
                ((AtomicInteger)lock.reentrantReadWriteLock.second).incrementAndGet();
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseLock(Lock lock) {
        Object object = reentrantReadWriteLockMapMonitor;
        synchronized (object) {
            int counter = ((AtomicInteger)lock.reentrantReadWriteLock.second).decrementAndGet();
            if (counter == 0) {
                reentrantReadWriteLockMap.remove(lock.canonicalPath);
            }
        }
    }

    public static void lockRead(Lock lock) {
        ((ReentrantReadWriteLock)lock.reentrantReadWriteLock.first).readLock().lock();
    }

    public static void unlockRead(Lock lock) {
        ((ReentrantReadWriteLock)lock.reentrantReadWriteLock.first).readLock().unlock();
    }

    public static void lockWrite(Lock lock) {
        ((ReentrantReadWriteLock)lock.reentrantReadWriteLock.first).writeLock().lock();
    }

    public static void unlockWrite(Lock lock) {
        ((ReentrantReadWriteLock)lock.reentrantReadWriteLock.first).writeLock().unlock();
    }

    public static class Lock {
        public final Pair<ReentrantReadWriteLock, AtomicInteger> reentrantReadWriteLock;
        public final String canonicalPath;

        public Lock(Pair<ReentrantReadWriteLock, AtomicInteger> reentrantReadWriteLock, String canonicalPath) {
            this.reentrantReadWriteLock = reentrantReadWriteLock;
            this.canonicalPath = canonicalPath;
        }
    }
}

