/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SimpleDate
implements Comparable<SimpleDate> {
    private final int year;
    private final int month;
    private final int date;

    public SimpleDate(int year, int month, int date) {
        this.year = year;
        this.month = month;
        this.date = date;
    }

    public SimpleDate() {
        this(Calendar.getInstance());
    }

    public SimpleDate(long timestamp) {
        this(new Date(timestamp));
    }

    @Deprecated
    public SimpleDate(Calendar calendar) {
        this(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    public SimpleDate(Date date) {
        Calendar container = Calendar.getInstance();
        container.setTime(date);
        this.year = container.get(1);
        this.month = container.get(2);
        this.date = container.get(5);
    }

    public SimpleDate(SimpleDate simpleDate) {
        this.year = simpleDate.year;
        this.month = simpleDate.month;
        this.date = simpleDate.date;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.year;
        result = 31 * result + this.month;
        result = 31 * result + this.date;
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleDate)) {
            return false;
        }
        SimpleDate simpleDate = (SimpleDate)o;
        return this.year == simpleDate.year && this.month == simpleDate.month && this.date == simpleDate.date;
    }

    @Deprecated
    public Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.year, this.month, this.date, 0, 0, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public Calendar getCalendar(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.set(this.year, this.month, this.date, 0, 0, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public Date getTime() {
        return this.getCalendar().getTime();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDate() {
        return this.date;
    }

    @Override
    public int compareTo(SimpleDate simpleDate) {
        int yearDiff = this.year - simpleDate.year;
        if (yearDiff != 0) {
            return yearDiff;
        }
        int monthDiff = this.month - simpleDate.month;
        if (monthDiff != 0) {
            return monthDiff;
        }
        return this.date - simpleDate.date;
    }

    public String toString() {
        return SimpleDate.class.getName() + "[year=" + this.year + ",month=" + this.month + ",date=" + this.date + "]";
    }
}

