/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.teddy;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.border.EmptyBorder;
import org.jdesktop.layout.GroupLayout;
import org.jhotdraw.app.Application;
import org.jhotdraw.samples.teddy.TeddyView;
import org.jhotdraw.samples.teddy.regex.MatchType;
import org.jhotdraw.samples.teddy.regex.Matcher;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class FindDialog
extends JDialog {
    private Application app;
    private Matcher matcher;
    private Preferences prefs;
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.teddy.Labels");
    public JPanel buttonPanel;
    public JTextArea findField;
    public JLabel findLabel;
    public JScrollPane findScrollPane;
    public JCheckBox ignoreCaseCheck;
    public JComboBox modeCombo;
    public JButton nextButton;
    public JPanel optionsPanel;
    public JButton previousButton;
    public JButton replaceAllButton;
    public JButton replaceAndFindButton;
    public JButton replaceButton;
    public JTextArea replaceField;
    public JLabel replaceLabel;
    public JScrollPane replaceScrollPane;
    public JCheckBox wrapAroundCheck;

    private FindDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.buttonPanel.setBorder(new EmptyBorder(0, -5, 0, -5));
        this.setAlwaysOnTop(true);
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        PreferencesUtil.installFramePrefsHandler(this.prefs, "find", this);
        this.modeCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{this.labels.getString("find.contains.text"), this.labels.getString("find.startsWith.text"), this.labels.getString("find.word.text")}));
        this.ignoreCaseCheck.setSelected(this.prefs.getBoolean("find.ignoreCase", true));
        this.wrapAroundCheck.setSelected(this.prefs.getBoolean("find.wrapAround", true));
        this.modeCombo.setSelectedIndex(Math.min(0, Math.max(this.modeCombo.getModel().getSize() - 1, this.prefs.getInt("find.mode", 0))));
        this.getRootPane().setDefaultButton(this.nextButton);
        InputMap im = new InputMap();
        LookAndFeel.loadKeyBindings(im, new String[]{"shift ENTER", "insert-break", "alt ENTER", "insert-break", "ENTER", "notify-field-accept"});
        im.setParent(this.findField.getInputMap(0));
        this.findField.setInputMap(0, im);
        im = new InputMap();
        LookAndFeel.loadKeyBindings(im, new String[]{"shift ENTER", "insert-break", "alt ENTER", "insert-break", "ENTER", "notify-field-accept"});
        im.setParent(this.replaceField.getInputMap(0));
        this.replaceField.setInputMap(0, im);
        this.pack();
    }

    public FindDialog(Application app) {
        this((Frame)null, false);
        this.app = app;
    }

    private void initComponents() {
        this.findLabel = new JLabel();
        this.replaceLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.replaceAllButton = new JButton();
        this.replaceButton = new JButton();
        this.replaceAndFindButton = new JButton();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.optionsPanel = new JPanel();
        this.ignoreCaseCheck = new JCheckBox();
        this.wrapAroundCheck = new JCheckBox();
        this.modeCombo = new JComboBox();
        this.findScrollPane = new JScrollPane();
        this.findField = new JTextArea();
        this.replaceScrollPane = new JScrollPane();
        this.replaceField = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle("Find");
        this.findLabel.setText(this.labels.getString("find.findLabel.text"));
        this.replaceLabel.setText(this.labels.getString("find.replaceWithLabel.text"));
        this.buttonPanel.setLayout(new FlowLayout(2, 5, 0));
        this.replaceAllButton.setText(this.labels.getString("find.replaceAll.text"));
        this.replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDialog.this.replaceAll(evt);
            }
        });
        this.buttonPanel.add(this.replaceAllButton);
        this.replaceButton.setText(this.labels.getString("find.replace.text"));
        this.replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDialog.this.replace(evt);
            }
        });
        this.buttonPanel.add(this.replaceButton);
        this.replaceAndFindButton.setText(this.labels.getString("find.replaceAndFind.text"));
        this.replaceAndFindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDialog.this.replaceAndFind(evt);
            }
        });
        this.buttonPanel.add(this.replaceAndFindButton);
        this.previousButton.setText(this.labels.getString("find.previous.text"));
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDialog.this.previous(evt);
            }
        });
        this.buttonPanel.add(this.previousButton);
        this.nextButton.setText(this.labels.getString("find.next.text"));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDialog.this.next(evt);
            }
        });
        this.buttonPanel.add(this.nextButton);
        this.optionsPanel.setLayout(new GridBagLayout());
        this.ignoreCaseCheck.setText(this.labels.getString("find.ignoreCase.text"));
        this.ignoreCaseCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDialog.this.ignoreCasePerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.optionsPanel.add((Component)this.ignoreCaseCheck, gridBagConstraints);
        this.wrapAroundCheck.setText(this.labels.getString("find.wrapAround.text"));
        this.wrapAroundCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDialog.this.wrapAroundPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.optionsPanel.add((Component)this.wrapAroundCheck, gridBagConstraints);
        this.modeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Contains", "Starts with", "Word"}));
        this.modeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FindDialog.this.modeChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.optionsPanel.add((Component)this.modeCombo, gridBagConstraints);
        this.findField.setLineWrap(true);
        this.findField.setRows(2);
        this.findScrollPane.setViewportView(this.findField);
        this.replaceField.setLineWrap(true);
        this.replaceField.setRows(2);
        this.replaceScrollPane.setViewportView(this.replaceField);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.buttonPanel, -1, 684, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.replaceLabel).add((Component)this.findLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.optionsPanel, -1, 600, Short.MAX_VALUE).add((Component)this.replaceScrollPane).add((Component)this.findScrollPane)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.findLabel).add((Component)this.findScrollPane, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.replaceLabel).add((Component)this.replaceScrollPane, -2, -1, -2)).addPreferredGap(0).add((Component)this.optionsPanel, -2, -1, -2).add(14, 14, 14).add((Component)this.buttonPanel, -2, -1, -2).addContainerGap(30, Short.MAX_VALUE)));
        this.pack();
    }

    private void modeChanged(ItemEvent evt) {
        if (this.prefs != null) {
            this.prefs.putInt("find.mode", this.modeCombo.getSelectedIndex());
        }
    }

    private void wrapAroundPerformed(ActionEvent evt) {
        if (this.prefs != null) {
            this.prefs.putBoolean("find.wrapAround", this.wrapAroundCheck.isSelected());
        }
    }

    private void ignoreCasePerformed(ActionEvent evt) {
        if (this.prefs != null) {
            this.prefs.putBoolean("find.ignoreCase", this.ignoreCaseCheck.isSelected());
        }
    }

    private void replace(ActionEvent evt) {
        TeddyView view = (TeddyView)this.app.getActiveView();
        if (view != null) {
            CompositeEdit edit = new CompositeEdit("Replace");
            view.fireEdit(edit);
            view.replaceRange(this.replaceField.getText(), view.getSelectionStart(), view.getSelectionEnd());
            view.fireEdit(edit);
        }
    }

    private void replaceAndFind(ActionEvent evt) {
        TeddyView view = (TeddyView)this.app.getActiveView();
        if (view != null) {
            CompositeEdit edit = new CompositeEdit("Replace And Find");
            view.fireEdit(edit);
            view.replaceRange(this.replaceField.getText(), view.getSelectionStart(), view.getSelectionEnd());
            this.next(evt);
            view.fireEdit(edit);
        }
    }

    private void previous(ActionEvent evt) {
        TeddyView view = (TeddyView)this.app.getActiveView();
        if (view != null) {
            this.updateMatcher();
            if (this.matcher != null) {
                this.matcher.setStartIndex(view.getSelectionStart() - 1);
                int pos = this.matcher.findPrevious();
                if (pos == -1 && this.wrapAroundCheck.isSelected()) {
                    pos = this.matcher.findPrevious(view.getDocument().getLength());
                }
                if (pos == -1) {
                    this.getToolkit().beep();
                } else {
                    view.select(pos, this.matcher.getFindString().length() + pos);
                }
            }
        }
    }

    private void next(ActionEvent evt) {
        TeddyView view = (TeddyView)this.app.getActiveView();
        if (view != null) {
            this.updateMatcher();
            if (this.matcher != null) {
                int pos = this.matcher.findNext(view.getSelectionEnd());
                if (pos == -1 && this.wrapAroundCheck.isSelected()) {
                    pos = this.matcher.findNext(0);
                }
                if (pos == -1) {
                    this.getToolkit().beep();
                } else {
                    view.select(pos, this.matcher.getFindString().length() + pos);
                }
            }
        }
    }

    private void replaceAll(ActionEvent evt) {
        TeddyView view = (TeddyView)this.app.getActiveView();
        if (view != null) {
            this.updateMatcher();
            if (this.matcher != null) {
                int pos = this.matcher.findNext(this.wrapAroundCheck.isSelected() ? 0 : view.getSelectionEnd());
                if (pos == -1) {
                    this.getToolkit().beep();
                } else {
                    CompositeEdit edit = new CompositeEdit("Replace All");
                    view.fireEdit(edit);
                    view.select(pos, this.matcher.getFindString().length() + pos);
                    do {
                        view.replaceRange(this.replaceField.getText(), pos, pos + this.matcher.getFindString().length());
                    } while ((pos = this.matcher.findNext(pos + this.replaceField.getText().length())) != -1);
                    view.fireEdit(edit);
                }
            }
        }
    }

    private void updateMatcher() {
        TeddyView view = (TeddyView)this.app.getActiveView();
        if (view != null) {
            MatchType matchType;
            switch (this.modeCombo.getSelectedIndex()) {
                case 0: {
                    matchType = MatchType.CONTAINS;
                    break;
                }
                case 1: {
                    matchType = MatchType.STARTS_WITH;
                    break;
                }
                default: {
                    matchType = MatchType.FULL_WORD;
                }
            }
            this.matcher = new Matcher(view.getDocument(), this.findField.getText(), !this.ignoreCaseCheck.isSelected(), matchType);
        } else {
            this.matcher = null;
        }
    }
}

