/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.util.ResourceBundleUtil;

public class LinkHandle
extends AbstractHandle {
    public LinkHandle(Figure owner) {
        super(owner);
    }

    @Override
    public boolean contains(Point p) {
        return false;
    }

    @Override
    public void draw(Graphics2D g) {
        if (SVGAttributeKeys.LINK.get(this.getOwner()) != null && SVGAttributeKeys.LINK.get(this.getOwner()).trim().length() > 0) {
            g.setColor(this.getEditor().getHandleAttribute(HandleAttributeKeys.OVERFLOW_HANDLE_STROKE_COLOR));
            Rectangle r = this.basicGetBounds();
            g.drawLine(r.x + r.width / 2 - 1, r.y, r.x, r.y);
            g.drawLine(r.x, r.y, r.x, r.y + r.height - 1);
            g.drawLine(r.x, r.y + r.height - 1, r.x + r.width / 2 - 1, r.y + r.height - 1);
            g.drawLine(r.x + r.width / 3, r.y + r.height / 2, r.x + r.width - 1, r.y + r.height / 2);
            g.drawLine(r.x + r.width - 1, r.y + r.height / 2, (int)((double)r.x + (double)r.width * 0.75 - 1.0), (int)((double)r.y + (double)r.height * 0.25));
            g.drawLine(r.x + r.width - 1, r.y + r.height / 2, (int)((double)r.x + (double)r.width * 0.75 - 1.0), (int)((double)r.y + (double)r.height * 0.75));
        }
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle2D.Double b = this.getOwner().getBounds();
        Point2D.Double p = new Point2D.Double(b.x + b.width, b.y + b.height);
        if (SVGAttributeKeys.TRANSFORM.get(this.getOwner()) != null) {
            ((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this.getOwner())).transform(p, p);
        }
        Rectangle r = new Rectangle(this.view.drawingToView(p));
        int h = this.getHandlesize();
        r.x -= h * 4;
        r.y -= h;
        r.width = h * 2;
        r.height = h;
        return r;
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
    }

    @Override
    public String getToolTipText(Point p) {
        return SVGAttributeKeys.LINK.get(this.getOwner()) != null ? ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels").getString("handle.link.toolTipText") : null;
    }
}

