/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.mini;

import java.awt.geom.Point2D;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jhotdraw.draw.BezierLabelLocator;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.ElbowLiner;
import org.jhotdraw.draw.LabeledLineConnectionFigure;
import org.jhotdraw.draw.LocatorLayouter;
import org.jhotdraw.draw.RectangleFigure;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.geom.Geom;

public class LabeledLineConnectionFigureSample {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RectangleFigure ta = new RectangleFigure();
                ta.setBounds(new Point2D.Double(10.0, 10.0), new Point2D.Double(100.0, 100.0));
                RectangleFigure tb = new RectangleFigure();
                tb.setBounds(new Point2D.Double(210.0, 110.0), new Point2D.Double(300.0, 200.0));
                LabeledLineConnectionFigure cf = new LabeledLineConnectionFigure();
                cf.setLiner(new ElbowLiner());
                cf.setLayouter(new LocatorLayouter());
                TextFigure startLabel = new TextFigure();
                LocatorLayouter.LAYOUT_LOCATOR.basicSet(startLabel, new BezierLabelLocator(0.0, -0.7853981633974483, 8.0));
                startLabel.setEditable(false);
                startLabel.setText("start");
                cf.add(startLabel);
                TextFigure endLabel = new TextFigure();
                LocatorLayouter.LAYOUT_LOCATOR.basicSet(endLabel, new BezierLabelLocator(1.0, 3.9269908169872414, 8.0));
                endLabel.setEditable(false);
                endLabel.setText("end");
                cf.add(endLabel);
                cf.setStartConnector(ta.findConnector(Geom.center(ta.getBounds()), cf));
                cf.setEndConnector(tb.findConnector(Geom.center(tb.getBounds()), cf));
                DefaultDrawing drawing = new DefaultDrawing();
                drawing.add(ta);
                drawing.add(tb);
                drawing.add(cf);
                JFrame f = new JFrame("My Drawing");
                f.setDefaultCloseOperation(3);
                f.setSize(400, 300);
                DefaultDrawingView view = new DefaultDrawingView();
                view.setDrawing(drawing);
                f.getContentPane().add(view.getComponent());
                f.setVisible(true);
            }
        });
    }
}

