/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.jhotdraw.gui.AttributeEditor;

public abstract class AbstractAttributeEditorHandler<T> {
    protected DrawingEditor drawingEditor;
    protected DrawingView view;
    protected DrawingView activeView;
    protected AttributeEditor<T> attributeEditor;
    protected AttributeKey<T> attributeKey;
    protected int updateDepth;
    protected LinkedList<Object> attributeRestoreData = new LinkedList();
    protected Map<AttributeKey, Object> defaultAttributes;
    private boolean isUpdateDrawingEditorDefaults;
    private Set<Figure> figuresOfInterest;
    private EventHandler eventHandler = new EventHandler();

    public AbstractAttributeEditorHandler(AttributeKey<T> key, AttributeEditor<T> attributeEditor, DrawingEditor drawingEditor) {
        this(key, attributeEditor, drawingEditor, true);
    }

    public AbstractAttributeEditorHandler(AttributeKey<T> key, AttributeEditor<T> attributeEditor, DrawingEditor drawingEditor, boolean updateDrawingEditorDefaults) {
        this(key, null, attributeEditor, drawingEditor, updateDrawingEditorDefaults);
    }

    public AbstractAttributeEditorHandler(AttributeKey<T> key, Map<AttributeKey, Object> defaultAttributes, AttributeEditor<T> attributeEditor, DrawingEditor drawingEditor, boolean updateDrawingEditorDefaults) {
        this.defaultAttributes = defaultAttributes == null ? Collections.emptyMap() : defaultAttributes;
        attributeEditor.setAttributeValue(key.getDefaultValue());
        this.setAttributeKey(key);
        this.setAttributeEditor(attributeEditor);
        this.setDrawingEditor(drawingEditor);
        this.isUpdateDrawingEditorDefaults = updateDrawingEditorDefaults;
    }

    public void setDrawingEditor(DrawingEditor newValue) {
        DrawingEditor oldValue = this.drawingEditor;
        if (this.drawingEditor != null) {
            this.drawingEditor.removePropertyChangeListener(this.eventHandler);
        }
        this.drawingEditor = newValue;
        if (this.drawingEditor != null) {
            this.drawingEditor.addPropertyChangeListener(this.eventHandler);
        }
        this.updateActiveView();
    }

    public DrawingEditor getDrawingEditor() {
        return this.drawingEditor;
    }

    public void setView(DrawingView newValue) {
        this.view = newValue;
        this.updateActiveView();
    }

    public DrawingView getView() {
        return this.view;
    }

    public void setUpdateDrawingEditorDefaults(boolean newValue) {
        this.isUpdateDrawingEditorDefaults = newValue;
    }

    public boolean isUpdateDrawingEditorDefaults() {
        return this.isUpdateDrawingEditorDefaults;
    }

    protected DrawingView getActiveView() {
        if (this.getView() != null) {
            return this.getView();
        }
        return this.drawingEditor.getActiveView();
    }

    public void setAttributeEditor(AttributeEditor<T> newValue) {
        if (this.attributeEditor != null) {
            this.attributeEditor.removePropertyChangeListener(this.eventHandler);
        }
        this.attributeEditor = newValue;
        if (this.attributeEditor != null) {
            this.attributeEditor.addPropertyChangeListener(this.eventHandler);
        }
    }

    public AttributeEditor<T> getAttributeEditor() {
        return this.attributeEditor;
    }

    public AttributeKey<T> getAttributeKey() {
        return this.attributeKey;
    }

    public void setAttributeKey(AttributeKey<T> newValue) {
        this.attributeKey = newValue;
    }

    protected void updateActiveView() {
        DrawingView newValue = this.view != null ? this.view : (this.drawingEditor != null && this.drawingEditor.getActiveView() != null ? this.drawingEditor.getActiveView() : null);
        DrawingView oldValue = this.activeView;
        if (this.activeView != null) {
            this.activeView.removePropertyChangeListener(this.eventHandler);
            this.activeView.removeFigureSelectionListener(this.eventHandler);
            if (this.figuresOfInterest != null) {
                for (Figure f : this.figuresOfInterest) {
                    f.removeFigureListener(this.eventHandler);
                }
            }
        }
        this.activeView = newValue;
        if (this.activeView != null) {
            this.activeView.addPropertyChangeListener(this.eventHandler);
            this.activeView.addFigureSelectionListener(this.eventHandler);
            this.figuresOfInterest = this.getEditedFigures();
            for (Figure f : this.figuresOfInterest) {
                f.addFigureListener(this.eventHandler);
            }
        }
        this.attributeRestoreData = null;
        this.updateAttributeEditor();
    }

    protected abstract Set<Figure> getEditedFigures();

    protected void updateAttributeEditor() {
        if (this.updateDepth++ == 0) {
            Set<Figure> figures = this.getEditedFigures();
            if (this.activeView == null || figures.isEmpty()) {
                this.attributeEditor.getComponent().setEnabled(false);
            } else {
                this.attributeEditor.getComponent().setEnabled(true);
                T value = this.attributeKey.get(figures.iterator().next());
                boolean isMultiple = false;
                for (Figure f : figures) {
                    T v = this.attributeKey.get(f);
                    if ((v != null && value != null || v == value) && (v == null || value == null || v.equals(value))) continue;
                    isMultiple = true;
                    break;
                }
                this.attributeEditor.setAttributeValue(value);
                this.attributeEditor.setMultipleValues(isMultiple);
            }
        }
        --this.updateDepth;
    }

    protected void updateFigures() {
        if (this.updateDepth++ == 0) {
            Set<Figure> figures = this.getEditedFigures();
            if (this.activeView != null && !figures.isEmpty()) {
                T value = this.attributeEditor.getAttributeValue();
                if (this.attributeRestoreData == null) {
                    this.attributeRestoreData = new LinkedList();
                    for (Figure f : figures) {
                        this.attributeRestoreData.add(f.getAttributesRestoreData());
                    }
                }
                for (Figure f : figures) {
                    f.willChange();
                    this.attributeKey.basicSet(f, value);
                    for (Map.Entry<AttributeKey, Object> entry : this.defaultAttributes.entrySet()) {
                        entry.getKey().basicSet(f, entry.getValue());
                    }
                    f.changed();
                }
                if (this.drawingEditor != null && this.isUpdateDrawingEditorDefaults) {
                    this.drawingEditor.setDefaultAttribute(this.attributeKey, value);
                }
                this.getActiveView().getDrawing().fireUndoableEditHappened(new UndoableAttributeEdit<T>(new HashSet<Figure>(figures), this.attributeKey, value, this.attributeRestoreData));
                if (!this.attributeEditor.getValueIsAdjusting()) {
                    this.attributeRestoreData = null;
                }
            }
        }
        --this.updateDepth;
    }

    private static class UndoableAttributeEdit<T>
    extends AbstractUndoableEdit {
        private Set<Figure> editedFigures;
        private AttributeKey<T> attributeKey;
        private T editRedoValue;
        protected LinkedList<Object> editUndoData;

        public UndoableAttributeEdit(Set<Figure> editedFigures, AttributeKey<T> attributeKey, T editRedoValue, LinkedList<Object> editUndoData) {
            this.editedFigures = editedFigures;
            this.attributeKey = attributeKey;
            this.editRedoValue = editRedoValue;
            this.editUndoData = editUndoData;
        }

        @Override
        public String getPresentationName() {
            return this.attributeKey.toString();
        }

        @Override
        public void undo() throws CannotRedoException {
            super.undo();
            Iterator di = this.editUndoData.iterator();
            for (Figure f : this.editedFigures) {
                f.willChange();
                f.restoreAttributesTo(di.next());
                f.changed();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            for (Figure f : this.editedFigures) {
                this.attributeKey.set(f, this.editRedoValue);
            }
        }

        @Override
        public boolean replaceEdit(UndoableEdit anEdit) {
            if (anEdit instanceof UndoableAttributeEdit) {
                return ((UndoableAttributeEdit)anEdit).editUndoData == this.editUndoData;
            }
            return false;
        }
    }

    protected class EventHandler
    extends FigureAdapter
    implements FigureSelectionListener,
    PropertyChangeListener {
        protected EventHandler() {
        }

        @Override
        public void selectionChanged(FigureSelectionEvent evt) {
            AbstractAttributeEditorHandler.this.attributeRestoreData = null;
            if (AbstractAttributeEditorHandler.this.figuresOfInterest != null) {
                for (Figure f : AbstractAttributeEditorHandler.this.figuresOfInterest) {
                    f.removeFigureListener(this);
                }
            }
            AbstractAttributeEditorHandler.this.figuresOfInterest = AbstractAttributeEditorHandler.this.getEditedFigures();
            for (Figure f : AbstractAttributeEditorHandler.this.figuresOfInterest) {
                f.addFigureListener(this);
            }
            AbstractAttributeEditorHandler.this.updateAttributeEditor();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object src = evt.getSource();
            String name = evt.getPropertyName();
            if (src == AbstractAttributeEditorHandler.this.drawingEditor && name == "activeView") {
                AbstractAttributeEditorHandler.this.updateActiveView();
            } else if (src == AbstractAttributeEditorHandler.this.attributeEditor && name == "attributeValue") {
                AbstractAttributeEditorHandler.this.updateFigures();
            } else if (src == AbstractAttributeEditorHandler.this.activeView && name == "drawing") {
                AbstractAttributeEditorHandler.this.updateActiveView();
            } else if (AbstractAttributeEditorHandler.this.figuresOfInterest != null && AbstractAttributeEditorHandler.this.figuresOfInterest.contains(src)) {
                AbstractAttributeEditorHandler.this.updateFigures();
            }
        }

        @Override
        public void attributeChanged(FigureEvent e) {
            if (e.getAttribute() == AbstractAttributeEditorHandler.this.attributeKey) {
                AbstractAttributeEditorHandler.this.updateAttributeEditor();
            }
        }
    }
}

