/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;

public abstract class AbstractDrawingEditorAction
extends AbstractAction {
    protected DrawingEditor editor;
    private PropertyChangeListener propertyChangeHandler = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                AbstractDrawingEditorAction.this.updateEnabledState();
            } else if (evt.getPropertyName().equals("activeView")) {
                AbstractDrawingEditorAction.this.updateViewState();
            }
        }
    };

    public AbstractDrawingEditorAction(DrawingEditor editor) {
        this.editor = editor;
        if (editor != null) {
            editor.addPropertyChangeListener(this.propertyChangeHandler);
            this.updateEnabledState();
        }
    }

    public void setEditor(DrawingEditor newValue) {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.propertyChangeHandler);
        }
        this.editor = newValue;
        if (this.editor != null) {
            this.editor.addPropertyChangeListener(this.propertyChangeHandler);
            this.updateEnabledState();
        }
    }

    protected void updateEnabledState() {
        this.setEnabled(this.editor != null && this.editor.isEnabled());
    }

    protected void updateViewState() {
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    protected DrawingView getView() {
        return this.editor.getActiveView();
    }

    protected Drawing getDrawing() {
        return this.getView().getDrawing();
    }

    protected void fireUndoableEditHappened(UndoableEdit edit) {
        this.getDrawing().fireUndoableEditHappened(edit);
    }
}

