/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TransformEdit;

public class DragHandle
extends AbstractHandle {
    private Point2D.Double oldPoint;

    public DragHandle(Figure owner) {
        super(owner);
    }

    @Override
    public void draw(Graphics2D g) {
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        this.oldPoint = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(anchor));
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        Figure f = this.getOwner();
        Point2D.Double newPoint = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(lead));
        AffineTransform tx = new AffineTransform();
        tx.translate(newPoint.x - this.oldPoint.x, newPoint.y - this.oldPoint.y);
        f.willChange();
        f.transform(tx);
        f.changed();
        this.oldPoint = newPoint;
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        AffineTransform tx = new AffineTransform();
        tx.translate(lead.x - anchor.x, lead.y - anchor.y);
        LinkedList<Figure> draggedFigures = new LinkedList<Figure>();
        draggedFigures.add(this.getOwner());
        Point2D.Double dropPoint = this.getView().viewToDrawing(lead);
        Figure dropTarget = this.getView().getDrawing().findFigureExcept(dropPoint, draggedFigures);
        if (dropTarget != null) {
            boolean snapBack = dropTarget.handleDrop(dropPoint, draggedFigures, this.getView());
            if (snapBack) {
                tx = new AffineTransform();
                tx.translate(anchor.x - lead.x, anchor.y - lead.y);
                for (Figure f : draggedFigures) {
                    f.willChange();
                    f.transform(tx);
                    f.changed();
                }
            } else {
                this.fireUndoableEditHappened(new TransformEdit(this.getOwner(), tx));
            }
        } else {
            this.fireUndoableEditHappened(new TransformEdit(this.getOwner(), tx));
        }
    }

    @Override
    public boolean contains(Point p) {
        return this.getOwner().contains(this.getView().viewToDrawing(p));
    }

    @Override
    protected Rectangle basicGetBounds() {
        return this.getView().drawingToView(this.getOwner().getDrawingArea());
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }
}

