/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.TableViewSpanSelectionModel;
import java.util.List;
import java.util.TreeSet;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TablePosition;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.GridChange;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;

public class RectangleSelection
extends Rectangle {
    private final GridViewSkin skin;
    private final TableViewSpanSelectionModel sm;
    private final SelectionRange selectionRange;
    private final InvalidationListener layoutListener = observable -> this.updateRectangle();

    public RectangleSelection(final GridViewSkin skin, TableViewSpanSelectionModel sm) {
        this.skin = skin;
        this.sm = sm;
        this.getStyleClass().add((Object)"selection-rectangle");
        this.setMouseTransparent(true);
        this.selectionRange = new SelectionRange();
        skin.getVBar().valueProperty().addListener(this.layoutListener);
        skin.getVBar().addEventFilter(MouseEvent.MOUSE_DRAGGED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                skin.getVBar().valueProperty().removeListener(RectangleSelection.this.layoutListener);
                RectangleSelection.this.setVisible(false);
                skin.getVBar().addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        skin.getVBar().removeEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)this);
                        skin.getVBar().valueProperty().addListener(RectangleSelection.this.layoutListener);
                        RectangleSelection.this.updateRectangle();
                    }
                });
            }
        });
        skin.getHBar().valueProperty().addListener(this.layoutListener);
        sm.getSelectedCells().addListener(observable -> {
            skin.getHorizontalHeader().clearSelectedColumns();
            skin.verticalHeader.clearSelectedRows();
            this.selectionRange.fill((List<TablePosition>)sm.getSelectedCells());
            this.updateRectangle();
        });
    }

    public final void updateRectangle() {
        if (this.sm.getSelectedCells().isEmpty() || this.skin.getSelectedRows().isEmpty() || this.skin.getSelectedColumns().isEmpty() || this.selectionRange.range == null) {
            this.setVisible(false);
            return;
        }
        GridRow topRowCell = this.skin.getFlow().getTopRow();
        if (topRowCell == null) {
            return;
        }
        int topRow = topRowCell.getIndex();
        IndexedCell bottomRowCell = (IndexedCell)this.skin.getFlow().getCells().get(this.skin.getFlow().getCells().size() - 1);
        if (bottomRowCell == null) {
            return;
        }
        int bottomRow = bottomRowCell.getIndex();
        int minRow = this.selectionRange.range.getTop();
        if (minRow > bottomRow) {
            this.setVisible(false);
            return;
        }
        minRow = Math.max(minRow, topRow);
        int maxRow = this.selectionRange.range.getBottom();
        if (maxRow < topRow) {
            this.setVisible(false);
            return;
        }
        maxRow = Math.min(maxRow, bottomRow);
        int minColumn = this.selectionRange.range.getLeft();
        int maxColumn = this.selectionRange.range.getRight();
        GridRow gridMinRow = this.skin.getRowIndexed(minRow);
        if (gridMinRow == null) {
            this.setVisible(false);
            return;
        }
        Grid grid = this.skin.spreadsheetView.getGrid();
        if (maxRow >= grid.getRowCount() || maxColumn >= grid.getColumnCount()) {
            this.setVisible(false);
            return;
        }
        SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)grid.getRows().get(maxRow)).get(maxColumn);
        this.handleHorizontalPositioning(minColumn, maxColumn, cell.getColumnSpan());
        if (this.getX() + this.getWidth() < 0.0) {
            this.setVisible(false);
            return;
        }
        GridRow gridMaxRow = this.skin.getRowIndexed(maxRow);
        if (gridMaxRow == null) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        this.handleVerticalPositioning(minRow, maxRow, gridMinRow, gridMaxRow, cell.getRowSpan());
    }

    private void handleVerticalPositioning(int minRow, int maxRow, GridRow gridMinRow, GridRow gridMaxRow, int rowSpan) {
        double height = 0.0;
        for (int i = maxRow; i <= maxRow; ++i) {
            height += this.skin.getRowHeight(i);
        }
        if (!this.skin.getCurrentlyFixedRow().contains((Object)minRow)) {
            this.yProperty().unbind();
            if (gridMinRow.getLayoutY() < this.skin.getFixedRowHeight()) {
                this.setY(this.skin.getFixedRowHeight());
            } else {
                this.yProperty().bind((ObservableValue)gridMinRow.layoutYProperty());
            }
        } else {
            this.yProperty().bind((ObservableValue)gridMinRow.layoutYProperty().add((ObservableNumberValue)gridMinRow.verticalShift));
        }
        this.heightProperty().bind((ObservableValue)gridMaxRow.layoutYProperty().add((ObservableNumberValue)gridMaxRow.verticalShift).subtract((ObservableNumberValue)this.yProperty()).add(height));
    }

    private void handleHorizontalPositioning(int minColumn, int maxColumn, int columnSpan) {
        double x = 0.0;
        ObservableList<SpreadsheetColumn> columns = this.skin.spreadsheetView.getColumns();
        if (columns.size() <= minColumn || columns.size() <= maxColumn) {
            return;
        }
        for (int i = 0; i < minColumn; ++i) {
            x += this.snapSize(((SpreadsheetColumn)columns.get(i)).getWidth());
        }
        x -= this.skin.getHBar().getValue();
        double width = 0.0;
        for (int i = minColumn; i <= maxColumn; ++i) {
            width += this.snapSize(((SpreadsheetColumn)columns.get(i)).getWidth());
        }
        if (!this.skin.spreadsheetView.getFixedColumns().contains(columns.get(minColumn))) {
            if (x < this.skin.fixedColumnWidth) {
                width -= this.skin.fixedColumnWidth - x;
                x = this.skin.fixedColumnWidth;
            }
        } else if (x + width < this.skin.fixedColumnWidth) {
            x = 0.0;
            width = 0.0;
            for (SpreadsheetColumn column : this.skin.spreadsheetView.getFixedColumns()) {
                int indexColumn = columns.indexOf(column);
                if (indexColumn < minColumn && indexColumn != minColumn) {
                    x += this.snapSize(column.getWidth());
                }
                if (indexColumn < minColumn || indexColumn > maxColumn) continue;
                width += this.snapSize(column.getWidth());
            }
        } else if (x < this.skin.fixedColumnWidth) {
            double tempX = 0.0;
            for (SpreadsheetColumn column : this.skin.spreadsheetView.getFixedColumns()) {
                int indexColumn = columns.indexOf(column);
                if (indexColumn >= minColumn || indexColumn == minColumn) continue;
                tempX += this.snapSize(column.getWidth());
            }
            width -= tempX - x;
            x = tempX;
        }
        this.setX(x);
        this.setWidth(width);
    }

    private double snapSize(double value) {
        return Math.ceil(value);
    }

    public static class GridRange {
        private final int top;
        private final int bottom;
        private final int left;
        private final int right;

        public GridRange(int top, int bottom, int left, int right) {
            this.top = top;
            this.bottom = bottom;
            this.left = left;
            this.right = right;
        }

        public int getTop() {
            return this.top;
        }

        public int getBottom() {
            return this.bottom;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }
    }

    public static class SelectionRange {
        private final TreeSet<Long> set = new TreeSet();
        private GridRange range;

        public void fill(List<TablePosition> list) {
            this.set.clear();
            for (TablePosition pos : list) {
                this.set.add(this.key(pos.getRow(), pos.getColumn()));
            }
            this.computeRange();
        }

        public void fillGridRange(List<GridChange> list) {
            this.set.clear();
            for (GridChange pos : list) {
                this.set.add(this.key(pos.getRow(), pos.getColumn()));
            }
            this.computeRange();
        }

        public GridRange getRange() {
            return this.range;
        }

        private Long key(int row, int column) {
            return (long)row << 32 | (long)column;
        }

        private int getRow(Long l) {
            return (int)(l >> 32);
        }

        private int getColumn(Long l) {
            return (int)(l & 0xFFFFFFFFFFFFFFFFL);
        }

        private void computeRange() {
            this.range = null;
            while (!this.set.isEmpty()) {
                if (this.range != null) {
                    this.range = null;
                    return;
                }
                long first = this.set.first();
                this.set.remove(first);
                int row = this.getRow(first);
                int column = this.getColumn(first);
                while (this.set.contains(this.key(row, column + 1))) {
                    this.set.remove(this.key(row, ++column));
                }
                boolean flag = true;
                while (flag) {
                    int col;
                    ++row;
                    for (col = this.getColumn(first); col <= column; ++col) {
                        if (this.set.contains(this.key(row, col))) continue;
                        flag = false;
                        break;
                    }
                    if (flag) {
                        for (col = this.getColumn(first); col <= column; ++col) {
                            this.set.remove(this.key(row, col));
                        }
                        continue;
                    }
                    --row;
                }
                this.range = new GridRange(this.getRow(first), row, this.getColumn(first), column);
            }
        }
    }
}

