/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.util.i18n;

import java.io.BufferedWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import jlibs.core.annotation.processing.AnnotationError;
import jlibs.core.annotation.processing.Environment;
import jlibs.core.annotation.processing.Printer;
import jlibs.core.lang.StringUtil;
import jlibs.core.lang.model.ModelUtil;
import jlibs.core.util.i18n.Message;
import jlibs.core.util.i18n.PropertiesUtil;
import jlibs.core.util.i18n.ResourceBundle;

class Interfaces {
    private List<String> interfaces = new ArrayList<String>();
    private Printer printer;
    private Map<String, ExecutableElement> entries;
    private Map<Element, Map<String, ExecutableElement>> classes = new HashMap<Element, Map<String, ExecutableElement>>();

    Interfaces(Map entries) {
        this.entries = entries;
    }

    public void add(TypeElement clazz) throws IOException {
        if (this.printer == null) {
            this.printer = Printer.get(clazz, ResourceBundle.class, "${package}._Bundle");
        }
        this.interfaces.add(clazz.getSimpleName().toString());
        while (clazz != null && !clazz.getQualifiedName().contentEquals(Object.class.getName())) {
            for (ExecutableElement method : ElementFilter.methodsIn(clazz.getEnclosedElements())) {
                this.add(method);
            }
            clazz = ModelUtil.getSuper(clazz);
        }
    }

    private void add(ExecutableElement method) {
        AnnotationMirror mirror = ModelUtil.getAnnotationMirror(method, Message.class);
        if (mirror == null) {
            throw new AnnotationError(method, Message.class.getName() + " annotation is missing on this method");
        }
        if (!String.class.getName().equals(ModelUtil.toString(method.getReturnType(), true))) {
            throw new AnnotationError(method, "method annotated with " + Message.class.getName() + " must return java.lang.String");
        }
        String signature = ModelUtil.signature(method, false);
        for (ExecutableElement m : this.entries.values()) {
            if (!signature.equals(ModelUtil.signature(m, false))) continue;
            throw new AnnotationError(method, "clashes with similar method in " + m.getEnclosingElement() + " interface");
        }
        AnnotationMirror messageMirror = ModelUtil.getAnnotationMirror(method, Message.class);
        String key = (String)ModelUtil.getAnnotationValue((Element)method, messageMirror, "key");
        if (StringUtil.isEmpty(key)) {
            key = method.getSimpleName().toString();
        }
        ExecutableElement clash = this.entries.put(key, method);
        Element interfase = method.getEnclosingElement();
        if (clash != null) {
            throw new AnnotationError(method, "key '" + key + "' is already used by \"" + ModelUtil.signature(clash, false) + "\" in " + clash.getEnclosingElement() + " interface");
        }
        Map<String, ExecutableElement> methods = this.classes.get(interfase);
        if (methods == null) {
            methods = new HashMap<String, ExecutableElement>();
            this.classes.put(interfase, methods);
        }
        methods.put(key, method);
    }

    public void generateClass(String basename) throws IOException {
        this.printer.printPackage();
        this.printer.println("import java.util.ResourceBundle;");
        this.printer.println("import java.text.MessageFormat;");
        this.printer.emptyLine(true);
        this.printer.printClassDoc();
        this.printer.println("@SuppressWarnings(\"unchecked\")");
        this.printer.println("public class " + this.printer.generatedClazz + " implements " + StringUtil.join(this.interfaces.iterator(), ", ") + "{");
        ++this.printer.indent;
        this.printer.println("public static final " + this.printer.generatedClazz + " INSTANCE = new " + this.printer.generatedClazz + "();");
        this.printer.emptyLine(true);
        this.printer.println("private final ResourceBundle BUNDLE = ResourceBundle.getBundle(\"" + this.printer.generatedPakage.replace('.', '/') + "/" + basename + "\");");
        this.printer.emptyLine(true);
        for (Map.Entry<Element, Map<String, ExecutableElement>> methods : this.classes.entrySet()) {
            this.printer.emptyLine(true);
            this.printer.println("/*-------------------------------------------------[ " + methods.getKey().getSimpleName() + " ]---------------------------------------------------*/");
            this.printer.emptyLine(true);
            for (Map.Entry<String, ExecutableElement> entry : methods.getValue().entrySet()) {
                String key = entry.getKey();
                ExecutableElement method = entry.getValue();
                this.printer.println("@Override");
                this.printer.print("public String " + method.getSimpleName() + "(");
                int i = 0;
                StringBuilder params = new StringBuilder();
                for (VariableElement variableElement : method.getParameters()) {
                    String paramName = variableElement.getSimpleName().toString();
                    params.append(", ");
                    if (i > 0) {
                        this.printer.print(", ");
                    }
                    params.append(paramName);
                    this.printer.print(ModelUtil.toString(variableElement.asType(), false) + " " + paramName);
                    ++i;
                }
                if (params.length() == 0) {
                    params.append(", new Object[0]");
                }
                this.printer.println("){");
                ++this.printer.indent;
                this.printer.println("return MessageFormat.format(BUNDLE.getString(\"" + key + "\")" + params + ");");
                --this.printer.indent;
                this.printer.println("}");
            }
        }
        --this.printer.indent;
        this.printer.println("}");
        this.close();
    }

    public void generateProperties(BufferedWriter props) throws IOException {
        Elements elemUtil = Environment.get().getElementUtils();
        for (Map.Entry<Element, Map<String, ExecutableElement>> methods : this.classes.entrySet()) {
            PropertiesUtil.writeComments(props, "-------------------------------------------------[ " + methods.getKey().getSimpleName() + " ]---------------------------------------------------");
            props.newLine();
            for (Map.Entry<String, ExecutableElement> entry : methods.getValue().entrySet()) {
                int argCount;
                String key = entry.getKey();
                ExecutableElement method = entry.getValue();
                String doc = elemUtil.getDocComment(method);
                String methodDoc = ModelUtil.getMethodDoc(doc);
                if (!StringUtil.isEmpty(methodDoc)) {
                    PropertiesUtil.writeComments(props, " " + methodDoc);
                }
                int i = 0;
                Map<String, String> paramDocs = ModelUtil.getMethodParamDocs(doc);
                for (VariableElement variableElement : method.getParameters()) {
                    String paramName = variableElement.getSimpleName().toString();
                    String paramDoc = paramDocs.get(paramName);
                    if (StringUtil.isEmpty(paramDoc)) {
                        PropertiesUtil.writeComments(props, " {" + i + "} " + paramName);
                    } else {
                        PropertiesUtil.writeComments(props, " {" + i + "} " + paramName + " ==> " + paramDoc);
                    }
                    ++i;
                }
                AnnotationMirror messageMirror = ModelUtil.getAnnotationMirror(method, Message.class);
                String string = (String)ModelUtil.getAnnotationValue((Element)method, messageMirror, "value");
                try {
                    new MessageFormat(string);
                }
                catch (IllegalArgumentException ex) {
                    throw new AnnotationError((Element)method, messageMirror, ModelUtil.getRawAnnotationValue(method, messageMirror, "value"), "Invalid Message Format: " + ex.getMessage());
                }
                NavigableSet<Integer> args = PropertiesUtil.findArgs(string);
                int n = argCount = args.size() == 0 ? 0 : (Integer)args.last() + 1;
                if (argCount != method.getParameters().size()) {
                    throw new AnnotationError(method, "no of args in message format doesn't match with the number of parameters this method accepts");
                }
                for (i = 0; i < argCount; ++i) {
                    if (args.remove(i)) continue;
                    throw new AnnotationError((Element)method, messageMirror, "{" + i + "} is missing in message");
                }
                PropertiesUtil.writeProperty(props, key, string);
                props.newLine();
            }
        }
    }

    public void close() throws IOException {
        if (this.printer != null) {
            this.printer.close();
            this.printer = null;
        }
    }
}

