/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

interface QuickDrawComposite
extends Composite {
    public static final QuickDrawComposite NotSrcXor = new NotSrcXor();
    public static final QuickDrawComposite AddMax = new AddMax();
    public static final QuickDrawComposite AddMin = new AddMin();

    public static class AddMin
    implements QuickDrawComposite {
        @Override
        public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
            if (!colorModel.getColorSpace().isCS_sRGB() || !colorModel2.getColorSpace().isCS_sRGB()) {
                throw new IllegalArgumentException("Only sRGB supported");
            }
            return new CompositeContext(){

                @Override
                public void dispose() {
                }

                @Override
                public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
                    int n = Math.min(raster.getWidth(), raster2.getWidth());
                    int[] nArray = null;
                    int[] nArray2 = null;
                    int[] nArray3 = new int[n - raster.getMinX()];
                    for (int i = raster.getMinY(); i < raster.getHeight(); ++i) {
                        nArray = (int[])raster.getDataElements(raster.getMinX(), i, n, 1, nArray);
                        nArray2 = (int[])raster2.getDataElements(raster.getMinX(), i, n, 1, nArray2);
                        for (int j = raster.getMinX(); j < n; ++j) {
                            int n2 = nArray[j] >>> 24 & 0xFF;
                            int n3 = n2 * (nArray[j] >> 16 & 0xFF) / 255;
                            int n4 = n2 * (nArray[j] >> 8 & 0xFF) / 255;
                            int n5 = n2 * (nArray[j] & 0xFF) / 255;
                            int n6 = nArray2[j] >>> 24 & 0xFF;
                            int n7 = n6 * (nArray2[j] >> 16 & 0xFF) / 255;
                            int n8 = n6 * (nArray2[j] >> 8 & 0xFF) / 255;
                            int n9 = n6 * (nArray2[j] & 0xFF) / 255;
                            nArray3[j] = Math.min(n2, n6) << 24 | Math.min(n3, n7) << 16 | Math.min(n4, n8) << 8 | Math.min(n5, n9);
                        }
                        writableRaster.setDataElements(raster.getMinX(), i, n, 1, nArray3);
                    }
                }
            };
        }
    }

    public static class AddMax
    implements QuickDrawComposite {
        @Override
        public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
            if (!colorModel.getColorSpace().isCS_sRGB() || !colorModel2.getColorSpace().isCS_sRGB()) {
                throw new IllegalArgumentException("Only sRGB supported");
            }
            return new CompositeContext(){

                @Override
                public void dispose() {
                }

                @Override
                public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
                    int n = Math.min(raster.getWidth(), raster2.getWidth());
                    int[] nArray = null;
                    int[] nArray2 = null;
                    int[] nArray3 = new int[n - raster.getMinX()];
                    for (int i = raster.getMinY(); i < raster.getHeight(); ++i) {
                        nArray = (int[])raster.getDataElements(raster.getMinX(), i, n, 1, nArray);
                        nArray2 = (int[])raster2.getDataElements(raster.getMinX(), i, n, 1, nArray2);
                        for (int j = raster.getMinX(); j < n; ++j) {
                            int n2 = nArray[j] >>> 24 & 0xFF;
                            int n3 = n2 * (nArray[j] >> 16 & 0xFF) / 255;
                            int n4 = n2 * (nArray[j] >> 8 & 0xFF) / 255;
                            int n5 = n2 * (nArray[j] & 0xFF) / 255;
                            int n6 = nArray2[j] >>> 24 & 0xFF;
                            int n7 = n6 * (nArray2[j] >> 16 & 0xFF) / 255;
                            int n8 = n6 * (nArray2[j] >> 8 & 0xFF) / 255;
                            int n9 = n6 * (nArray2[j] & 0xFF) / 255;
                            nArray3[j] = Math.max(n2, n6) << 24 | Math.max(n3, n7) << 16 | Math.max(n4, n8) << 8 | Math.max(n5, n9);
                        }
                        writableRaster.setDataElements(raster.getMinX(), i, n, 1, nArray3);
                    }
                }
            };
        }
    }

    public static class NotSrcXor
    implements QuickDrawComposite {
        @Override
        public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
            if (!colorModel.getColorSpace().isCS_sRGB() || !colorModel2.getColorSpace().isCS_sRGB()) {
                throw new IllegalArgumentException("Only sRGB supported");
            }
            return new CompositeContext(){

                @Override
                public void dispose() {
                }

                @Override
                public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
                    int n = Math.min(raster.getWidth(), raster2.getWidth());
                    int[] nArray = null;
                    int[] nArray2 = null;
                    int[] nArray3 = new int[n - raster.getMinX()];
                    for (int i = raster.getMinY(); i < raster.getHeight(); ++i) {
                        nArray = (int[])raster.getDataElements(raster.getMinX(), i, n, 1, nArray);
                        nArray2 = (int[])raster2.getDataElements(raster.getMinX(), i, n, 1, nArray2);
                        for (int j = raster.getMinX(); j < n; ++j) {
                            nArray3[j] = 0xFF000000 | (~nArray[j] ^ nArray2[j]) & 0xFFFFFF;
                        }
                        writableRaster.setDataElements(raster.getMinX(), i, n, 1, nArray3);
                    }
                }
            };
        }
    }
}

