/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.CertificateAmendment;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class PlatformHookUnixoid
implements PlatformHook {
    private String osDescription;
    private static final String[] NOT_INSTALLED = new String[]{"not installed", "no s'ha instal\u00b7lat", "\u5c1a\u672a\u5b89\u88dd", "nen\u00ed nainstalov\u00e1n", "ikke installeret", "nicht installiert", "ne estas instalita", "no est\u00e1 instalado", "ole asennettu", "pas install\u00e9", "non \u00e8 stato installato", "\u306f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", "\ud328\ud0a4\uc9c0\uac00 \uc124\uce58\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4", "ikke installert", "nie jest zainstalowany", "n\u00e3o est\u00e1 instalado", "\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d", "ni name\u0161\u010den", "nie je nain\u0161talovan\u00fd", "\u043d\u0438\u0458\u0435 \u0438\u043d\u0441\u0442\u0430\u043b\u0438\u0440\u0430\u043d", "inte installerat", "kurulu de\u011fil", "\u043d\u0435 \u0432\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e", "ch\u01b0a c\u00e0i \u0111\u1eb7t g\u00f3i", "\u672a\u5b89\u88c5\u8f6f\u4ef6\u5305", "\u5c1a\u672a\u5b89\u88dd"};

    @Override
    public void preStartupHook() {
        if ("org.GNOME.Accessibility.AtkWrapper".equals(System.getProperty("assistive_technologies"))) {
            System.clearProperty("assistive_technologies");
        }
    }

    @Override
    public void openUrl(String string) throws IOException {
        for (String string2 : Main.pref.getCollection("browser.unix", Arrays.asList("xdg-open", "#DESKTOP#", "$BROWSER", "gnome-open", "kfmclient openURL", "firefox"))) {
            try {
                if ("#DESKTOP#".equals(string2)) {
                    Desktop.getDesktop().browse(new URI(string));
                } else if (string2.startsWith("$")) {
                    string2 = System.getenv().get(string2.substring(1));
                    Runtime.getRuntime().exec(new String[]{string2, string});
                } else {
                    Runtime.getRuntime().exec(new String[]{string2, string});
                }
                return;
            }
            catch (IOException | URISyntaxException exception) {
                Main.warn(exception);
            }
        }
    }

    @Override
    public void initSystemShortcuts() {
        for (int i = 112; i <= 123; ++i) {
            Shortcut.registerSystemShortcut("screen:toogle" + i, I18n.tr("reserved", new Object[0]), i, 640).setAutomatic();
        }
        Shortcut.registerSystemShortcut("system:reset", I18n.tr("reserved", new Object[0]), 127, 640).setAutomatic();
        Shortcut.registerSystemShortcut("system:resetX", I18n.tr("reserved", new Object[0]), 8, 640).setAutomatic();
    }

    @Override
    public String getDefaultStyle() {
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    public static boolean isDebianOrUbuntu() {
        try {
            String string = Utils.execOutput(Arrays.asList("lsb_release", "-i", "-s"));
            return "Debian".equalsIgnoreCase(string) || "Ubuntu".equalsIgnoreCase(string) || "Mint".equalsIgnoreCase(string);
        }
        catch (IOException iOException) {
            Main.debug(iOException);
            return false;
        }
    }

    public static String getPackageDetails(String ... stringArray) {
        try {
            boolean bl = Paths.get("/usr/bin/dpkg-query", new String[0]).toFile().exists();
            boolean bl2 = Paths.get("/usr/bin/equery", new String[0]).toFile().exists();
            boolean bl3 = Paths.get("/bin/rpm", new String[0]).toFile().exists();
            if (bl || bl3 || bl2) {
                for (String string : stringArray) {
                    String[] stringArray2 = bl ? new String[]{"dpkg-query", "--show", "--showformat", "${Architecture}-${Version}", string} : (bl2 ? new String[]{"equery", "-q", "list", "-e", "--format=$fullversion", string} : new String[]{"rpm", "-q", "--qf", "%{arch}-%{version}", string});
                    String string2 = Utils.execOutput(Arrays.asList(stringArray2));
                    if (string2 == null) continue;
                    for (String string3 : NOT_INSTALLED) {
                        if (string2.contains(string3)) break;
                    }
                    return string + ':' + string2;
                }
            }
        }
        catch (IOException iOException) {
            Main.warn(iOException);
        }
        return null;
    }

    public String getJavaPackageDetails() {
        String string = System.getProperty("java.home");
        if (string.contains("java-8-openjdk") || string.contains("java-1.8.0-openjdk")) {
            return PlatformHookUnixoid.getPackageDetails("openjdk-8-jre", "java-1_8_0-openjdk", "java-1.8.0-openjdk");
        }
        if (string.contains("java-9-openjdk") || string.contains("java-1.9.0-openjdk")) {
            return PlatformHookUnixoid.getPackageDetails("openjdk-9-jre", "java-1_9_0-openjdk", "java-1.9.0-openjdk");
        }
        if (string.contains("icedtea")) {
            return PlatformHookUnixoid.getPackageDetails("icedtea-bin");
        }
        if (string.contains("oracle")) {
            return PlatformHookUnixoid.getPackageDetails("oracle-jdk-bin", "oracle-jre-bin");
        }
        return null;
    }

    public String getWebStartPackageDetails() {
        if (this.isOpenJDK()) {
            return PlatformHookUnixoid.getPackageDetails("icedtea-netx", "icedtea-web");
        }
        return null;
    }

    public String getAtkWrapperPackageDetails() {
        if (this.isOpenJDK() && PlatformHookUnixoid.isDebianOrUbuntu()) {
            return PlatformHookUnixoid.getPackageDetails("libatk-wrapper-java");
        }
        return null;
    }

    private String buildOSDescription() {
        String string = System.getProperty("os.name");
        if ("Linux".equalsIgnoreCase(string)) {
            try {
                String string2 = this.exec("lsb_release", "-ds");
                if (string2 != null && !string2.isEmpty()) {
                    string2 = string2.replaceAll("\"+", "");
                    if ((string2 = string2.replaceAll("NAME=", "")).startsWith("Linux ")) {
                        return string2;
                    }
                    if (!string2.isEmpty()) {
                        return "Linux " + string2;
                    }
                }
            }
            catch (IOException iOException) {
                Main.debug(iOException);
                for (LinuxReleaseInfo linuxReleaseInfo : new LinuxReleaseInfo[]{new LinuxReleaseInfo("/etc/lsb-release", "DISTRIB_DESCRIPTION", "DISTRIB_ID", "DISTRIB_RELEASE"), new LinuxReleaseInfo("/etc/os-release", "PRETTY_NAME", "NAME", "VERSION"), new LinuxReleaseInfo("/etc/arch-release"), new LinuxReleaseInfo("/etc/debian_version", "Debian GNU/Linux "), new LinuxReleaseInfo("/etc/fedora-release"), new LinuxReleaseInfo("/etc/gentoo-release"), new LinuxReleaseInfo("/etc/redhat-release"), new LinuxReleaseInfo("/etc/SuSE-release")}) {
                    String string3 = linuxReleaseInfo.extractDescription();
                    if (string3 == null || string3.isEmpty()) continue;
                    return "Linux " + string3;
                }
            }
        }
        return string;
    }

    @Override
    public String getOSDescription() {
        if (this.osDescription == null) {
            this.osDescription = this.buildOSDescription();
        }
        return this.osDescription;
    }

    private static File getDotDirectory() {
        String string = "." + Main.pref.getJOSMDirectoryBaseName().toLowerCase(Locale.ENGLISH);
        return new File(System.getProperty("user.home"), string);
    }

    private static boolean useDotDirectory() {
        return PlatformHookUnixoid.getDotDirectory().exists();
    }

    @Override
    public File getDefaultCacheDirectory() {
        if (PlatformHookUnixoid.useDotDirectory()) {
            return new File(PlatformHookUnixoid.getDotDirectory(), "cache");
        }
        String string = System.getenv("XDG_CACHE_HOME");
        if (string != null && !string.isEmpty()) {
            return new File(string, Main.pref.getJOSMDirectoryBaseName());
        }
        return new File(System.getProperty("user.home") + File.separator + ".cache" + File.separator + Main.pref.getJOSMDirectoryBaseName());
    }

    @Override
    public File getDefaultPrefDirectory() {
        if (PlatformHookUnixoid.useDotDirectory()) {
            return PlatformHookUnixoid.getDotDirectory();
        }
        String string = System.getenv("XDG_CONFIG_HOME");
        if (string != null && !string.isEmpty()) {
            return new File(string, Main.pref.getJOSMDirectoryBaseName());
        }
        return new File(System.getProperty("user.home") + File.separator + ".config" + File.separator + Main.pref.getJOSMDirectoryBaseName());
    }

    @Override
    public File getDefaultUserDataDirectory() {
        if (PlatformHookUnixoid.useDotDirectory()) {
            return PlatformHookUnixoid.getDotDirectory();
        }
        String string = System.getenv("XDG_DATA_HOME");
        if (string != null && !string.isEmpty()) {
            return new File(string, Main.pref.getJOSMDirectoryBaseName());
        }
        return new File(System.getProperty("user.home") + File.separator + ".local" + File.separator + "share" + File.separator + Main.pref.getJOSMDirectoryBaseName());
    }

    @Override
    public List<File> getDefaultProj4NadshiftDirectories() {
        return Arrays.asList(new File("/usr/local/share/proj"), new File("/usr/share/proj"));
    }

    @Override
    public X509Certificate getX509Certificate(CertificateAmendment.CertAmend certAmend) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        File file = new File("/usr/share/ca-certificates/mozilla", certAmend.getFilename());
        if (file.exists()) {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
                return x509Certificate;
            }
        }
        return null;
    }

    private static class LinuxReleaseInfo {
        private final String path;
        private final String descriptionField;
        private final String idField;
        private final String releaseField;
        private final boolean plainText;
        private final String prefix;

        LinuxReleaseInfo(String string, String string2, String string3, String string4) {
            this(string, string2, string3, string4, false, null);
        }

        LinuxReleaseInfo(String string) {
            this(string, null, null, null, true, null);
        }

        LinuxReleaseInfo(String string, String string2) {
            this(string, null, null, null, true, string2);
        }

        private LinuxReleaseInfo(String string, String string2, String string3, String string4, boolean bl, String string5) {
            this.path = string;
            this.descriptionField = string2;
            this.idField = string3;
            this.releaseField = string4;
            this.plainText = bl;
            this.prefix = string5;
        }

        public String toString() {
            return "ReleaseInfo [path=" + this.path + ", descriptionField=" + this.descriptionField + ", idField=" + this.idField + ", releaseField=" + this.releaseField + ']';
        }

        public String extractDescription() {
            Path path;
            String string = null;
            if (this.path != null && (path = Paths.get(this.path, new String[0])).toFile().exists()) {
                try (BufferedReader bufferedReader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                    String string2;
                    String string3 = null;
                    String string4 = null;
                    while (string == null && (string2 = bufferedReader.readLine()) != null) {
                        if (string2.contains("=")) {
                            String[] stringArray = string2.split("=");
                            if (stringArray.length < 2) continue;
                            if (this.descriptionField != null && this.descriptionField.equalsIgnoreCase(stringArray[0])) {
                                string = Utils.strip(stringArray[1]);
                                continue;
                            }
                            if (this.idField != null && this.idField.equalsIgnoreCase(stringArray[0])) {
                                string3 = Utils.strip(stringArray[1]);
                                continue;
                            }
                            if (this.releaseField == null || !this.releaseField.equalsIgnoreCase(stringArray[0])) continue;
                            string4 = Utils.strip(stringArray[1]);
                            continue;
                        }
                        if (!this.plainText || string2.isEmpty()) continue;
                        string = Utils.strip(string2);
                    }
                    if (string == null && string3 != null && string4 != null) {
                        string = string3 + ' ' + string4;
                    }
                }
                catch (IOException iOException) {
                    Main.trace(iOException);
                }
            }
            if (string != null && !string.isEmpty() && this.prefix != null && !this.prefix.isEmpty()) {
                string = this.prefix + string;
            }
            if (string != null) {
                string = string.replaceAll("\"+", "");
            }
            return string;
        }
    }
}

