/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImagerySessionImporter
implements SessionLayerImporter {
    @Override
    public Layer load(Element element, SessionReader.ImportSupport importSupport, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        String string = element.getAttribute("version");
        if (!"0.1".equals(string)) {
            throw new IllegalDataException(I18n.tr("Version ''{0}'' of meta data for imagery layer is not supported. Expected: 0.1", string));
        }
        Map<String, String> map = ImagerySessionImporter.readProperties(element);
        ImageryInfo.ImageryPreferenceEntry imageryPreferenceEntry = Preferences.deserializeStruct(map, ImageryInfo.ImageryPreferenceEntry.class);
        ImageryInfo imageryInfo = new ImageryInfo(imageryPreferenceEntry);
        ImageryLayer imageryLayer = ImageryLayer.create(imageryInfo);
        if (imageryLayer instanceof AbstractTileSourceLayer) {
            AbstractTileSourceLayer abstractTileSourceLayer = (AbstractTileSourceLayer)imageryLayer;
            abstractTileSourceLayer.getDisplaySettings().loadFrom(map);
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !"offset".equals(node.getLocalName())) continue;
                Map<String, String> map2 = ImagerySessionImporter.readProperties((Element)node);
                OffsetBookmark offsetBookmark = OffsetBookmark.fromPropertiesMap(map2);
                abstractTileSourceLayer.getDisplaySettings().setOffsetBookmark(offsetBookmark);
                break;
            }
        }
        return imageryLayer;
    }

    private static Map<String, String> readProperties(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || node.getChildNodes().getLength() > 1) continue;
            Element element2 = (Element)node;
            hashMap.put(element2.getTagName(), element2.getTextContent());
        }
        return hashMap;
    }
}

