/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class Text
extends KeyedItem {
    private static int auto_increment_selected;
    public String locale_text;
    public String default_;
    public String originalValue;
    public String use_last_as_default = "false";
    public String auto_increment;
    public String length;
    public String alternative_autocomplete_keys;
    private JComponent value;

    @Override
    public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection, boolean bl) {
        Serializable serializable;
        KeyedItem.Usage usage = Text.determineTextUsage(collection, this.key);
        AutoCompletingTextField autoCompletingTextField = new AutoCompletingTextField();
        if (this.alternative_autocomplete_keys != null) {
            this.initAutoCompletionField(autoCompletingTextField, (this.key + ',' + this.alternative_autocomplete_keys).split(","));
        } else {
            this.initAutoCompletionField(autoCompletingTextField, this.key);
        }
        if (Main.pref.getBoolean("taggingpreset.display-keys-as-hint", true)) {
            autoCompletingTextField.setHint(this.key);
        }
        if (this.length != null && !this.length.isEmpty()) {
            autoCompletingTextField.setMaxChars(Integer.valueOf(this.length));
        }
        if (usage.unused()) {
            if (auto_increment_selected != 0 && this.auto_increment != null) {
                try {
                    autoCompletingTextField.setText(Integer.toString(Integer.parseInt((String)LAST_VALUES.get(this.key)) + auto_increment_selected));
                }
                catch (NumberFormatException numberFormatException) {
                    Main.trace(numberFormatException);
                }
            } else if (!usage.hadKeys() || PROP_FILL_DEFAULT.get().booleanValue() || "force".equals(this.use_last_as_default)) {
                if (!bl && !"false".equals(this.use_last_as_default) && LAST_VALUES.containsKey(this.key)) {
                    autoCompletingTextField.setText((String)LAST_VALUES.get(this.key));
                } else {
                    autoCompletingTextField.setText(this.default_);
                }
            } else {
                autoCompletingTextField.setText("");
            }
            this.value = autoCompletingTextField;
            this.originalValue = null;
        } else if (usage.hasUniqueValue()) {
            autoCompletingTextField.setText(usage.getFirst());
            this.value = autoCompletingTextField;
            this.originalValue = usage.getFirst();
        } else {
            serializable = new JosmComboBox<String>(usage.values.toArray(new String[usage.values.size()]));
            ((JComboBox)serializable).setEditable(true);
            ((JComboBox)serializable).setEditor(autoCompletingTextField);
            ((JComboBox)serializable).getEditor().setItem(DIFFERENT);
            this.value = serializable;
            this.originalValue = DIFFERENT;
        }
        if (this.locale_text == null) {
            this.locale_text = Text.getLocaleText(this.text, this.text_context, null);
        }
        if (this.auto_increment != null) {
            serializable = new ButtonGroup();
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.add((Component)this.value, GBC.std().fill(2));
            for (String string : this.auto_increment.split(",")) {
                JToggleButton jToggleButton = new JToggleButton(string);
                jToggleButton.setToolTipText(I18n.tr("Select auto-increment of {0} for this field", string));
                jToggleButton.setMargin(new Insets(0, 0, 0, 0));
                jToggleButton.setFocusable(false);
                Text.saveHorizontalSpace(jToggleButton);
                ((ButtonGroup)serializable).add(jToggleButton);
                try {
                    int n = NumberFormat.getIntegerInstance().parse(string.replace("+", "")).intValue();
                    if (auto_increment_selected == n) {
                        jToggleButton.setSelected(true);
                    }
                    jToggleButton.addActionListener(actionEvent -> {
                        auto_increment_selected = n;
                    });
                    jPanel2.add((Component)jToggleButton, GBC.std());
                }
                catch (ParseException parseException) {
                    Main.error("Cannot parse auto-increment value of '" + string + "' into an integer");
                }
            }
            JToggleButton jToggleButton = new JToggleButton("X");
            jToggleButton.setVisible(false);
            jToggleButton.setFocusable(false);
            ((ButtonGroup)serializable).add(jToggleButton);
            JButton jButton = new JButton("X");
            jButton.setToolTipText(I18n.tr("Cancel auto-increment for this field", new Object[0]));
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setFocusable(false);
            jButton.addActionListener(actionEvent -> {
                auto_increment_selected = 0;
                jToggleButton.setSelected(true);
            });
            Text.saveHorizontalSpace(jButton);
            jPanel2.add((Component)jButton, GBC.eol());
            this.value = jPanel2;
        }
        serializable = new JLabel(this.locale_text + ':');
        ((JComponent)serializable).setToolTipText(this.getKeyTooltipText());
        ((JLabel)serializable).setLabelFor(this.value);
        jPanel.add((Component)serializable, GBC.std().insets(0, 0, 10, 0));
        jPanel.add((Component)this.value, GBC.eol().fill(2));
        this.value.setToolTipText(this.getKeyTooltipText());
        return true;
    }

    private static void saveHorizontalSpace(AbstractButton abstractButton) {
        Insets insets = abstractButton.getBorder().getBorderInsets(abstractButton);
        if (insets != null && insets.left + insets.right > insets.top + insets.bottom) {
            int n = Math.min(insets.top, insets.bottom);
            abstractButton.setBorder(BorderFactory.createEmptyBorder(insets.top, n, insets.bottom, n));
        }
    }

    private static String getValue(Component component) {
        if (component instanceof JosmComboBox) {
            return ((JosmComboBox)component).getEditor().getItem().toString();
        }
        if (component instanceof JosmTextField) {
            return ((JosmTextField)component).getText();
        }
        if (component instanceof JPanel) {
            return Text.getValue(((JPanel)component).getComponent(0));
        }
        return null;
    }

    @Override
    public void addCommands(List<Tag> list) {
        String string = Text.getValue(this.value);
        if (string == null) {
            Main.error("No 'last value' support for component " + this.value);
            return;
        }
        string = Tag.removeWhiteSpaces(string);
        if (!"false".equals(this.use_last_as_default) || this.auto_increment != null) {
            LAST_VALUES.put(this.key, string);
        }
        if (string.equals(this.originalValue) || this.originalValue == null && string.isEmpty()) {
            return;
        }
        list.add(new Tag(this.key, string));
        AutoCompletionManager.rememberUserInput(this.key, string, true);
    }

    @Override
    public KeyedItem.MatchType getDefaultMatch() {
        return KeyedItem.MatchType.NONE;
    }

    @Override
    public Collection<String> getValues() {
        if (this.default_ == null || this.default_.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.default_);
    }
}

