/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class TMSSettingsPanel
extends JPanel {
    private final JCheckBox autozoomActive = new JCheckBox();
    private final JCheckBox autoloadTiles = new JCheckBox();
    private final JSpinner minZoomLvl;
    private final JSpinner maxZoomLvl;
    private final JCheckBox addToSlippyMapChosser = new JCheckBox();
    private final JSpinner maxConcurrentDownloads;
    private final JSpinner maxDownloadsPerHost;

    public TMSSettingsPanel() {
        super(new GridBagLayout());
        this.minZoomLvl = new JSpinner(new SpinnerNumberModel(TMSLayer.PROP_MIN_ZOOM_LVL.get(), 2, 30, 1));
        this.maxZoomLvl = new JSpinner(new SpinnerNumberModel(TMSLayer.PROP_MAX_ZOOM_LVL.get(), 2, 30, 1));
        this.maxConcurrentDownloads = new JSpinner(new SpinnerNumberModel(TMSCachedTileLoader.THREAD_LIMIT.get(), 0, Integer.MAX_VALUE, 1));
        this.maxDownloadsPerHost = new JSpinner(new SpinnerNumberModel(TMSCachedTileLoader.HOST_LIMIT.get(), 0, Integer.MAX_VALUE, 1));
        this.add((Component)new JLabel(I18n.tr("Auto zoom by default: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.autozoomActive, GBC.eol().fill(2));
        this.add((Component)new JLabel(I18n.tr("Autoload tiles by default: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.autoloadTiles, GBC.eol().fill(2));
        this.add((Component)new JLabel(I18n.tr("Min. zoom level: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.minZoomLvl, GBC.eol());
        this.add((Component)new JLabel(I18n.tr("Max. zoom level: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.maxZoomLvl, GBC.eol());
        this.add((Component)new JLabel(I18n.tr("Add to slippymap chooser: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.addToSlippyMapChosser, GBC.eol().fill(2));
        this.add((Component)new JLabel(I18n.tr("Maximum concurrent downloads: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.maxConcurrentDownloads, GBC.eol());
        this.add((Component)new JLabel(I18n.tr("Maximum concurrent downloads per host: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.maxDownloadsPerHost, GBC.eol());
    }

    public void loadSettings() {
        this.autozoomActive.setSelected(TileSourceDisplaySettings.PROP_AUTO_ZOOM.get());
        this.autoloadTiles.setSelected(TileSourceDisplaySettings.PROP_AUTO_LOAD.get());
        this.addToSlippyMapChosser.setSelected(TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get());
        this.maxZoomLvl.setValue(TMSLayer.getMaxZoomLvl(null));
        this.minZoomLvl.setValue(TMSLayer.getMinZoomLvl(null));
        this.maxConcurrentDownloads.setValue(TMSCachedTileLoader.THREAD_LIMIT.get());
        this.maxDownloadsPerHost.setValue(TMSCachedTileLoader.HOST_LIMIT.get());
    }

    public boolean saveSettings() {
        boolean bl = false;
        if (!TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get().equals(this.addToSlippyMapChosser.isSelected())) {
            bl = true;
        }
        TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.put(this.addToSlippyMapChosser.isSelected());
        TileSourceDisplaySettings.PROP_AUTO_ZOOM.put(this.autozoomActive.isSelected());
        TileSourceDisplaySettings.PROP_AUTO_LOAD.put(this.autoloadTiles.isSelected());
        TMSLayer.setMaxZoomLvl((Integer)this.maxZoomLvl.getValue());
        TMSLayer.setMinZoomLvl((Integer)this.minZoomLvl.getValue());
        if (!TMSCachedTileLoader.THREAD_LIMIT.get().equals(this.maxConcurrentDownloads.getValue())) {
            TMSCachedTileLoader.THREAD_LIMIT.put((Integer)this.maxConcurrentDownloads.getValue());
            bl = true;
        }
        if (!TMSCachedTileLoader.HOST_LIMIT.get().equals(this.maxDownloadsPerHost.getValue())) {
            TMSCachedTileLoader.HOST_LIMIT.put((Integer)this.maxDownloadsPerHost.getValue());
            bl = true;
        }
        return bl;
    }
}

