/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.widgets.DateEditorWithSlider;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class DateFilterPanel
extends JPanel {
    private final DateEditorWithSlider dateFrom = new DateEditorWithSlider(I18n.tr("From", new Object[0]));
    private final DateEditorWithSlider dateTo = new DateEditorWithSlider(I18n.tr("To", new Object[0]));
    private final JCheckBox noTimestampCb = new JCheckBox(I18n.tr("No timestamp", new Object[0]));
    private final transient GpxLayer layer;
    private transient ActionListener filterAppliedListener;
    private final String prefDate0;
    private final String prefDateMin;
    private final String prefDateMax;
    private final Timer t = new Timer(200, actionEvent -> this.applyFilter());

    public DateFilterPanel(GpxLayer gpxLayer, String string, boolean bl) {
        super(new GridBagLayout());
        this.prefDate0 = string + ".showzerotimestamp";
        this.prefDateMin = string + ".mintime";
        this.prefDateMax = string + ".maxtime";
        this.layer = gpxLayer;
        Date[] dateArray = gpxLayer.data.getMinMaxTimeForAllTracks();
        Date date = dateArray.length == 0 ? Date.from(ZonedDateTime.of(2000, 1, 1, 0, 0, 0, 0, ZoneId.systemDefault()).toInstant()) : dateArray[0];
        Date date2 = dateArray.length == 0 ? new Date() : dateArray[1];
        this.dateFrom.setDate(date);
        this.dateTo.setDate(date2);
        this.dateFrom.setRange(date, date2);
        this.dateTo.setRange(date, date2);
        this.add((Component)this.noTimestampCb, GBC.std().grid(1, 1).insets(0, 0, 5, 0));
        this.add((Component)this.dateFrom, GBC.std().grid(2, 1).fill(2));
        this.add((Component)this.dateTo, GBC.eol().grid(3, 1).fill(2));
        this.setEnabled(bl);
        ChangeListener changeListener = changeEvent -> {
            if (this.isEnabled()) {
                this.applyFilterWithDelay();
            }
        };
        this.dateFrom.addDateListener(changeListener);
        this.dateTo.addDateListener(changeListener);
        this.noTimestampCb.addChangeListener(changeListener);
    }

    public void applyFilterWithDelay() {
        if (this.t.isRunning()) {
            this.t.restart();
        } else {
            this.t.start();
        }
    }

    public void applyFilter() {
        this.t.stop();
        this.filterTracksByDate();
        if (this.filterAppliedListener != null) {
            this.filterAppliedListener.actionPerformed(null);
        }
    }

    public void saveInPrefs() {
        Main.pref.putLong(this.prefDateMin, this.dateFrom.getDate().getTime());
        Main.pref.putLong(this.prefDateMax, this.dateTo.getDate().getTime());
        Main.pref.put(this.prefDate0, this.noTimestampCb.isSelected());
    }

    public void loadFromPrefs() {
        long l;
        long l2 = Main.pref.getLong(this.prefDateMin, 0L);
        if (l2 != 0L) {
            this.dateFrom.setDate(new Date(l2));
        }
        if ((l = Main.pref.getLong(this.prefDateMax, 0L)) != 0L) {
            this.dateTo.setDate(new Date(l));
        }
        this.noTimestampCb.setSelected(Main.pref.getBoolean(this.prefDate0, false));
    }

    public void setFilterAppliedListener(ActionListener actionListener) {
        this.filterAppliedListener = actionListener;
    }

    private void filterTracksByDate() {
        Date date = this.dateFrom.getDate();
        Date date2 = this.dateTo.getDate();
        this.layer.filterTracksByDate(date, date2, this.noTimestampCb.isSelected());
    }

    @Override
    public final void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (Component component : this.getComponents()) {
            component.setEnabled(bl);
        }
    }
}

