/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.text.ParseException;
import java.util.Objects;
import org.openstreetmap.josm.tools.I18n;

public final class Timezone {
    static final Timezone ZERO = new Timezone(0.0);
    private final double timezone;

    Timezone(double d) {
        this.timezone = d;
    }

    public double getHours() {
        return this.timezone;
    }

    String formatTimezone() {
        StringBuilder stringBuilder = new StringBuilder();
        double d = this.timezone;
        if (d < 0.0) {
            stringBuilder.append('-');
            d = -d;
        } else {
            stringBuilder.append('+');
        }
        stringBuilder.append((long)d).append(':');
        int n = (int)(d % 1.0 * 60.0);
        if (n < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    static Timezone parseTimezone(String string) throws ParseException {
        int n;
        int n2;
        if (string.isEmpty()) {
            return ZERO;
        }
        String string2 = I18n.tr("Error while parsing timezone.\nExpected format: {0}", "+H:MM");
        int n3 = 43;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n4 = 1;
        block12: for (n2 = 0; n2 < string.length(); ++n2) {
            n = string.charAt(n2);
            switch (n) {
                case 32: {
                    if (n4 == 2 && stringBuilder.length() == 0) continue block12;
                    throw new ParseException(string2, n2);
                }
                case 43: 
                case 45: {
                    if (n4 == 1) {
                        n3 = n;
                        n4 = 2;
                        continue block12;
                    }
                    throw new ParseException(string2, n2);
                }
                case 46: 
                case 58: {
                    if (n4 == 2) {
                        n4 = 3;
                        continue block12;
                    }
                    throw new ParseException(string2, n2);
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    switch (n4) {
                        case 1: 
                        case 2: {
                            n4 = 2;
                            stringBuilder.append((char)n);
                            continue block12;
                        }
                        case 3: {
                            stringBuilder2.append((char)n);
                            continue block12;
                        }
                    }
                    throw new ParseException(string2, n2);
                }
                default: {
                    throw new ParseException(string2, n2);
                }
            }
        }
        n2 = 0;
        n = 0;
        try {
            n2 = Integer.parseInt(stringBuilder.toString());
            if (stringBuilder2.length() > 0) {
                n = Integer.parseInt(stringBuilder2.toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw (ParseException)new ParseException(string2, 0).initCause(numberFormatException);
        }
        if (n2 > 12 || n > 59) {
            throw new ParseException(string2, 0);
        }
        return new Timezone(((double)n2 + (double)n / 60.0) * (double)(n3 == 45 ? -1 : 1));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Timezone)) {
            return false;
        }
        Timezone timezone = (Timezone)object;
        return Double.compare(timezone.timezone, this.timezone) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.timezone);
    }
}

