/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.File;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.CustomizeColor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerPositionStrategy;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.gpx.ChooseTrackVisibilityAction;
import org.openstreetmap.josm.gui.layer.gpx.ConvertToDataLayerAction;
import org.openstreetmap.josm.gui.layer.gpx.CustomizeDrawingAction;
import org.openstreetmap.josm.gui.layer.gpx.DownloadAlongTrackAction;
import org.openstreetmap.josm.gui.layer.gpx.DownloadWmsAlongTrackAction;
import org.openstreetmap.josm.gui.layer.gpx.GpxDrawHelper;
import org.openstreetmap.josm.gui.layer.gpx.ImportAudioAction;
import org.openstreetmap.josm.gui.layer.gpx.ImportImagesAction;
import org.openstreetmap.josm.gui.layer.gpx.MarkersFromNamedPointsAction;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.GpxImporter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.date.DateUtils;

public class GpxLayer
extends Layer {
    public GpxData data;
    private final boolean isLocalFile;
    public boolean[] trackVisibility = new boolean[0];
    private final GpxData.GpxDataChangeListener dataChangeListener = gpxDataChangeEvent -> this.invalidate();

    public GpxLayer(GpxData gpxData) {
        this(gpxData, null, false);
    }

    public GpxLayer(GpxData gpxData, String string) {
        this(gpxData, string, false);
    }

    public GpxLayer(GpxData gpxData, String string, boolean bl) {
        super(gpxData.getString("meta.name"));
        this.data = gpxData;
        this.data.addWeakChangeListener(this.dataChangeListener);
        this.trackVisibility = new boolean[this.data.getTracks().size()];
        Arrays.fill(this.trackVisibility, true);
        this.setName(string);
        this.isLocalFile = bl;
    }

    @Override
    protected ColorProperty getBaseColorProperty() {
        return GpxDrawHelper.DEFAULT_COLOR;
    }

    public static String getTimespanForTrack(GpxTrack gpxTrack) {
        Date[] dateArray = GpxData.getMinMaxTimeForTrack(gpxTrack);
        String string = "";
        if (dateArray != null) {
            DateFormat dateFormat;
            String string2;
            DateFormat dateFormat2 = DateUtils.getDateFormat(3);
            String string3 = dateFormat2.format(dateArray[0]);
            if (string3.equals(string2 = dateFormat2.format(dateArray[1]))) {
                dateFormat = DateUtils.getTimeFormat(3);
                string = string + string3 + ' ';
                string = string + dateFormat.format(dateArray[0]) + " - " + dateFormat.format(dateArray[1]);
            } else {
                dateFormat = DateUtils.getDateTimeFormat(3, 2);
                string = string + dateFormat.format(dateArray[0]) + " - " + dateFormat.format(dateArray[1]);
            }
            int n = (int)(dateArray[1].getTime() - dateArray[0].getTime()) / 1000;
            string = string + String.format(" (%d:%02d)", n / 3600, n % 3600 / 60);
        }
        return string;
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "gpx_small");
    }

    @Override
    public Object getInfoComponent() {
        StringBuilder stringBuilder = new StringBuilder(48).append("<html>");
        if (this.data.attr.containsKey("name")) {
            stringBuilder.append(I18n.tr("Name: {0}", this.data.get("meta.name"))).append("<br>");
        }
        if (this.data.attr.containsKey("desc")) {
            stringBuilder.append(I18n.tr("Description: {0}", this.data.get("meta.desc"))).append("<br>");
        }
        if (!this.data.getTracks().isEmpty()) {
            stringBuilder.append("<table><thead align='center'><tr><td colspan='5'>").append(I18n.trn("{0} track", "{0} tracks", this.data.tracks.size(), this.data.tracks.size())).append("</td></tr><tr align='center'><td>").append(I18n.tr("Name", new Object[0])).append("</td><td>").append(I18n.tr("Description", new Object[0])).append("</td><td>").append(I18n.tr("Timespan", new Object[0])).append("</td><td>").append(I18n.tr("Length", new Object[0])).append("</td><td>").append(I18n.tr("URL", new Object[0])).append("</td></tr></thead>");
            for (GpxTrack gpxTrack : this.data.getTracks()) {
                stringBuilder.append("<tr><td>");
                if (gpxTrack.getAttributes().containsKey("name")) {
                    stringBuilder.append(gpxTrack.get("name"));
                }
                stringBuilder.append("</td><td>");
                if (gpxTrack.getAttributes().containsKey("desc")) {
                    stringBuilder.append(' ').append(gpxTrack.get("desc"));
                }
                stringBuilder.append("</td><td>");
                stringBuilder.append(GpxLayer.getTimespanForTrack(gpxTrack));
                stringBuilder.append("</td><td>");
                stringBuilder.append(SystemOfMeasurement.getSystemOfMeasurement().getDistText(gpxTrack.length()));
                stringBuilder.append("</td><td>");
                if (gpxTrack.getAttributes().containsKey("url")) {
                    stringBuilder.append(gpxTrack.get("url"));
                }
                stringBuilder.append("</td></tr>");
            }
            stringBuilder.append("</table><br><br>");
        }
        stringBuilder.append(I18n.tr("Length: {0}", SystemOfMeasurement.getSystemOfMeasurement().getDistText(this.data.length()))).append("<br>").append(I18n.trn("{0} route, ", "{0} routes, ", this.data.getRoutes().size(), this.data.getRoutes().size())).append(I18n.trn("{0} waypoint", "{0} waypoints", this.data.getWaypoints().size(), this.data.getWaypoints().size())).append("<br></html>");
        JScrollPane jScrollPane = new JScrollPane(new HtmlPanel(stringBuilder.toString()));
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width + 20, 370));
        SwingUtilities.invokeLater(() -> jScrollPane.getVerticalScrollBar().setValue(0));
        return jScrollPane;
    }

    @Override
    public boolean isInfoResizable() {
        return true;
    }

    @Override
    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), LayerListDialog.getInstance().createMergeLayerAction(this), Layer.SeparatorLayerAction.INSTANCE, new Layer.LayerSaveAction(this), new Layer.LayerSaveAsAction(this), new CustomizeColor(this), new CustomizeDrawingAction(this), new ImportImagesAction(this), new ImportAudioAction(this), new MarkersFromNamedPointsAction(this), new ConvertToDataLayerAction.FromGpxLayer(this), new DownloadAlongTrackAction(this.data), new DownloadWmsAlongTrackAction(this.data), Layer.SeparatorLayerAction.INSTANCE, new ChooseTrackVisibilityAction(this), new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
    }

    public boolean isLocalFile() {
        return this.isLocalFile;
    }

    @Override
    public String getToolTipText() {
        StringBuilder stringBuilder = new StringBuilder(48).append("<html>");
        if (this.data.attr.containsKey("meta.name")) {
            stringBuilder.append(I18n.tr("Name: {0}", this.data.get("meta.name"))).append("<br>");
        }
        if (this.data.attr.containsKey("meta.desc")) {
            stringBuilder.append(I18n.tr("Description: {0}", this.data.get("meta.desc"))).append("<br>");
        }
        stringBuilder.append(I18n.trn("{0} track, ", "{0} tracks, ", this.data.getTracks().size(), this.data.getTracks().size())).append(I18n.trn("{0} route, ", "{0} routes, ", this.data.getRoutes().size(), this.data.getRoutes().size())).append(I18n.trn("{0} waypoint", "{0} waypoints", this.data.getWaypoints().size(), this.data.getWaypoints().size())).append("<br>").append(I18n.tr("Length: {0}", SystemOfMeasurement.getSystemOfMeasurement().getDistText(this.data.length()))).append("<br></html>");
        return stringBuilder.toString();
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof GpxLayer;
    }

    public void filterTracksByDate(Date date, Date date2, boolean bl) {
        int n = 0;
        long l = date.getTime();
        long l2 = date2.getTime();
        for (GpxTrack gpxTrack : this.data.getTracks()) {
            Date[] dateArray = GpxData.getMinMaxTimeForTrack(gpxTrack);
            if (dateArray == null) continue;
            long l3 = dateArray[1].getTime();
            this.trackVisibility[n] = l3 == 0L && bl || l <= l3 && l3 <= l2;
            ++n;
        }
        this.invalidate();
    }

    @Override
    public void mergeFrom(Layer layer) {
        if (!(layer instanceof GpxLayer)) {
            throw new IllegalArgumentException("not a GpxLayer: " + layer);
        }
        this.data.mergeFrom(((GpxLayer)layer).data);
        this.invalidate();
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        boundingXYVisitor.visit(this.data.recalculateBounds());
    }

    @Override
    public File getAssociatedFile() {
        return this.data.storageFile;
    }

    @Override
    public void setAssociatedFile(File file) {
        this.data.storageFile = file;
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
        if (projection2 == null) {
            return;
        }
        this.data.resetEastNorthCache();
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public boolean checkSaveConditions() {
        return this.data != null;
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save GPX file", new Object[0]), GpxImporter.getFileFilter());
    }

    @Override
    public LayerPositionStrategy getDefaultLayerPosition() {
        return LayerPositionStrategy.AFTER_LAST_DATA_LAYER;
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
    }

    @Override
    protected MapViewPaintable.LayerPainter createMapViewPainter(MapViewPaintable.MapViewEvent mapViewEvent) {
        return new GpxDrawHelper(this);
    }
}

