/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.draw;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.draw.MapPath2D;
import org.openstreetmap.josm.gui.draw.SymbolShape;

public class MapViewPath
extends MapPath2D {
    private final MapViewState state;

    public MapViewPath(MapView mapView) {
        this(mapView.getState());
    }

    public MapViewPath(MapViewState mapViewState) {
        this.state = mapViewState;
    }

    public MapViewState getMapViewState() {
        return this.state;
    }

    public MapViewPath moveTo(ILatLon iLatLon) {
        this.moveTo(iLatLon.getEastNorth(this.state.getProjecting()));
        return this;
    }

    public MapViewPath moveTo(EastNorth eastNorth) {
        this.moveTo(this.state.getPointFor(eastNorth));
        return this;
    }

    @Override
    public MapViewPath moveTo(MapViewState.MapViewPoint mapViewPoint) {
        super.moveTo(mapViewPoint);
        return this;
    }

    public MapViewPath lineTo(ILatLon iLatLon) {
        this.lineTo(iLatLon.getEastNorth(this.state.getProjecting()));
        return this;
    }

    public MapViewPath lineTo(EastNorth eastNorth) {
        this.lineTo(this.state.getPointFor(eastNorth));
        return this;
    }

    @Override
    public MapViewPath lineTo(MapViewState.MapViewPoint mapViewPoint) {
        super.lineTo(mapViewPoint);
        return this;
    }

    public MapViewPath shapeAround(ILatLon iLatLon, SymbolShape symbolShape, double d) {
        this.shapeAround(iLatLon.getEastNorth(this.state.getProjecting()), symbolShape, d);
        return this;
    }

    public MapViewPath shapeAround(EastNorth eastNorth, SymbolShape symbolShape, double d) {
        this.shapeAround(this.state.getPointFor(eastNorth), symbolShape, d);
        return this;
    }

    @Override
    public MapViewPath shapeAround(MapViewState.MapViewPoint mapViewPoint, SymbolShape symbolShape, double d) {
        super.shapeAround(mapViewPoint, symbolShape, d);
        return this;
    }

    public MapViewPath append(Iterable<? extends ILatLon> iterable, boolean bl) {
        this.appendWay(iterable, bl, false);
        return this;
    }

    public MapViewPath appendClosed(Iterable<? extends ILatLon> iterable, boolean bl) {
        this.appendWay(iterable, bl, true);
        return this;
    }

    private void appendWay(Iterable<? extends ILatLon> iterable, boolean bl, boolean bl2) {
        boolean bl3 = !bl;
        ILatLon iLatLon = null;
        for (ILatLon iLatLon2 : iterable) {
            if (bl3) {
                this.moveTo(iLatLon2);
            } else {
                this.lineTo(iLatLon2);
            }
            if (bl2 && iLatLon == null) {
                iLatLon = iLatLon2;
            }
            bl3 = false;
        }
        if (iLatLon != null) {
            this.lineTo(iLatLon);
        }
    }

    public void appendFromEastNorth(Path2D.Double double_) {
        new PathVisitor(){

            @Override
            public void visitMoveTo(double d, double d2) {
                MapViewPath.this.moveTo(new EastNorth(d, d2));
            }

            @Override
            public void visitLineTo(double d, double d2) {
                MapViewPath.this.lineTo(new EastNorth(d, d2));
            }

            @Override
            public void visitClose() {
                MapViewPath.this.closePath();
            }
        }.visit(double_);
    }

    public double visitLine(PathSegmentConsumer pathSegmentConsumer) {
        LineVisitor lineVisitor = new LineVisitor(pathSegmentConsumer);
        lineVisitor.visit(this);
        return lineVisitor.inLineOffset;
    }

    public Shape computeClippedLine(Stroke stroke) {
        MapPath2D mapPath2D = new MapPath2D();
        if (this.visitClippedLine(stroke, (d, mapViewPoint, mapViewPoint2, bl) -> {
            if (!bl) {
                mapPath2D.moveTo(mapViewPoint);
            }
            mapPath2D.lineTo(mapViewPoint2);
        })) {
            return mapPath2D;
        }
        return this;
    }

    public boolean visitClippedLine(Stroke stroke, PathSegmentConsumer pathSegmentConsumer) {
        if (stroke instanceof BasicStroke && ((BasicStroke)stroke).getDashArray() != null) {
            float f = 0.0f;
            for (float f2 : ((BasicStroke)stroke).getDashArray()) {
                f += f2;
            }
            return this.visitClippedLine(((BasicStroke)stroke).getDashPhase(), f, pathSegmentConsumer);
        }
        return this.visitClippedLine(0.0, 0.0, pathSegmentConsumer);
    }

    public boolean visitClippedLine(double d, double d2, PathSegmentConsumer pathSegmentConsumer) {
        return new ClampingPathVisitor(this.state.getViewClipRectangle(), d, d2, pathSegmentConsumer).visit(this);
    }

    public double getLength() {
        return this.visitLine((d, mapViewPoint, mapViewPoint2, bl) -> {});
    }

    private class ClampingPathVisitor
    extends AbstractMapPathVisitor {
        private final MapViewState.MapViewRectangle clip;
        private final PathSegmentConsumer consumer;
        protected double strokeProgress;
        private final double strokeLength;
        private MapViewState.MapViewPoint cursor;
        private boolean cursorIsActive;

        ClampingPathVisitor(MapViewState.MapViewRectangle mapViewRectangle, double d, double d2, PathSegmentConsumer pathSegmentConsumer) {
            this.clip = mapViewRectangle;
            this.strokeProgress = Math.min(d2 - d, 0.0);
            this.strokeLength = d2;
            this.consumer = pathSegmentConsumer;
        }

        @Override
        void visitMoveTo(MapViewState.MapViewPoint mapViewPoint) {
            this.cursor = mapViewPoint;
            this.cursorIsActive = false;
        }

        @Override
        void visitLineTo(MapViewState.MapViewPoint mapViewPoint) {
            MapViewState.MapViewPoint mapViewPoint2 = this.clip.getLineEntry(this.cursor, mapViewPoint);
            if (mapViewPoint2 != null) {
                MapViewState.MapViewPoint mapViewPoint3 = this.clip.getLineEntry(mapViewPoint, this.cursor);
                if (!this.cursorIsActive || !mapViewPoint2.equals(this.cursor)) {
                    mapViewPoint2 = this.alignStrokeOffset(mapViewPoint2, this.cursor);
                }
                this.consumer.addLineBetween(this.strokeProgress + this.cursor.distanceToInView(mapViewPoint2), mapViewPoint2, mapViewPoint3, this.cursorIsActive);
                this.cursorIsActive = mapViewPoint3.equals(mapViewPoint);
            }
            this.strokeProgress += this.cursor.distanceToInView(mapViewPoint);
            this.cursor = mapViewPoint;
        }

        private MapViewState.MapViewPoint alignStrokeOffset(MapViewState.MapViewPoint mapViewPoint, MapViewState.MapViewPoint mapViewPoint2) {
            double d = mapViewPoint.distanceToInViewSq(mapViewPoint2);
            if (d < 0.01 || this.strokeLength <= 0.001) {
                return mapViewPoint;
            }
            double d2 = Math.sqrt(d);
            double d3 = (this.strokeProgress + d2) % this.strokeLength;
            if (d3 < 0.01) {
                return mapViewPoint;
            }
            return mapViewPoint.interpolate(mapViewPoint2, d3 / d2);
        }
    }

    private final class LineVisitor
    extends AbstractMapPathVisitor {
        private final PathSegmentConsumer consumer;
        private MapViewState.MapViewPoint last;
        private double inLineOffset;
        private boolean startIsOldEnd;

        LineVisitor(PathSegmentConsumer pathSegmentConsumer) {
            this.consumer = pathSegmentConsumer;
        }

        @Override
        void visitMoveTo(MapViewState.MapViewPoint mapViewPoint) {
            this.last = mapViewPoint;
            this.startIsOldEnd = false;
        }

        @Override
        void visitLineTo(MapViewState.MapViewPoint mapViewPoint) {
            this.consumer.addLineBetween(this.inLineOffset, this.last, mapViewPoint, this.startIsOldEnd);
            this.inLineOffset += this.last.distanceToInView(mapViewPoint);
            this.last = mapViewPoint;
            this.startIsOldEnd = true;
        }
    }

    private abstract class AbstractMapPathVisitor
    implements PathVisitor {
        private MapViewState.MapViewPoint lastMoveTo;

        private AbstractMapPathVisitor() {
        }

        @Override
        public void visitMoveTo(double d, double d2) {
            MapViewState.MapViewPoint mapViewPoint;
            this.lastMoveTo = mapViewPoint = MapViewPath.this.state.getForView(d, d2);
            this.visitMoveTo(mapViewPoint);
        }

        abstract void visitMoveTo(MapViewState.MapViewPoint var1);

        @Override
        public void visitLineTo(double d, double d2) {
            this.visitLineTo(MapViewPath.this.state.getForView(d, d2));
        }

        abstract void visitLineTo(MapViewState.MapViewPoint var1);

        @Override
        public void visitClose() {
            this.visitLineTo(this.lastMoveTo);
        }
    }

    private static interface PathVisitor {
        default public boolean visit(Path2D.Double double_) {
            double[] dArray = new double[8];
            PathIterator pathIterator = double_.getPathIterator(null);
            while (!pathIterator.isDone()) {
                int n = pathIterator.currentSegment(dArray);
                switch (n) {
                    case 4: {
                        this.visitClose();
                        break;
                    }
                    case 1: {
                        this.visitLineTo(dArray[0], dArray[1]);
                        break;
                    }
                    case 0: {
                        this.visitMoveTo(dArray[0], dArray[1]);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                pathIterator.next();
            }
            return true;
        }

        public void visitClose();

        public void visitMoveTo(double var1, double var3);

        public void visitLineTo(double var1, double var3);
    }

    @FunctionalInterface
    public static interface PathSegmentConsumer {
        public void addLineBetween(double var1, MapViewState.MapViewPoint var3, MapViewState.MapViewPoint var4, boolean var5);
    }
}

