/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.importers;

import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.gui.conflict.tags.PasteTagsConflictResolverDialog;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTagTransferData;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractTagPaster;

public class PrimitiveTagTransferPaster
extends AbstractTagPaster {
    public PrimitiveTagTransferPaster() {
        super(PrimitiveTagTransferData.FLAVOR);
    }

    @Override
    public boolean importTagsOn(TransferHandler.TransferSupport transferSupport, Collection<? extends OsmPrimitive> collection) throws UnsupportedFlavorException, IOException {
        PrimitiveTagTransferData primitiveTagTransferData = (PrimitiveTagTransferData)transferSupport.getTransferable().getTransferData(this.df);
        TagPasteSupport tagPasteSupport = new TagPasteSupport(primitiveTagTransferData, collection);
        ArrayList<Command> arrayList = new ArrayList<Command>();
        for (Tag tag : tagPasteSupport.execute()) {
            arrayList.add(new ChangePropertyCommand(collection, tag.getKey(), "".equals(tag.getValue()) ? null : tag.getValue()));
        }
        PrimitiveTagTransferPaster.commitCommands(collection, arrayList);
        return true;
    }

    @Override
    protected Map<String, String> getTags(TransferHandler.TransferSupport transferSupport) throws UnsupportedFlavorException, IOException {
        PrimitiveTagTransferData primitiveTagTransferData = (PrimitiveTagTransferData)transferSupport.getTransferable().getTransferData(this.df);
        TagPasteSupport tagPasteSupport = new TagPasteSupport(primitiveTagTransferData, Arrays.asList(new Node()));
        return new TagMap(tagPasteSupport.execute());
    }

    private static class TagPasteSupport {
        private final PrimitiveTagTransferData data;
        private final Collection<? extends IPrimitive> selection;
        private final List<Tag> tags = new ArrayList<Tag>();

        TagPasteSupport(PrimitiveTagTransferData primitiveTagTransferData, Collection<? extends IPrimitive> collection) {
            this.data = primitiveTagTransferData;
            this.selection = collection;
        }

        protected void pasteFromHomogeneousSource() {
            TagCollection tagCollection = null;
            for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.dataValues()) {
                TagCollection tagCollection2 = this.data.getForPrimitives(osmPrimitiveType);
                if (tagCollection2.isEmpty()) continue;
                tagCollection = tagCollection2;
            }
            if (tagCollection == null) {
                return;
            }
            if (!tagCollection.isApplicableToPrimitive()) {
                PasteTagsConflictResolverDialog pasteTagsConflictResolverDialog = new PasteTagsConflictResolverDialog(Main.parent);
                pasteTagsConflictResolverDialog.populate(tagCollection, this.data.getStatistics(), this.getTargetStatistics());
                pasteTagsConflictResolverDialog.setVisible(true);
                if (pasteTagsConflictResolverDialog.isCanceled()) {
                    return;
                }
                this.buildTags(pasteTagsConflictResolverDialog.getResolution());
            } else {
                this.buildTags(tagCollection);
            }
        }

        protected boolean canPasteFromHeterogeneousSourceWithoutConflict() {
            for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.dataValues()) {
                TagCollection tagCollection;
                if (!this.hasTargetPrimitives(osmPrimitiveType) || (tagCollection = this.data.getForPrimitives(osmPrimitiveType)).isEmpty() || tagCollection.isApplicableToPrimitive()) continue;
                return false;
            }
            return true;
        }

        protected void pasteFromHeterogeneousSource() {
            if (this.canPasteFromHeterogeneousSourceWithoutConflict()) {
                for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.dataValues()) {
                    if (this.data.getForPrimitives(osmPrimitiveType).isEmpty() || !this.hasTargetPrimitives(osmPrimitiveType)) continue;
                    this.buildTags(this.data.getForPrimitives(osmPrimitiveType));
                }
            } else {
                PasteTagsConflictResolverDialog pasteTagsConflictResolverDialog = new PasteTagsConflictResolverDialog(Main.parent);
                pasteTagsConflictResolverDialog.populate(this.data.getForPrimitives(OsmPrimitiveType.NODE), this.data.getForPrimitives(OsmPrimitiveType.WAY), this.data.getForPrimitives(OsmPrimitiveType.RELATION), this.data.getStatistics(), this.getTargetStatistics());
                pasteTagsConflictResolverDialog.setVisible(true);
                if (pasteTagsConflictResolverDialog.isCanceled()) {
                    return;
                }
                for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.dataValues()) {
                    if (this.data.getForPrimitives(osmPrimitiveType).isEmpty() || !this.hasTargetPrimitives(osmPrimitiveType)) continue;
                    this.buildTags(pasteTagsConflictResolverDialog.getResolution(osmPrimitiveType));
                }
            }
        }

        protected Map<OsmPrimitiveType, Integer> getTargetStatistics() {
            EnumMap<OsmPrimitiveType, Integer> enumMap = new EnumMap<OsmPrimitiveType, Integer>(OsmPrimitiveType.class);
            for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.dataValues()) {
                int n = (int)this.selection.stream().filter(iPrimitive -> osmPrimitiveType == iPrimitive.getType()).count();
                if (n <= 0) continue;
                enumMap.put(osmPrimitiveType, n);
            }
            return enumMap;
        }

        protected boolean hasTargetPrimitives(OsmPrimitiveType osmPrimitiveType) {
            return this.selection.stream().anyMatch(iPrimitive -> osmPrimitiveType == iPrimitive.getType());
        }

        protected void buildTags(TagCollection tagCollection) {
            for (String string : tagCollection.getKeys()) {
                this.tags.add(new Tag(string, tagCollection.getValues(string).iterator().next()));
            }
        }

        public List<Tag> execute() {
            this.tags.clear();
            if (this.data.isHeterogeneousSource()) {
                this.pasteFromHeterogeneousSource();
            } else {
                this.pasteFromHomogeneousSource();
            }
            return this.tags;
        }

        public String toString() {
            return "PasteSupport [data=" + this.data + ", selection=" + this.selection + ']';
        }
    }
}

