/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.IExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ExtendedDialog
extends JDialog
implements IExtendedDialog {
    private final boolean disposeOnClose;
    private volatile int result;
    public static final int DialogClosedOtherwise = 0;
    private boolean toggleable;
    private String rememberSizePref = "";
    private transient WindowGeometry defaultWindowGeometry;
    private String togglePref = "";
    private int toggleValue = -1;
    private ConditionalOptionPaneUtil.MessagePanel togglePanel;
    private Component parent;
    private Component content;
    private final String[] bTexts;
    private String[] bToolTipTexts;
    private transient Icon[] bIcons;
    private Set<Integer> cancelButtonIdx = Collections.emptySet();
    private int defaultButtonIdx = 1;
    protected JButton defaultButton;
    private transient Icon icon;
    private boolean modal;
    private boolean focusOnDefaultButton;
    private boolean showHelpButton;
    private String helpTopic;
    private boolean placeContentInScrollPane;
    protected transient Insets contentInsets = new Insets(10, 5, 0, 5);
    protected transient List<JButton> buttons = new ArrayList<JButton>();
    private boolean setupDone;

    public ExtendedDialog(Component component, String string, String ... stringArray) {
        this(component, string, stringArray, true, true);
    }

    public ExtendedDialog(Component component, String string, String[] stringArray, boolean bl) {
        this(component, string, stringArray, bl, true);
    }

    public ExtendedDialog(Component component, String string, String[] stringArray, boolean bl, boolean bl2) {
        super((Window)ExtendedDialog.searchRealParent(component), string, bl ? Dialog.ModalityType.DOCUMENT_MODAL : Dialog.ModalityType.MODELESS);
        this.parent = component;
        this.modal = bl;
        this.bTexts = Utils.copyArray(stringArray);
        if (bl2) {
            this.setDefaultCloseOperation(2);
        }
        this.disposeOnClose = bl2;
    }

    private static Frame searchRealParent(Component component) {
        if (component == null) {
            return null;
        }
        return GuiHelper.getFrameForComponent(component);
    }

    @Override
    public ExtendedDialog setButtonIcons(Icon ... iconArray) {
        this.bIcons = Utils.copyArray(iconArray);
        return this;
    }

    @Override
    public ExtendedDialog setButtonIcons(String ... stringArray) {
        this.bIcons = new Icon[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.bIcons[i] = ImageProvider.get(stringArray[i]);
        }
        return this;
    }

    @Override
    public ExtendedDialog setToolTipTexts(String ... stringArray) {
        this.bToolTipTexts = Utils.copyArray(stringArray);
        return this;
    }

    @Override
    public ExtendedDialog setContent(Component component) {
        return this.setContent(component, true);
    }

    @Override
    public ExtendedDialog setContent(Component component, boolean bl) {
        this.content = component;
        this.placeContentInScrollPane = bl;
        return this;
    }

    @Override
    public ExtendedDialog setContent(String string) {
        return this.setContent(ExtendedDialog.string2label(string), false);
    }

    @Override
    public ExtendedDialog setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public ExtendedDialog setIcon(int n) {
        switch (n) {
            case 0: {
                return this.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
            }
            case 1: {
                return this.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
            }
            case 2: {
                return this.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
            }
            case 3: {
                return this.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
            }
            case -1: {
                return this.setIcon(null);
            }
        }
        throw new IllegalArgumentException("Unknown message type!");
    }

    @Override
    public ExtendedDialog showDialog() {
        if (this.toggleCheckState()) {
            this.result = this.toggleValue;
            return this;
        }
        this.setupDialog();
        if (this.defaultButton != null) {
            this.getRootPane().setDefaultButton(this.defaultButton);
        }
        if (this.toggleable || this.focusOnDefaultButton) {
            this.requestFocusToDefaultButton();
        }
        this.setVisible(true);
        this.toggleSaveState();
        return this;
    }

    @Override
    public int getValue() {
        return this.result;
    }

    @Override
    public void setupDialog() {
        boolean bl;
        Serializable serializable;
        if (this.setupDone) {
            return;
        }
        this.setupDone = true;
        this.setupEscListener();
        JPanel jPanel = new JPanel(new GridBagLayout());
        for (int i = 0; i < this.bTexts.length; ++i) {
            JButton jButton = new JButton(this.createButtonAction(i));
            if (i == this.defaultButtonIdx - 1) {
                this.defaultButton = jButton;
            }
            if (this.bIcons != null && this.bIcons[i] != null) {
                jButton.setIcon(this.bIcons[i]);
            }
            if (this.bToolTipTexts != null && i < this.bToolTipTexts.length && this.bToolTipTexts[i] != null) {
                jButton.setToolTipText(this.bToolTipTexts[i]);
            }
            jPanel.add((Component)jButton, GBC.std().insets(2, 2, 2, 2));
            this.buttons.add(jButton);
        }
        if (this.showHelpButton) {
            jPanel.add((Component)new JButton(new HelpAction()), GBC.std().insets(2, 2, 2, 2));
            HelpUtil.setHelpContext(this.getRootPane(), this.helpTopic);
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        if (this.icon != null) {
            serializable = new JLabel(this.icon);
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weighty = 1.0;
            jPanel2.add((Component)serializable, gridBagConstraints);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridx = 1;
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = this.contentInsets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(this.content, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        if (this.toggleable) {
            this.togglePanel = new ConditionalOptionPaneUtil.MessagePanel((Object)null, ConditionalOptionPaneUtil.isInBulkOperation(this.togglePref));
            gridBagConstraints.gridx = this.icon != null ? 1 : 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(5, this.contentInsets.left, 5, this.contentInsets.right);
            jPanel2.add((Component)this.togglePanel, gridBagConstraints);
        }
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel2.add((Component)jPanel, gridBagConstraints);
        if (this.placeContentInScrollPane) {
            serializable = new JScrollPane(jPanel2);
            GuiHelper.setDefaultIncrement((JScrollPane)serializable);
            ((JComponent)serializable).setBorder(null);
            this.setContentPane((Container)serializable);
        } else {
            this.setContentPane(jPanel2);
        }
        this.pack();
        serializable = this.getSize();
        Dimension dimension = this.findMaxDialogSize();
        boolean bl2 = ((Dimension)serializable).width > dimension.width;
        boolean bl3 = bl = ((Dimension)serializable).height > dimension.height;
        if (dimension.width > 0 && ((Dimension)serializable).width > dimension.width) {
            ((Dimension)serializable).width = dimension.width;
        }
        if (dimension.height > 0 && ((Dimension)serializable).height > dimension.height) {
            ((Dimension)serializable).height = dimension.height;
        }
        if (!bl2 && bl) {
            ((Dimension)serializable).width += new JScrollBar().getPreferredSize().width;
        }
        this.setSize((Dimension)serializable);
        this.setLocationRelativeTo(this.parent);
    }

    protected Action createButtonAction(final int n) {
        return new AbstractAction(this.bTexts[n]){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedDialog.this.buttonAction(n, actionEvent);
            }
        };
    }

    protected void buttonAction(int n, ActionEvent actionEvent) {
        this.result = n + 1;
        this.setVisible(false);
    }

    protected Dimension findMaxDialogSize() {
        Dimension dimension = GuiHelper.getScreenSize();
        Dimension dimension2 = new Dimension(dimension.width * 2 / 3, dimension.height * 2 / 3);
        if (this.parent != null && this.parent.isVisible()) {
            dimension2 = GuiHelper.getFrameForComponent(this.parent).getSize();
        }
        return dimension2;
    }

    private void setupEscListener() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedDialog.this.result = 0;
                if (Main.isDebugEnabled()) {
                    Main.debug(this.getClass().getName() + " ESC action performed (" + actionEvent + ") from " + new Exception().getStackTrace()[1]);
                }
                ExtendedDialog.this.setVisible(false);
            }
        };
        InputMapUtils.addEscapeAction(this.getRootPane(), abstractAction);
    }

    protected final void rememberWindowGeometry(WindowGeometry windowGeometry) {
        if (windowGeometry != null) {
            windowGeometry.remember(this.rememberSizePref);
        }
    }

    protected final WindowGeometry initWindowGeometry() {
        return new WindowGeometry(this.rememberSizePref, this.defaultWindowGeometry);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.repaint();
        }
        if (Main.isDebugEnabled()) {
            Main.debug(this.getClass().getName() + ".setVisible(" + bl + ") from " + new Exception().getStackTrace()[1]);
        }
        if (!this.rememberSizePref.isEmpty() && this.defaultWindowGeometry != null) {
            if (bl) {
                this.initWindowGeometry().applySafe(this);
            } else if (this.isShowing()) {
                this.rememberWindowGeometry(new WindowGeometry(this));
            }
        }
        super.setVisible(bl);
        if (!bl && this.disposeOnClose) {
            this.dispose();
        }
    }

    @Override
    public ExtendedDialog setRememberWindowGeometry(String string, WindowGeometry windowGeometry) {
        this.rememberSizePref = string == null ? "" : string;
        this.defaultWindowGeometry = windowGeometry;
        return this;
    }

    @Override
    public ExtendedDialog toggleEnable(String string) {
        if (!this.modal) {
            throw new IllegalStateException();
        }
        this.toggleable = true;
        this.togglePref = string;
        return this;
    }

    @Override
    public ExtendedDialog setDefaultButton(int n) {
        this.defaultButtonIdx = n;
        return this;
    }

    @Override
    public ExtendedDialog setCancelButton(Integer ... integerArray) {
        this.cancelButtonIdx = new HashSet<Integer>(Arrays.asList(integerArray));
        return this;
    }

    @Override
    public void setFocusOnDefaultButton(boolean bl) {
        this.focusOnDefaultButton = bl;
    }

    private void requestFocusToDefaultButton() {
        if (this.defaultButton != null) {
            GuiHelper.runInEDT(this.defaultButton::requestFocusInWindow);
        }
    }

    @Override
    public final boolean toggleCheckState() {
        this.toggleable = this.togglePref != null && !this.togglePref.isEmpty();
        this.toggleValue = ConditionalOptionPaneUtil.getDialogReturnValue(this.togglePref);
        return this.toggleable && this.toggleValue != -1;
    }

    protected void toggleSaveState() {
        if (!this.toggleable || this.togglePanel == null || this.cancelButtonIdx.contains(this.result) || this.result == 0) {
            return;
        }
        this.togglePanel.getNotShowAgain().store(this.togglePref, this.result);
    }

    private static JMultilineLabel string2label(String string) {
        JMultilineLabel jMultilineLabel = new JMultilineLabel(string);
        Dimension dimension = GuiHelper.getScreenSize();
        jMultilineLabel.setMaxWidth(dimension.width / 2);
        jMultilineLabel.getInputMap().put(KeyStroke.getKeyStroke(10, 0), new Object());
        return jMultilineLabel;
    }

    @Override
    public ExtendedDialog configureContextsensitiveHelp(String string, boolean bl) {
        this.helpTopic = string;
        this.showHelpButton = bl;
        return this;
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("ShortDescription", I18n.tr("Show help information", new Object[0]));
            this.putValue("Name", I18n.tr("Help", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help"));
            this.setEnabled(!Main.isOffline(OnlineResource.JOSM_WEBSITE));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HelpBrowser.setUrlForHelpTopic(ExtendedDialog.this.helpTopic);
        }
    }
}

