/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

public class DuplicateRelation
extends Test {
    protected static final int DUPLICATE_RELATION = 1901;
    protected static final int SAME_RELATION = 1902;
    private MultiMap<RelationPair, OsmPrimitive> relations;
    private MultiMap<List<RelationMember>, OsmPrimitive> relationsNoKeys;
    private final Set<String> ignoreKeys = new HashSet<String>(OsmPrimitive.getUninterestingKeys());

    public DuplicateRelation() {
        super(I18n.tr("Duplicated relations", new Object[0]), I18n.tr("This test checks that there are no relations with same tags and same members with same roles.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.relations = new MultiMap(1000);
        this.relationsNoKeys = new MultiMap(1000);
    }

    @Override
    public void endTest() {
        TestError testError;
        super.endTest();
        for (Set<OsmPrimitive> set : this.relations.values()) {
            if (set.size() <= 1) continue;
            testError = TestError.builder(this, Severity.ERROR, 1901).message(I18n.tr("Duplicated relations", new Object[0])).primitives(set).build();
            this.errors.add(testError);
        }
        this.relations = null;
        for (Set<OsmPrimitive> set : this.relationsNoKeys.values()) {
            if (set.size() <= 1) continue;
            testError = TestError.builder(this, Severity.WARNING, 1902).message(I18n.tr("Relations with same members", new Object[0])).primitives(set).build();
            this.errors.add(testError);
        }
        this.relationsNoKeys = null;
    }

    @Override
    public void visit(Relation relation) {
        if (!relation.isUsable() || relation.hasIncompleteMembers() || "tmc".equals(relation.get("type")) || "TMC".equals(relation.get("type"))) {
            return;
        }
        List<RelationMember> list = relation.getMembers();
        TagMap tagMap = relation.getKeys();
        for (String string : this.ignoreKeys) {
            tagMap.remove(string);
        }
        RelationPair relationPair = new RelationPair(list, tagMap);
        this.relations.put(relationPair, relation);
        this.relationsNoKeys.put(list, relation);
    }

    @Override
    public Command fixError(TestError testError) {
        if (testError.getCode() == 1902) {
            return null;
        }
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        HashSet<Relation> hashSet = new HashSet<Relation>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Relation) || osmPrimitive.isDeleted()) continue;
            hashSet.add((Relation)osmPrimitive);
        }
        if (hashSet.size() < 2) {
            return null;
        }
        long l = 0L;
        Relation object = (Relation)hashSet.iterator().next();
        Relation object2 = null;
        List<Relation> list = null;
        for (Relation object3 : hashSet) {
            List<Relation> list2 = OsmPrimitive.getFilteredList(object3.getReferrers(), Relation.class);
            if (!list2.isEmpty()) {
                if (object2 != null) {
                    throw new AssertionError((Object)"Cannot fix duplicate relations: More than one relation is member of another relation.");
                }
                object2 = object3;
                list = list2;
            }
            if (object3.isNew() || l != 0L && object3.getId() >= l) continue;
            l = object3.getId();
            object = object3;
        }
        LinkedList linkedList = new LinkedList();
        if (object2 != null && object != object2) {
            for (Relation relation : list) {
                Relation relation2 = new Relation(relation);
                for (int i = 0; i < relation2.getMembers().size(); ++i) {
                    RelationMember relationMember = relation2.getMember(i);
                    if (!object2.equals(relationMember.getMember())) continue;
                    relation2.setMember(i, new RelationMember(relationMember.getRole(), object));
                }
                linkedList.add(new ChangeCommand(relation, relation2));
            }
        }
        hashSet.remove(object);
        linkedList.add(new DeleteCommand(hashSet));
        return new SequenceCommand(I18n.tr("Delete duplicate relations", new Object[0]), linkedList);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (!(testError.getTester() instanceof DuplicateRelation) || testError.getCode() == 1902) {
            return false;
        }
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        HashSet<Relation> hashSet = new HashSet<Relation>();
        for (OsmPrimitive object : collection) {
            if (!(object instanceof Relation)) continue;
            hashSet.add((Relation)object);
        }
        if (hashSet.size() < 2) {
            return false;
        }
        int n = 0;
        for (Relation relation : hashSet) {
            List<Relation> list = OsmPrimitive.getFilteredList(relation.getReferrers(), Relation.class);
            if (list.isEmpty()) continue;
            ++n;
        }
        return n <= 1;
    }

    private static class RelationPair {
        private final RelationMembers members;
        private final Map<String, String> keys;

        RelationPair(List<RelationMember> list, Map<String, String> map) {
            this.members = new RelationMembers(list);
            this.keys = map;
        }

        public int hashCode() {
            return Objects.hash(this.members, this.keys);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RelationPair relationPair = (RelationPair)object;
            return Objects.equals(this.members, relationPair.members) && Objects.equals(this.keys, relationPair.keys);
        }
    }

    private static class RelationMembers {
        private final List<RelMember> members;

        RelationMembers(List<RelationMember> list) {
            this.members = new ArrayList<RelMember>(list.size());
            for (RelationMember relationMember : list) {
                this.members.add(new RelMember(relationMember));
            }
        }

        public int hashCode() {
            return Objects.hash(this.members);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RelationMembers relationMembers = (RelationMembers)object;
            return Objects.equals(this.members, relationMembers.members);
        }
    }

    public static class RelMember {
        private final String role;
        private final OsmPrimitiveType type;
        private Map<String, String> tags;
        private List<LatLon> coor;
        private long relId;

        public int hashCode() {
            return Objects.hash(new Object[]{this.role, this.type, this.tags, this.coor, this.relId});
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RelMember relMember = (RelMember)object;
            return this.relId == relMember.relId && this.type == relMember.type && Objects.equals(this.role, relMember.role) && Objects.equals(this.tags, relMember.tags) && Objects.equals(this.coor, relMember.coor);
        }

        public RelMember(RelationMember relationMember) {
            OsmPrimitive osmPrimitive;
            this.role = relationMember.getRole();
            this.type = relationMember.getType();
            this.relId = 0L;
            this.coor = new ArrayList<LatLon>();
            if (relationMember.isNode()) {
                osmPrimitive = relationMember.getNode();
                this.tags = osmPrimitive.getKeys();
                this.coor = new ArrayList<LatLon>(1);
                this.coor.add(((Node)osmPrimitive).getCoor());
            }
            if (relationMember.isWay()) {
                osmPrimitive = relationMember.getWay();
                this.tags = osmPrimitive.getKeys();
                List<Node> list = ((Way)osmPrimitive).getNodes();
                this.coor = new ArrayList<LatLon>(list.size());
                for (Node node : list) {
                    this.coor.add(node.getCoor());
                }
            }
            if (relationMember.isRelation()) {
                osmPrimitive = relationMember.getRelation();
                this.tags = osmPrimitive.getKeys();
                this.relId = osmPrimitive.getId();
                this.coor = new ArrayList<LatLon>();
            }
        }
    }
}

