/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class TransformNodesCommand
extends Command {
    protected Collection<Node> nodes = new LinkedList<Node>();
    protected Map<Node, Command.OldNodeState> oldStates = new HashMap<Node, Command.OldNodeState>();

    protected final void storeOldState() {
        for (Node node : this.nodes) {
            this.oldStates.put(node, new Command.OldNodeState(node));
        }
    }

    public TransformNodesCommand(Collection<? extends OsmPrimitive> collection) {
        this.nodes = AllNodesVisitor.getAllNodes(collection);
        this.storeOldState();
    }

    public abstract void handleEvent(EastNorth var1);

    protected abstract void transformNodes();

    @Override
    public boolean executeCommand() {
        this.transformNodes();
        this.flagNodesAsModified();
        return true;
    }

    public void flagNodesAsModified() {
        for (Node node : this.nodes) {
            node.setModified(true);
        }
    }

    @Override
    public void undoCommand() {
        for (Node node : this.nodes) {
            Command.OldNodeState oldNodeState = this.oldStates.get(node);
            node.setCoor(oldNodeState.getLatLon());
            node.setModified(oldNodeState.isModified());
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.nodes;
    }

    @Override
    public String getDescriptionText() {
        return I18n.trn("Transform {0} node", "Transform {0} nodes", this.nodes.size(), this.nodes.size());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "node");
    }

    public Collection<Node> getTransformedNodes() {
        return this.nodes;
    }

    public EastNorth getNodesCenter() {
        EastNorth eastNorth = new EastNorth(0.0, 0.0);
        for (Node node : this.nodes) {
            EastNorth eastNorth2 = node.getEastNorth();
            eastNorth = eastNorth.add(eastNorth2.east(), eastNorth2.north());
        }
        return new EastNorth(eastNorth.east() / (double)this.nodes.size(), eastNorth.north() / (double)this.nodes.size());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nodes, this.oldStates);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TransformNodesCommand transformNodesCommand = (TransformNodesCommand)object;
        return Objects.equals(this.nodes, transformNodesCommand.nodes) && Objects.equals(this.oldStates, transformNodesCommand.oldStates);
    }
}

