/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MoveCommand
extends Command {
    private Collection<Node> nodes = new LinkedList<Node>();
    private EastNorth startEN = null;
    private double x;
    private double y;
    private double backupX;
    private double backupY;
    private final List<Command.OldNodeState> oldState = new LinkedList<Command.OldNodeState>();

    public MoveCommand(OsmPrimitive osmPrimitive, double d, double d2) {
        this(Collections.singleton(osmPrimitive), d, d2);
    }

    public MoveCommand(Node node, LatLon latLon) {
        this(Collections.singleton(node), Projections.project(latLon).subtract(node.getEastNorth()));
    }

    public MoveCommand(Collection<OsmPrimitive> collection, EastNorth eastNorth) {
        this(collection, eastNorth.getX(), eastNorth.getY());
    }

    public MoveCommand(Collection<OsmPrimitive> collection, double d, double d2) {
        this.saveCheckpoint();
        this.x = d;
        this.y = d2;
        Objects.requireNonNull(collection, "objects");
        this.nodes = AllNodesVisitor.getAllNodes(collection);
        for (Node node : this.nodes) {
            this.oldState.add(new Command.OldNodeState(node));
        }
    }

    public MoveCommand(Collection<OsmPrimitive> collection, EastNorth eastNorth, EastNorth eastNorth2) {
        this(Objects.requireNonNull(collection, "objects"), Objects.requireNonNull(eastNorth2, "end").getX() - Objects.requireNonNull(eastNorth, "start").getX(), Objects.requireNonNull(eastNorth2, "end").getY() - Objects.requireNonNull(eastNorth, "start").getY());
        this.startEN = eastNorth;
    }

    public MoveCommand(OsmPrimitive osmPrimitive, EastNorth eastNorth, EastNorth eastNorth2) {
        this(Collections.singleton(Objects.requireNonNull(osmPrimitive, "p")), Objects.requireNonNull(eastNorth2, "end").getX() - Objects.requireNonNull(eastNorth, "start").getX(), Objects.requireNonNull(eastNorth2, "end").getY() - Objects.requireNonNull(eastNorth, "start").getY());
        this.startEN = eastNorth;
    }

    public void moveAgain(double d, double d2) {
        for (Node node : this.nodes) {
            node.setEastNorth(node.getEastNorth().add(d, d2));
        }
        this.x += d;
        this.y += d2;
    }

    public void moveAgainTo(double d, double d2) {
        this.moveAgain(d - this.x, d2 - this.y);
    }

    public void applyVectorTo(EastNorth eastNorth) {
        if (this.startEN == null) {
            return;
        }
        this.x = eastNorth.getX() - this.startEN.getX();
        this.y = eastNorth.getY() - this.startEN.getY();
        this.updateCoordinates();
    }

    public void changeStartPoint(EastNorth eastNorth) {
        this.startEN = new EastNorth(eastNorth.getX() - this.x, eastNorth.getY() - this.y);
    }

    public final void saveCheckpoint() {
        this.backupX = this.x;
        this.backupY = this.y;
    }

    public void resetToCheckpoint() {
        this.x = this.backupX;
        this.y = this.backupY;
        this.updateCoordinates();
    }

    private void updateCoordinates() {
        Iterator<Command.OldNodeState> iterator = this.oldState.iterator();
        for (Node node : this.nodes) {
            Command.OldNodeState oldNodeState = iterator.next();
            if (oldNodeState.getEastNorth() == null) continue;
            node.setEastNorth(oldNodeState.getEastNorth().add(this.x, this.y));
        }
    }

    @Override
    public boolean executeCommand() {
        this.ensurePrimitivesAreInDataset();
        for (Node node : this.nodes) {
            if (node == null) {
                throw new AssertionError((Object)"null detected in node list");
            }
            EastNorth eastNorth = node.getEastNorth();
            if (eastNorth == null) continue;
            node.setEastNorth(eastNorth.add(this.x, this.y));
            node.setModified(true);
        }
        return true;
    }

    @Override
    public void undoCommand() {
        this.ensurePrimitivesAreInDataset();
        Iterator<Command.OldNodeState> iterator = this.oldState.iterator();
        for (Node node : this.nodes) {
            Command.OldNodeState oldNodeState = iterator.next();
            node.setCoor(oldNodeState.getLatLon());
            node.setModified(oldNodeState.isModified());
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        for (OsmPrimitive osmPrimitive : this.nodes) {
            collection.add(osmPrimitive);
        }
    }

    @Override
    public String getDescriptionText() {
        return I18n.trn("Move {0} node", "Move {0} nodes", this.nodes.size(), this.nodes.size());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "node");
    }

    public Collection<Node> getParticipatingPrimitives() {
        return this.nodes;
    }

    protected EastNorth getOffset() {
        return new EastNorth(this.x, this.y);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nodes, this.startEN, this.x, this.y, this.backupX, this.backupY, this.oldState);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MoveCommand moveCommand = (MoveCommand)object;
        return Double.compare(moveCommand.x, this.x) == 0 && Double.compare(moveCommand.y, this.y) == 0 && Double.compare(moveCommand.backupX, this.backupX) == 0 && Double.compare(moveCommand.backupY, this.backupY) == 0 && Objects.equals(this.nodes, moveCommand.nodes) && Objects.equals(this.startEN, moveCommand.startEN) && Objects.equals(this.oldState, moveCommand.oldState);
    }
}

