/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PurgeCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public class AddPrimitivesCommand
extends Command {
    private List<PrimitiveData> data;
    private Collection<PrimitiveData> toSelect;
    private List<PrimitiveData> preExistingData;
    private List<OsmPrimitive> createdPrimitives;

    public AddPrimitivesCommand(List<PrimitiveData> list) {
        this(list, list);
    }

    public AddPrimitivesCommand(List<PrimitiveData> list, List<PrimitiveData> list2) {
        this.init(list, list2);
    }

    public AddPrimitivesCommand(List<PrimitiveData> list, List<PrimitiveData> list2, OsmDataLayer osmDataLayer) {
        super(osmDataLayer);
        this.init(list, list2);
    }

    private void init(List<PrimitiveData> list, List<PrimitiveData> list2) {
        CheckParameterUtil.ensureParameterNotNull(list, "data");
        this.data = new ArrayList<PrimitiveData>(list);
        if (list2 == list) {
            this.toSelect = this.data;
        } else if (list2 != null) {
            this.toSelect = new ArrayList<PrimitiveData>(list2);
        }
    }

    @Override
    public boolean executeCommand() {
        DataSet dataSet = this.getAffectedDataSet();
        if (this.createdPrimitives == null) {
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(this.data.size());
            this.preExistingData = new ArrayList<PrimitiveData>();
            for (PrimitiveData primitiveData2 : this.data) {
                boolean bl;
                OsmPrimitive osmPrimitive2 = dataSet.getPrimitiveById(primitiveData2);
                boolean bl2 = bl = osmPrimitive2 == null;
                if (osmPrimitive2 == null) {
                    osmPrimitive2 = primitiveData2.getType().newInstance(primitiveData2.getUniqueId(), true);
                } else {
                    this.preExistingData.add(osmPrimitive2.save());
                }
                if (primitiveData2 instanceof NodeData) {
                    osmPrimitive2.load(primitiveData2);
                }
                if (bl) {
                    dataSet.addPrimitive(osmPrimitive2);
                }
                arrayList.add(osmPrimitive2);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i) instanceof Node) continue;
                ((OsmPrimitive)arrayList.get(i)).load(this.data.get(i));
            }
            arrayList.stream().forEach(osmPrimitive -> osmPrimitive.setModified(true));
        } else {
            for (OsmPrimitive osmPrimitive3 : this.createdPrimitives) {
                if (this.preExistingData.stream().anyMatch(primitiveData -> primitiveData.getUniqueId() == osmPrimitive3.getUniqueId())) {
                    Optional<PrimitiveData> optional = this.data.stream().filter(primitiveData -> primitiveData.getUniqueId() == osmPrimitive3.getUniqueId()).findAny();
                    if (!optional.isPresent()) continue;
                    osmPrimitive3.load(optional.get());
                    continue;
                }
                dataSet.addPrimitive(osmPrimitive3);
            }
        }
        if (this.toSelect != null) {
            dataSet.setSelected(this.toSelect.stream().map(dataSet::getPrimitiveById).collect(Collectors.toList()));
        }
        return true;
    }

    @Override
    public void undoCommand() {
        Optional<PrimitiveData> optional;
        DataSet dataSet = this.getAffectedDataSet();
        if (this.createdPrimitives == null) {
            this.createdPrimitives = new ArrayList<OsmPrimitive>(this.data.size());
            for (PrimitiveData abstractPrimitive : this.data) {
                optional = dataSet.getPrimitiveById(abstractPrimitive);
                this.createdPrimitives.add((OsmPrimitive)((Object)optional));
            }
            this.createdPrimitives = PurgeCommand.topoSort(this.createdPrimitives);
        }
        for (OsmPrimitive osmPrimitive : this.createdPrimitives) {
            optional = this.preExistingData.stream().filter(primitiveData -> primitiveData.getUniqueId() == osmPrimitive.getUniqueId()).findAny();
            if (optional.isPresent()) {
                osmPrimitive.load((PrimitiveData)optional.get());
                continue;
            }
            dataSet.removePrimitive((PrimitiveId)osmPrimitive);
        }
    }

    @Override
    public String getDescriptionText() {
        int n = this.data != null ? this.data.size() : this.createdPrimitives.size();
        return I18n.trn("Added {0} object", "Added {0} objects", n, n);
    }

    @Override
    public Icon getDescriptionIcon() {
        return null;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        if (this.createdPrimitives != null) {
            return this.createdPrimitives;
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (PrimitiveData primitiveData : this.data) {
            hashSet.add(Optional.ofNullable(this.getAffectedDataSet().getPrimitiveById(primitiveData)).orElseThrow(() -> new JosmRuntimeException("No primitive found for " + primitiveData)));
        }
        return hashSet;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.data, this.toSelect, this.preExistingData, this.createdPrimitives);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AddPrimitivesCommand addPrimitivesCommand = (AddPrimitivesCommand)object;
        return Objects.equals(this.data, addPrimitivesCommand.data) && Objects.equals(this.toSelect, addPrimitivesCommand.toSelect) && Objects.equals(this.preExistingData, addPrimitivesCommand.preExistingData) && Objects.equals(this.createdPrimitives, addPrimitivesCommand.createdPrimitives);
    }
}

