/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;

public final class DownloadOsmInViewAction
extends JosmAction {
    public DownloadOsmInViewAction() {
        super(I18n.tr("Download in current view", new Object[0]), "download_in_view", I18n.tr("Download map data from the OSM server in current view", new Object[0]), null, false, "dialogs/download_in_view", true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Bounds bounds = Main.map.mapView.getRealBounds();
        DownloadOsmInViewTask downloadOsmInViewTask = new DownloadOsmInViewTask();
        downloadOsmInViewTask.setZoomAfterDownload(false);
        Future<?> future = downloadOsmInViewTask.download(bounds);
        Main.worker.submit(new PostDownloadHandler(downloadOsmInViewTask, future));
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(Main.getLayerManager().getActiveLayer() != null && !Main.isOffline(OnlineResource.OSM_API));
    }

    private static class DownloadOsmInViewTask
    extends DownloadOsmTask {
        private DownloadOsmInViewTask() {
        }

        Future<?> download(Bounds bounds) {
            return this.download(new DownloadOsmTask.DownloadTask(this, false, new BoundingBoxDownloader(bounds), null, false), bounds);
        }
    }
}

