/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.glassfish.json.JsonGeneratorImpl;
import org.glassfish.json.JsonPrettyGeneratorImpl;
import org.glassfish.json.api.BufferPool;

class JsonGeneratorFactoryImpl
implements JsonGeneratorFactory {
    private final boolean prettyPrinting;
    private final Map<String, ?> config;
    private final BufferPool bufferPool;

    JsonGeneratorFactoryImpl(Map<String, ?> map, boolean bl, BufferPool bufferPool) {
        this.config = map;
        this.prettyPrinting = bl;
        this.bufferPool = bufferPool;
    }

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        return this.prettyPrinting ? new JsonPrettyGeneratorImpl(writer, this.bufferPool) : new JsonGeneratorImpl(writer, this.bufferPool);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream outputStream) {
        return this.prettyPrinting ? new JsonPrettyGeneratorImpl(outputStream, this.bufferPool) : new JsonGeneratorImpl(outputStream, this.bufferPool);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream outputStream, Charset charset) {
        return this.prettyPrinting ? new JsonPrettyGeneratorImpl(outputStream, charset, this.bufferPool) : new JsonGeneratorImpl(outputStream, charset, this.bufferPool);
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return this.config;
    }
}

