/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.jcs.engine.AbstractCacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.threadpool.ThreadPoolManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PooledCacheEventQueue<K, V>
extends AbstractCacheEventQueue<K, V> {
    private static final Log log = LogFactory.getLog(PooledCacheEventQueue.class);
    private static final ICacheEventQueue.QueueType queueType = ICacheEventQueue.QueueType.POOLED;
    protected ExecutorService pool = null;
    protected BlockingQueue<Runnable> queue = null;

    public PooledCacheEventQueue(ICacheListener<K, V> iCacheListener, long l, String string, int n, int n2, String string2) {
        this.initialize(iCacheListener, l, string, n, n2, string2);
    }

    protected void initialize(ICacheListener<K, V> iCacheListener, long l, String string, int n, int n2, String string2) {
        super.initialize(iCacheListener, l, string, n, n2);
        this.pool = ThreadPoolManager.getInstance().getExecutorService(string2 == null ? "cache_event_queue" : string2);
        if (this.pool instanceof ThreadPoolExecutor) {
            this.queue = ((ThreadPoolExecutor)this.pool).getQueue();
        }
    }

    @Override
    public ICacheEventQueue.QueueType getQueueType() {
        return queueType;
    }

    @Override
    public synchronized void destroy() {
        if (this.isWorking()) {
            this.setWorking(false);
            this.pool.shutdownNow();
            if (log.isInfoEnabled()) {
                log.info("Cache event queue destroyed: " + this);
            }
        }
    }

    @Override
    protected void put(AbstractCacheEventQueue.AbstractCacheEvent abstractCacheEvent) {
        this.pool.execute(abstractCacheEvent);
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Pooled Cache Event Queue");
        ArrayList arrayList = new ArrayList();
        arrayList.add(new StatElement<Boolean>("Working", this.isWorking()));
        arrayList.add(new StatElement<Boolean>("Empty", this.isEmpty()));
        if (this.queue != null) {
            arrayList.add(new StatElement<Integer>("Queue Size", this.queue.size()));
            arrayList.add(new StatElement<Integer>("Queue Capacity", this.queue.remainingCapacity()));
        }
        stats.setStatElements(arrayList);
        return stats;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.queue == null) {
            return 0;
        }
        return this.queue.size();
    }
}

