/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractCacheEventQueue<K, V>
implements ICacheEventQueue<K, V> {
    private static final Log log = LogFactory.getLog(AbstractCacheEventQueue.class);
    protected static final int DEFAULT_WAIT_TO_DIE_MILLIS = 10000;
    private int waitToDieMillis = 10000;
    private ICacheListener<K, V> listener;
    private long listenerId;
    private String cacheName;
    private int maxFailure;
    private int waitBeforeRetry;
    private final AtomicBoolean working = new AtomicBoolean(true);

    public int getWaitToDieMillis() {
        return this.waitToDieMillis;
    }

    public void setWaitToDieMillis(int n) {
        this.waitToDieMillis = n;
    }

    public String toString() {
        return "CacheEventQueue [listenerId=" + this.listenerId + ", cacheName=" + this.cacheName + "]";
    }

    @Override
    @Deprecated
    public boolean isAlive() {
        return true;
    }

    @Deprecated
    public void setAlive(boolean bl) {
    }

    @Override
    public long getListenerId() {
        return this.listenerId;
    }

    protected String getCacheName() {
        return this.cacheName;
    }

    protected void initialize(ICacheListener<K, V> iCacheListener, long l, String string, int n, int n2) {
        if (iCacheListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listener = iCacheListener;
        this.listenerId = l;
        this.cacheName = string;
        this.maxFailure = n <= 0 ? 3 : n;
        int n3 = this.waitBeforeRetry = n2 <= 0 ? 500 : n2;
        if (log.isDebugEnabled()) {
            log.debug("Constructed: " + this);
        }
    }

    @Override
    public void addPutEvent(ICacheElement<K, V> iCacheElement) {
        this.put(new PutEvent(iCacheElement));
    }

    @Override
    public void addRemoveEvent(K k) {
        this.put(new RemoveEvent(k));
    }

    @Override
    public void addRemoveAllEvent() {
        this.put(new RemoveAllEvent());
    }

    @Override
    public void addDisposeEvent() {
        this.put(new DisposeEvent());
    }

    protected abstract void put(AbstractCacheEvent var1);

    @Override
    public boolean isWorking() {
        return this.working.get();
    }

    public void setWorking(boolean bl) {
        this.working.set(bl);
    }

    protected class DisposeEvent
    extends AbstractCacheEvent {
        protected DisposeEvent() {
        }

        @Override
        protected void doRun() throws IOException {
            AbstractCacheEventQueue.this.listener.handleDispose(AbstractCacheEventQueue.this.cacheName);
        }

        public String toString() {
            return "DisposeEvent";
        }
    }

    protected class RemoveAllEvent
    extends AbstractCacheEvent {
        protected RemoveAllEvent() {
        }

        @Override
        protected void doRun() throws IOException {
            AbstractCacheEventQueue.this.listener.handleRemoveAll(AbstractCacheEventQueue.this.cacheName);
        }

        public String toString() {
            return "RemoveAllEvent";
        }
    }

    protected class RemoveEvent
    extends AbstractCacheEvent {
        private final K key;

        RemoveEvent(K k) {
            this.key = k;
        }

        @Override
        protected void doRun() throws IOException {
            AbstractCacheEventQueue.this.listener.handleRemove(AbstractCacheEventQueue.this.cacheName, this.key);
        }

        public String toString() {
            return "RemoveEvent for " + this.key;
        }
    }

    protected class PutEvent
    extends AbstractCacheEvent {
        private final ICacheElement<K, V> ice;

        PutEvent(ICacheElement<K, V> iCacheElement) {
            this.ice = iCacheElement;
        }

        @Override
        protected void doRun() throws IOException {
            AbstractCacheEventQueue.this.listener.handlePut(this.ice);
        }

        public String toString() {
            return "PutEvent for key: " + this.ice.getKey() + " value: " + this.ice.getVal();
        }
    }

    protected abstract class AbstractCacheEvent
    implements Runnable {
        int failures = 0;

        protected AbstractCacheEvent() {
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (IOException iOException) {
                if (log.isWarnEnabled()) {
                    log.warn(iOException);
                }
                if (++this.failures >= AbstractCacheEventQueue.this.maxFailure) {
                    if (log.isWarnEnabled()) {
                        log.warn("Error while running event from Queue: " + this + ". Dropping Event and marking Event Queue as non-functional.");
                    }
                    AbstractCacheEventQueue.this.destroy();
                    return;
                }
                if (log.isInfoEnabled()) {
                    log.info("Error while running event from Queue: " + this + ". Retrying...");
                }
                try {
                    Thread.sleep(AbstractCacheEventQueue.this.waitBeforeRetry);
                    this.run();
                }
                catch (InterruptedException interruptedException) {
                    if (log.isErrorEnabled()) {
                        log.warn("Interrupted while sleeping for retry on event " + this + ".");
                    }
                    AbstractCacheEventQueue.this.destroy();
                }
            }
        }

        protected abstract void doRun() throws IOException;
    }
}

