/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.app.data.Handler;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImageSVG
extends RenderableElement {
    public static final String TAG_NAME = "image";
    float x = 0.0f;
    float y = 0.0f;
    float width = 0.0f;
    float height = 0.0f;
    URL imageSrc = null;
    AffineTransform xform;
    Rectangle2D bounds;

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    protected void build() throws SVGException {
        Object object;
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("x"))) {
            this.x = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("y"))) {
            this.y = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("width"))) {
            this.width = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("height"))) {
            this.height = styleAttribute.getFloatValueWithUnits();
        }
        try {
            if (this.getPres(styleAttribute.setName("xlink:href")) && "data".equals(((URI)(object = styleAttribute.getURIValue(this.getXMLBase()))).getScheme())) {
                this.imageSrc = new URL(null, ((URI)object).toASCIIString(), new Handler());
            }
        }
        catch (Exception exception) {
            throw new SVGException(exception);
        }
        if (this.imageSrc != null) {
            this.diagram.getUniverse().registerImage(this.imageSrc);
            object = this.diagram.getUniverse().getImage(this.imageSrc);
            if (object == null) {
                this.xform = new AffineTransform();
                this.bounds = new Rectangle2D.Float();
                return;
            }
            if (this.width == 0.0f) {
                this.width = ((BufferedImage)object).getWidth();
            }
            if (this.height == 0.0f) {
                this.height = ((BufferedImage)object).getHeight();
            }
            this.xform = new AffineTransform();
            this.xform.translate(this.x, this.y);
            this.xform.scale(this.width / (float)((BufferedImage)object).getWidth(), this.height / (float)((BufferedImage)object).getHeight());
        }
        this.bounds = new Rectangle2D.Float(this.x, this.y, this.width, this.height);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    @Override
    void pick(Point2D point2D, boolean bl, List<List<SVGElement>> list) throws SVGException {
        if (this.getBoundingBox().contains(point2D)) {
            list.add(this.getPath(null));
        }
    }

    @Override
    void pick(Rectangle2D rectangle2D, AffineTransform affineTransform, boolean bl, List<List<SVGElement>> list) throws SVGException {
        if (affineTransform.createTransformedShape(this.getBoundingBox()).intersects(rectangle2D)) {
            list.add(this.getPath(null));
        }
    }

    @Override
    public void render(Graphics2D graphics2D) throws SVGException {
        Object object;
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getStyle(styleAttribute.setName("visibility")) && !styleAttribute.getStringValue().equals("visible")) {
            return;
        }
        if (this.getStyle(styleAttribute.setName("display")) && styleAttribute.getStringValue().equals("none")) {
            return;
        }
        this.beginLayer(graphics2D);
        float f = 1.0f;
        if (this.getStyle(styleAttribute.setName("opacity"))) {
            f = styleAttribute.getRatioValue();
        }
        if (f <= 0.0f) {
            return;
        }
        Composite composite = null;
        if (f < 1.0f) {
            composite = graphics2D.getComposite();
            object = AlphaComposite.getInstance(3, f);
            graphics2D.setComposite((Composite)object);
        }
        if ((object = this.diagram.getUniverse().getImage(this.imageSrc)) == null) {
            return;
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.transform(this.xform);
        graphics2D.drawImage((Image)object, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        if (composite != null) {
            graphics2D.setComposite(composite);
        }
        this.finishLayer(graphics2D);
    }

    @Override
    public Rectangle2D getBoundingBox() {
        return this.boundsToParent(this.bounds);
    }

    @Override
    public boolean updateTime(double d) throws SVGException {
        float f;
        boolean bl = super.updateTime(d);
        StyleAttribute styleAttribute = new StyleAttribute();
        boolean bl2 = false;
        if (this.getPres(styleAttribute.setName("x")) && (f = styleAttribute.getFloatValueWithUnits()) != this.x) {
            this.x = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("y")) && (f = styleAttribute.getFloatValueWithUnits()) != this.y) {
            this.y = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("width")) && (f = styleAttribute.getFloatValueWithUnits()) != this.width) {
            this.width = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("height")) && (f = styleAttribute.getFloatValueWithUnits()) != this.height) {
            this.height = f;
            bl2 = true;
        }
        try {
            if (this.getPres(styleAttribute.setName("xlink:href"))) {
                URI uRI = styleAttribute.getURIValue(this.getXMLBase());
                URL uRL = null;
                if ("data".equals(uRI.getScheme())) {
                    uRL = new URL(null, uRI.toASCIIString(), new Handler());
                }
                if (uRL != null && !uRL.equals(this.imageSrc)) {
                    this.imageSrc = uRL;
                    bl2 = true;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger("svgSalamandeLogger").log(Level.WARNING, "Image provided with illegal value for href: \"" + styleAttribute.getStringValue() + '\"', illegalArgumentException);
        }
        catch (Exception exception) {
            Logger.getLogger("svgSalamandeLogger").log(Level.WARNING, "Could not parse xlink:href", exception);
        }
        if (bl2) {
            this.build();
        }
        return bl || bl2;
    }
}

