/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;

public class StringUtil {
    @NotNull
    public static String join(@NotNull Iterable<? extends CharSequence> iterable, @NotNull String string) {
        int n = 0;
        int n2 = string.length();
        Iterator<? extends CharSequence> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            n += iterator.next().length() + n2;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        iterator = iterable.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(string);
                stringBuilder.append(iterator.next());
            }
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static <T extends CharSequence> String join(@NotNull T[] TArray, @NotNull String string) {
        int n = 0;
        int n2 = string.length();
        for (T t : TArray) {
            n += t.length() + n2;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        int n3 = 1;
        for (T t : TArray) {
            if (n3 == 0) {
                stringBuilder.append(string);
            } else {
                n3 = 0;
            }
            stringBuilder.append((CharSequence)t);
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static String fromStream(@NotNull InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static int compare(@Nullable String string, @Nullable String string2) {
        boolean bl;
        boolean bl2 = string == null;
        boolean bl3 = bl = string2 == null;
        if (bl2 && bl) {
            return 0;
        }
        if (bl2) {
            return -1;
        }
        if (bl) {
            return 1;
        }
        return string.compareTo(string2);
    }

    @NotNull
    public static String urlEncode(@NotNull String string) {
        return string.replace(" ", "%20");
    }
}

