/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "yav" locale.
 */
public class LocalizedNamesImpl_yav extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "ZA",
        "AF",
        "SA",
        "AM",
        "AL",
        "AR",
        "DZ",
        "AW",
        "US",
        "AN",
        "AQ",
        "AZ",
        "AX",
        "HT",
        "AI",
        "AO",
        "AG",
        "AD",
        "BL",
        "BQ",
        "BV",
        "CC",
        "CP",
        "CW",
        "CX",
        "DG",
        "EA",
        "EH",
        "EC",
        "RE",
        "ER",
        "ET",
        "EU",
        "VU",
        "VA",
        "FR",
        "VE",
        "PH",
        "VG",
        "FJ",
        "VN",
        "FO",
        "FI",
        "GG",
        "GS",
        "HK",
        "HM",
        "IC",
        "IQ",
        "IR",
        "IE",
        "MH",
        "MP",
        "NF",
        "SB",
        "IM",
        "AE",
        "GB",
        "IL",
        "EG",
        "IS",
        "IT",
        "JE",
        "GM",
        "KH",
        "GH",
        "CA",
        "CV",
        "GA",
        "KZ",
        "QA",
        "KY",
        "GD",
        "CM",
        "KE",
        "GN",
        "GW",
        "KG",
        "KI",
        "GR",
        "GQ",
        "CZ",
        "CD",
        "PS",
        "DO",
        "HR",
        "CG",
        "CR",
        "CI",
        "KW",
        "GU",
        "GP",
        "GT",
        "GL",
        "CU",
        "CK",
        "GY",
        "GF",
        "KP",
        "KR",
        "CO",
        "KM",
        "IO",
        "LA",
        "LS",
        "LV",
        "LU",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "MW",
        "MY",
        "MV",
        "ML",
        "MA",
        "MQ",
        "FK",
        "MT",
        "MK",
        "MG",
        "YT",
        "ME",
        "MF",
        "MM",
        "FM",
        "MO",
        "MU",
        "MR",
        "MD",
        "MC",
        "MN",
        "MZ",
        "MS",
        "MX",
        "NA",
        "NR",
        "NP",
        "NI",
        "NG",
        "NE",
        "NL",
        "NU",
        "DE",
        "NC",
        "NZ",
        "NO",
        "OM",
        "AU",
        "AT",
        "BS",
        "PK",
        "PY",
        "PW",
        "BB",
        "BH",
        "PA",
        "ES",
        "PG",
        "BD",
        "BY",
        "BZ",
        "PE",
        "BJ",
        "BR",
        "VI",
        "PN",
        "BO",
        "PF",
        "PR",
        "BW",
        "BF",
        "BG",
        "BI",
        "BN",
        "BA",
        "BT",
        "PT",
        "PL",
        "BM",
        "BE",
        "QO",
        "RS",
        "ZM",
        "TD",
        "SV",
        "JM",
        "WS",
        "AS",
        "SM",
        "CF",
        "JP",
        "ST",
        "SN",
        "SC",
        "SL",
        "CN",
        "CL",
        "LK",
        "SK",
        "SI",
        "GI",
        "ZW",
        "SG",
        "CY",
        "DJ",
        "SJ",
        "SO",
        "SS",
        "SZ",
        "SR",
        "SD",
        "CH",
        "SE",
        "SX",
        "SY",
        "GE",
        "JO",
        "VC",
        "KN",
        "PM",
        "SH",
        "LC",
        "TA",
        "DK",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TF",
        "TT",
        "TL",
        "TK",
        "TG",
        "TV",
        "TR",
        "TM",
        "TC",
        "DM",
        "TN",
        "TO",
        "UG",
        "UA",
        "RW",
        "UY",
        "RO",
        "RU",
        "UM",
        "UZ",
        "WF",
        "XK",
        "YE",
        "HN",
        "HU",
        "ID",
        "EE",
        "IN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Aŋtúla");
    namesMap.put("AE", "imiláat i paaláap");
    namesMap.put("AF", "Afkanistáŋ");
    namesMap.put("AG", "Aŋtíka na Palpúta");
    namesMap.put("AI", "Aŋkíla");
    namesMap.put("AL", "Alpaní");
    namesMap.put("AM", "Almanía");
    namesMap.put("AN", "andíiy u nitililáand");
    namesMap.put("AO", "Aŋkúla");
    namesMap.put("AR", "Alsaŋtín");
    namesMap.put("AS", "Sámua u Amelíka");
    namesMap.put("AT", "Otilís");
    namesMap.put("AU", "Otalalí");
    namesMap.put("AW", "Alúpa");
    namesMap.put("AZ", "Asɛlpaisáŋ");
    namesMap.put("BA", "Pusiní-ɛlkofína");
    namesMap.put("BB", "Palpatós");
    namesMap.put("BD", "Paŋkalatɛs");
    namesMap.put("BE", "Pɛlsíik");
    namesMap.put("BF", "Pulikínafásó");
    namesMap.put("BG", "Pulukalíi");
    namesMap.put("BH", "Palɛŋ");
    namesMap.put("BI", "Púlúndí");
    namesMap.put("BJ", "Penɛŋ");
    namesMap.put("BM", "Pɛlmúta");
    namesMap.put("BN", "Pulunéy");
    namesMap.put("BO", "Polífia");
    namesMap.put("BR", "Pilesíl");
    namesMap.put("BS", "Pahámas");
    namesMap.put("BT", "Putaŋ");
    namesMap.put("BW", "Posuána");
    namesMap.put("BY", "Pelalús");
    namesMap.put("BZ", "Pelíse");
    namesMap.put("CA", "Kánáta");
    namesMap.put("CD", "kitɔŋ kí kongó");
    namesMap.put("CF", "Santalafilíik");
    namesMap.put("CG", "Kongó");
    namesMap.put("CH", "suwíis");
    namesMap.put("CI", "Kótifualɛ");
    namesMap.put("CK", "Kúuke");
    namesMap.put("CL", "Silí");
    namesMap.put("CM", "Kemelún");
    namesMap.put("CN", "Síine");
    namesMap.put("CO", "Kɔlɔ́mbía");
    namesMap.put("CR", "Kóstálíka");
    namesMap.put("CU", "kúpa");
    namesMap.put("CV", "Kápfɛl");
    namesMap.put("CY", "síplɛ");
    namesMap.put("CZ", "kitɔŋ kí cɛ́k");
    namesMap.put("DE", "nsáman");
    namesMap.put("DJ", "síputí");
    namesMap.put("DK", "tanemálk");
    namesMap.put("DM", "túmúnéke");
    namesMap.put("DO", "kitɔŋ kí tumunikɛ́ŋ");
    namesMap.put("DZ", "Alselí");
    namesMap.put("EC", "ekuatɛ́l");
    namesMap.put("EE", "ɛstoni");
    namesMap.put("EG", "isípit");
    namesMap.put("ER", "elitée");
    namesMap.put("ES", "panyá");
    namesMap.put("ET", "etiopí");
    namesMap.put("FI", "fɛnlánd");
    namesMap.put("FJ", "físi");
    namesMap.put("FK", "maluwín");
    namesMap.put("FM", "mikolonesí");
    namesMap.put("FR", "felensí");
    namesMap.put("GA", "kapɔ́ŋ");
    namesMap.put("GB", "ingilíís");
    namesMap.put("GD", "kelenáat");
    namesMap.put("GE", "sɔlsíi");
    namesMap.put("GF", "kuyáan u felensí");
    namesMap.put("GH", "kaná");
    namesMap.put("GI", "sílpalatáal");
    namesMap.put("GL", "kuluɛnlánd");
    namesMap.put("GM", "kambíi");
    namesMap.put("GN", "kiiné");
    namesMap.put("GP", "kuatelúup");
    namesMap.put("GQ", "kinéekuatolial");
    namesMap.put("GR", "kilɛ́ɛk");
    namesMap.put("GT", "kuatemalá");
    namesMap.put("GU", "kuamiɛ");
    namesMap.put("GW", "kiinépisaó");
    namesMap.put("GY", "kuyáan");
    namesMap.put("HN", "ɔndúlas");
    namesMap.put("HR", "Kolowasíi");
    namesMap.put("HT", "ayíti");
    namesMap.put("HU", "ɔngilí");
    namesMap.put("ID", "ɛndonesí");
    namesMap.put("IE", "ililánd");
    namesMap.put("IL", "ísilayɛ́l");
    namesMap.put("IN", "ɛ́ɛnd");
    namesMap.put("IO", "Kɔɔ́m kí ndián yi ngilís");
    namesMap.put("IQ", "ilák");
    namesMap.put("IR", "iláŋ");
    namesMap.put("IS", "isláand");
    namesMap.put("IT", "italí");
    namesMap.put("JM", "samayíik");
    namesMap.put("JO", "sɔltaní");
    namesMap.put("JP", "sapɔ́ɔŋ");
    namesMap.put("KE", "kénia");
    namesMap.put("KG", "kilikisistáŋ");
    namesMap.put("KH", "Kámbóse");
    namesMap.put("KI", "kilipatí");
    namesMap.put("KM", "Kɔmɔ́ɔl");
    namesMap.put("KN", "sɛ́ŋkilistɔ́f eniɛ́f");
    namesMap.put("KP", "kɔlé u muɛnɛ́");
    namesMap.put("KR", "kɔlé wu mbát");
    namesMap.put("KW", "kowéet");
    namesMap.put("KY", "Káyímanɛ");
    namesMap.put("KZ", "kasaksitáŋ");
    namesMap.put("LA", "lawós");
    namesMap.put("LB", "lipáŋ");
    namesMap.put("LC", "sɛ́ŋtɛ́lusí");
    namesMap.put("LI", "lístɛ́nsitáyin");
    namesMap.put("LK", "silíláŋka");
    namesMap.put("LR", "lipélia");
    namesMap.put("LS", "lesotó");
    namesMap.put("LT", "litiyaní");
    namesMap.put("LU", "liksambúul");
    namesMap.put("LV", "letoní");
    namesMap.put("LY", "lipíi");
    namesMap.put("MA", "malóok");
    namesMap.put("MC", "monakó");
    namesMap.put("MD", "moltafí");
    namesMap.put("MG", "matakaskáal");
    namesMap.put("MH", "ílmalasáal");
    namesMap.put("MK", "masetuán");
    namesMap.put("ML", "malí");
    namesMap.put("MM", "miaŋmáal");
    namesMap.put("MN", "mongolí");
    namesMap.put("MP", "il maliyanɛ u muɛnɛ́");
    namesMap.put("MQ", "maltiníik");
    namesMap.put("MR", "molitaní");
    namesMap.put("MS", "mɔŋsilá");
    namesMap.put("MT", "málɛ́t");
    namesMap.put("MU", "molís");
    namesMap.put("MV", "maletíif");
    namesMap.put("MW", "malawí");
    namesMap.put("MX", "mɛksíik");
    namesMap.put("MY", "malesí");
    namesMap.put("MZ", "mosambík");
    namesMap.put("NA", "namipí");
    namesMap.put("NC", "nufɛ́l kaletoní");
    namesMap.put("NE", "nisɛ́ɛl");
    namesMap.put("NF", "il nɔ́lfɔ́lɔk");
    namesMap.put("NG", "nisélia");
    namesMap.put("NI", "nikalaká");
    namesMap.put("NL", "nitililáand");
    namesMap.put("NO", "nɔlfɛ́ɛs");
    namesMap.put("NP", "nepáal");
    namesMap.put("NR", "nawulú");
    namesMap.put("NU", "niyuwé");
    namesMap.put("NZ", "nufɛ́l seláand");
    namesMap.put("OM", "omáŋ");
    namesMap.put("PA", "panamá");
    namesMap.put("PE", "pelú");
    namesMap.put("PF", "polinesí u felensí");
    namesMap.put("PG", "papuasí nufɛ́l kiiné");
    namesMap.put("PH", "filipíin");
    namesMap.put("PK", "pakistáŋ");
    namesMap.put("PL", "pɔlɔ́ɔny");
    namesMap.put("PM", "sɛ́ŋpiɛ́l e mikelɔ́ŋ");
    namesMap.put("PN", "pitikɛ́ɛlínɛ́");
    namesMap.put("PR", "pólótolíko");
    namesMap.put("PS", "kitɔŋ ki palɛstíin");
    namesMap.put("PT", "pɔltukáal");
    namesMap.put("PW", "palawú");
    namesMap.put("PY", "palakúé");
    namesMap.put("QA", "katáal");
    namesMap.put("RE", "elewuniɔ́ŋ");
    namesMap.put("RO", "ulumaní");
    namesMap.put("RU", "ulusí");
    namesMap.put("RW", "uluándá");
    namesMap.put("SA", "alapísawutíit");
    namesMap.put("SB", "il salomɔ́ŋ");
    namesMap.put("SC", "sesɛ́ɛl");
    namesMap.put("SD", "sutáaŋ");
    namesMap.put("SE", "suɛ́t");
    namesMap.put("SG", "singapúul");
    namesMap.put("SH", "sɛ́ŋtɛ́ elɛ́ɛnɛ");
    namesMap.put("SI", "silofení");
    namesMap.put("SK", "silofakí");
    namesMap.put("SL", "sieláleyɔ́ɔn");
    namesMap.put("SM", "san malíno");
    namesMap.put("SN", "senekáal");
    namesMap.put("SO", "somalí");
    namesMap.put("SR", "sulináam");
    namesMap.put("ST", "sáwó tomé e pelensípe");
    namesMap.put("SV", "salfatɔ́ɔl");
    namesMap.put("SZ", "suasiláand");
    namesMap.put("TC", "túluk na káyiik");
    namesMap.put("TD", "Sáat");
    namesMap.put("TG", "tokó");
    namesMap.put("TH", "tayiláand");
    namesMap.put("TJ", "tasikistáaŋ");
    namesMap.put("TK", "tokeló");
    namesMap.put("TL", "timɔ́ɔl u nipálɛ́n");
    namesMap.put("TM", "tulukmenisitáaŋ");
    namesMap.put("TN", "tunusí");
    namesMap.put("TO", "tɔ́ŋka");
    namesMap.put("TR", "tulukíi");
    namesMap.put("TT", "tilinitáat na tupákɔ");
    namesMap.put("TV", "tufalú");
    namesMap.put("TW", "tayiwáan");
    namesMap.put("TZ", "taŋsaní");
    namesMap.put("UA", "ukilɛ́ɛn");
    namesMap.put("UG", "ukánda");
    namesMap.put("US", "amálíka");
    namesMap.put("UY", "ulukuéy");
    namesMap.put("UZ", "usupekistáaŋ");
    namesMap.put("VA", "fatikáaŋ");
    namesMap.put("VC", "sɛ́ŋ fɛŋsáŋ elekelenatíin");
    namesMap.put("VE", "fenesuwelá");
    namesMap.put("VG", "Filisíin ungilís");
    namesMap.put("VI", "pindisúlɛ́ pi amálíka");
    namesMap.put("VN", "fiɛtnáam");
    namesMap.put("VU", "fanuatú");
    namesMap.put("WF", "walíis na futúna");
    namesMap.put("WS", "samowá");
    namesMap.put("YE", "yémɛn");
    namesMap.put("YT", "mayɔ́ɔt");
    namesMap.put("ZA", "afilí mbátɛ́");
    namesMap.put("ZM", "saambíi");
    namesMap.put("ZW", "simbapuwé");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Aŋtúla",
        "AE": "imiláat i paaláap",
        "AF": "Afkanistáŋ",
        "AG": "Aŋtíka na Palpúta",
        "AI": "Aŋkíla",
        "AL": "Alpaní",
        "AM": "Almanía",
        "AN": "andíiy u nitililáand",
        "AO": "Aŋkúla",
        "AR": "Alsaŋtín",
        "AS": "Sámua u Amelíka",
        "AT": "Otilís",
        "AU": "Otalalí",
        "AW": "Alúpa",
        "AZ": "Asɛlpaisáŋ",
        "BA": "Pusiní-ɛlkofína",
        "BB": "Palpatós",
        "BD": "Paŋkalatɛs",
        "BE": "Pɛlsíik",
        "BF": "Pulikínafásó",
        "BG": "Pulukalíi",
        "BH": "Palɛŋ",
        "BI": "Púlúndí",
        "BJ": "Penɛŋ",
        "BM": "Pɛlmúta",
        "BN": "Pulunéy",
        "BO": "Polífia",
        "BR": "Pilesíl",
        "BS": "Pahámas",
        "BT": "Putaŋ",
        "BW": "Posuána",
        "BY": "Pelalús",
        "BZ": "Pelíse",
        "CA": "Kánáta",
        "CD": "kitɔŋ kí kongó",
        "CF": "Santalafilíik",
        "CG": "Kongó",
        "CH": "suwíis",
        "CI": "Kótifualɛ",
        "CK": "Kúuke",
        "CL": "Silí",
        "CM": "Kemelún",
        "CN": "Síine",
        "CO": "Kɔlɔ́mbía",
        "CR": "Kóstálíka",
        "CU": "kúpa",
        "CV": "Kápfɛl",
        "CY": "síplɛ",
        "CZ": "kitɔŋ kí cɛ́k",
        "DE": "nsáman",
        "DJ": "síputí",
        "DK": "tanemálk",
        "DM": "túmúnéke",
        "DO": "kitɔŋ kí tumunikɛ́ŋ",
        "DZ": "Alselí",
        "EC": "ekuatɛ́l",
        "EE": "ɛstoni",
        "EG": "isípit",
        "ER": "elitée",
        "ES": "panyá",
        "ET": "etiopí",
        "FI": "fɛnlánd",
        "FJ": "físi",
        "FK": "maluwín",
        "FM": "mikolonesí",
        "FR": "felensí",
        "GA": "kapɔ́ŋ",
        "GB": "ingilíís",
        "GD": "kelenáat",
        "GE": "sɔlsíi",
        "GF": "kuyáan u felensí",
        "GH": "kaná",
        "GI": "sílpalatáal",
        "GL": "kuluɛnlánd",
        "GM": "kambíi",
        "GN": "kiiné",
        "GP": "kuatelúup",
        "GQ": "kinéekuatolial",
        "GR": "kilɛ́ɛk",
        "GT": "kuatemalá",
        "GU": "kuamiɛ",
        "GW": "kiinépisaó",
        "GY": "kuyáan",
        "HN": "ɔndúlas",
        "HR": "Kolowasíi",
        "HT": "ayíti",
        "HU": "ɔngilí",
        "ID": "ɛndonesí",
        "IE": "ililánd",
        "IL": "ísilayɛ́l",
        "IN": "ɛ́ɛnd",
        "IO": "Kɔɔ́m kí ndián yi ngilís",
        "IQ": "ilák",
        "IR": "iláŋ",
        "IS": "isláand",
        "IT": "italí",
        "JM": "samayíik",
        "JO": "sɔltaní",
        "JP": "sapɔ́ɔŋ",
        "KE": "kénia",
        "KG": "kilikisistáŋ",
        "KH": "Kámbóse",
        "KI": "kilipatí",
        "KM": "Kɔmɔ́ɔl",
        "KN": "sɛ́ŋkilistɔ́f eniɛ́f",
        "KP": "kɔlé u muɛnɛ́",
        "KR": "kɔlé wu mbát",
        "KW": "kowéet",
        "KY": "Káyímanɛ",
        "KZ": "kasaksitáŋ",
        "LA": "lawós",
        "LB": "lipáŋ",
        "LC": "sɛ́ŋtɛ́lusí",
        "LI": "lístɛ́nsitáyin",
        "LK": "silíláŋka",
        "LR": "lipélia",
        "LS": "lesotó",
        "LT": "litiyaní",
        "LU": "liksambúul",
        "LV": "letoní",
        "LY": "lipíi",
        "MA": "malóok",
        "MC": "monakó",
        "MD": "moltafí",
        "MG": "matakaskáal",
        "MH": "ílmalasáal",
        "MK": "masetuán",
        "ML": "malí",
        "MM": "miaŋmáal",
        "MN": "mongolí",
        "MP": "il maliyanɛ u muɛnɛ́",
        "MQ": "maltiníik",
        "MR": "molitaní",
        "MS": "mɔŋsilá",
        "MT": "málɛ́t",
        "MU": "molís",
        "MV": "maletíif",
        "MW": "malawí",
        "MX": "mɛksíik",
        "MY": "malesí",
        "MZ": "mosambík",
        "NA": "namipí",
        "NC": "nufɛ́l kaletoní",
        "NE": "nisɛ́ɛl",
        "NF": "il nɔ́lfɔ́lɔk",
        "NG": "nisélia",
        "NI": "nikalaká",
        "NL": "nitililáand",
        "NO": "nɔlfɛ́ɛs",
        "NP": "nepáal",
        "NR": "nawulú",
        "NU": "niyuwé",
        "NZ": "nufɛ́l seláand",
        "OM": "omáŋ",
        "PA": "panamá",
        "PE": "pelú",
        "PF": "polinesí u felensí",
        "PG": "papuasí nufɛ́l kiiné",
        "PH": "filipíin",
        "PK": "pakistáŋ",
        "PL": "pɔlɔ́ɔny",
        "PM": "sɛ́ŋpiɛ́l e mikelɔ́ŋ",
        "PN": "pitikɛ́ɛlínɛ́",
        "PR": "pólótolíko",
        "PS": "kitɔŋ ki palɛstíin",
        "PT": "pɔltukáal",
        "PW": "palawú",
        "PY": "palakúé",
        "QA": "katáal",
        "RE": "elewuniɔ́ŋ",
        "RO": "ulumaní",
        "RU": "ulusí",
        "RW": "uluándá",
        "SA": "alapísawutíit",
        "SB": "il salomɔ́ŋ",
        "SC": "sesɛ́ɛl",
        "SD": "sutáaŋ",
        "SE": "suɛ́t",
        "SG": "singapúul",
        "SH": "sɛ́ŋtɛ́ elɛ́ɛnɛ",
        "SI": "silofení",
        "SK": "silofakí",
        "SL": "sieláleyɔ́ɔn",
        "SM": "san malíno",
        "SN": "senekáal",
        "SO": "somalí",
        "SR": "sulináam",
        "ST": "sáwó tomé e pelensípe",
        "SV": "salfatɔ́ɔl",
        "SZ": "suasiláand",
        "TC": "túluk na káyiik",
        "TD": "Sáat",
        "TG": "tokó",
        "TH": "tayiláand",
        "TJ": "tasikistáaŋ",
        "TK": "tokeló",
        "TL": "timɔ́ɔl u nipálɛ́n",
        "TM": "tulukmenisitáaŋ",
        "TN": "tunusí",
        "TO": "tɔ́ŋka",
        "TR": "tulukíi",
        "TT": "tilinitáat na tupákɔ",
        "TV": "tufalú",
        "TW": "tayiwáan",
        "TZ": "taŋsaní",
        "UA": "ukilɛ́ɛn",
        "UG": "ukánda",
        "US": "amálíka",
        "UY": "ulukuéy",
        "UZ": "usupekistáaŋ",
        "VA": "fatikáaŋ",
        "VC": "sɛ́ŋ fɛŋsáŋ elekelenatíin",
        "VE": "fenesuwelá",
        "VG": "Filisíin ungilís",
        "VI": "pindisúlɛ́ pi amálíka",
        "VN": "fiɛtnáam",
        "VU": "fanuatú",
        "WF": "walíis na futúna",
        "WS": "samowá",
        "YE": "yémɛn",
        "YT": "mayɔ́ɔt",
        "ZA": "afilí mbátɛ́",
        "ZM": "saambíi",
        "ZW": "simbapuwé"
    };
  }-*/;
}
