/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.ArrayDeque;
import java.util.Set;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedType;
import kotlin.reflect.jvm.internal.impl.types.checker.NewTypeVariableConstructor;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeCheckerContext {
    private int argumentsDepth;
    private boolean supertypesLocked;
    private ArrayDeque<SimpleType> supertypesDeque;
    private Set<SimpleType> supertypesSet;
    private final boolean errorTypeEqualsToAnything;
    private final boolean allowedTypeVariable;

    @Nullable
    public Boolean addSubtypeConstraint(@NotNull UnwrappedType subType, @NotNull UnwrappedType superType) {
        Intrinsics.checkParameterIsNotNull((Object)subType, (String)"subType");
        Intrinsics.checkParameterIsNotNull((Object)superType, (String)"superType");
        return null;
    }

    public boolean areEqualTypeConstructors(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        return Intrinsics.areEqual((Object)a, (Object)b);
    }

    @NotNull
    public LowerCapturedTypePolicy getLowerCapturedTypePolicy(@NotNull SimpleType subType, @NotNull NewCapturedType superType) {
        Intrinsics.checkParameterIsNotNull((Object)subType, (String)"subType");
        Intrinsics.checkParameterIsNotNull((Object)superType, (String)"superType");
        return LowerCapturedTypePolicy.CHECK_SUBTYPE_AND_LOWER;
    }

    @NotNull
    public SeveralSupertypesWithSameConstructorPolicy getSameConstructorPolicy() {
        return SeveralSupertypesWithSameConstructorPolicy.INTERSECT_ARGUMENTS_AND_CHECK_AGAIN;
    }

    private final void initialize() {
        boolean bl = !this.supertypesLocked;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.supertypesLocked = true;
        if (this.supertypesDeque == null) {
            this.supertypesDeque = new ArrayDeque(4);
        }
        if (this.supertypesSet == null) {
            this.supertypesSet = SmartSet.Companion.create();
        }
    }

    private final void clear() {
        ArrayDeque<SimpleType> arrayDeque = this.supertypesDeque;
        if (arrayDeque == null) {
            Intrinsics.throwNpe();
        }
        arrayDeque.clear();
        Set<SimpleType> set = this.supertypesSet;
        if (set == null) {
            Intrinsics.throwNpe();
        }
        set.clear();
        this.supertypesLocked = false;
    }

    public final boolean isAllowedTypeVariable(@NotNull UnwrappedType $this$isAllowedTypeVariable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isAllowedTypeVariable, (String)"$this$isAllowedTypeVariable");
        return this.allowedTypeVariable && $this$isAllowedTypeVariable.getConstructor() instanceof NewTypeVariableConstructor;
    }

    public final boolean getErrorTypeEqualsToAnything() {
        return this.errorTypeEqualsToAnything;
    }

    public TypeCheckerContext(boolean errorTypeEqualsToAnything, boolean allowedTypeVariable) {
        this.errorTypeEqualsToAnything = errorTypeEqualsToAnything;
        this.allowedTypeVariable = allowedTypeVariable;
    }

    public /* synthetic */ TypeCheckerContext(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl2 = true;
        }
        this(bl, bl2);
    }

    public static final /* synthetic */ int access$getArgumentsDepth$p(TypeCheckerContext $this) {
        return $this.argumentsDepth;
    }

    public static final /* synthetic */ void access$setArgumentsDepth$p(TypeCheckerContext $this, int n) {
        $this.argumentsDepth = n;
    }

    public static final /* synthetic */ void access$initialize(TypeCheckerContext $this) {
        $this.initialize();
    }

    public static final /* synthetic */ ArrayDeque access$getSupertypesDeque$p(TypeCheckerContext $this) {
        return $this.supertypesDeque;
    }

    public static final /* synthetic */ Set access$getSupertypesSet$p(TypeCheckerContext $this) {
        return $this.supertypesSet;
    }

    public static final /* synthetic */ void access$clear(TypeCheckerContext $this) {
        $this.clear();
    }

    public static abstract class SupertypesPolicy {
        @NotNull
        public abstract SimpleType transformType(@NotNull KotlinType var1);

        private SupertypesPolicy() {
        }

        public /* synthetic */ SupertypesPolicy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class None
        extends SupertypesPolicy {
            public static final None INSTANCE;

            @NotNull
            public Void transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                throw (Throwable)new UnsupportedOperationException("Should not be called");
            }

            private None() {
                super(null);
            }

            static {
                None none;
                INSTANCE = none = new None();
            }
        }

        public static final class UpperIfFlexible
        extends SupertypesPolicy {
            public static final UpperIfFlexible INSTANCE;

            @Override
            @NotNull
            public SimpleType transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                return FlexibleTypesKt.upperIfFlexible(type2);
            }

            private UpperIfFlexible() {
                super(null);
            }

            static {
                UpperIfFlexible upperIfFlexible;
                INSTANCE = upperIfFlexible = new UpperIfFlexible();
            }
        }

        public static final class LowerIfFlexible
        extends SupertypesPolicy {
            public static final LowerIfFlexible INSTANCE;

            @Override
            @NotNull
            public SimpleType transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                return FlexibleTypesKt.lowerIfFlexible(type2);
            }

            private LowerIfFlexible() {
                super(null);
            }

            static {
                LowerIfFlexible lowerIfFlexible;
                INSTANCE = lowerIfFlexible = new LowerIfFlexible();
            }
        }

        public static final class LowerIfFlexibleWithCustomSubstitutor
        extends SupertypesPolicy {
            @NotNull
            private final TypeSubstitutor substitutor;

            @Override
            @NotNull
            public SimpleType transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                KotlinType kotlinType = this.substitutor.safeSubstitute(FlexibleTypesKt.lowerIfFlexible(type2), Variance.INVARIANT);
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"substitutor.safeSubstitu\u2026le(), Variance.INVARIANT)");
                return TypeSubstitutionKt.asSimpleType(kotlinType);
            }

            public LowerIfFlexibleWithCustomSubstitutor(@NotNull TypeSubstitutor substitutor) {
                Intrinsics.checkParameterIsNotNull((Object)substitutor, (String)"substitutor");
                super(null);
                this.substitutor = substitutor;
            }
        }
    }

    public static final class SeveralSupertypesWithSameConstructorPolicy
    extends Enum<SeveralSupertypesWithSameConstructorPolicy> {
        public static final /* enum */ SeveralSupertypesWithSameConstructorPolicy TAKE_FIRST_FOR_SUBTYPING;
        public static final /* enum */ SeveralSupertypesWithSameConstructorPolicy FORCE_NOT_SUBTYPE;
        public static final /* enum */ SeveralSupertypesWithSameConstructorPolicy CHECK_ANY_OF_THEM;
        public static final /* enum */ SeveralSupertypesWithSameConstructorPolicy INTERSECT_ARGUMENTS_AND_CHECK_AGAIN;
        private static final /* synthetic */ SeveralSupertypesWithSameConstructorPolicy[] $VALUES;

        static {
            SeveralSupertypesWithSameConstructorPolicy[] severalSupertypesWithSameConstructorPolicyArray = new SeveralSupertypesWithSameConstructorPolicy[4];
            SeveralSupertypesWithSameConstructorPolicy[] severalSupertypesWithSameConstructorPolicyArray2 = severalSupertypesWithSameConstructorPolicyArray;
            severalSupertypesWithSameConstructorPolicyArray[0] = TAKE_FIRST_FOR_SUBTYPING = new SeveralSupertypesWithSameConstructorPolicy();
            severalSupertypesWithSameConstructorPolicyArray[1] = FORCE_NOT_SUBTYPE = new SeveralSupertypesWithSameConstructorPolicy();
            severalSupertypesWithSameConstructorPolicyArray[2] = CHECK_ANY_OF_THEM = new SeveralSupertypesWithSameConstructorPolicy();
            severalSupertypesWithSameConstructorPolicyArray[3] = INTERSECT_ARGUMENTS_AND_CHECK_AGAIN = new SeveralSupertypesWithSameConstructorPolicy();
            $VALUES = severalSupertypesWithSameConstructorPolicyArray;
        }

        public static SeveralSupertypesWithSameConstructorPolicy[] values() {
            return (SeveralSupertypesWithSameConstructorPolicy[])$VALUES.clone();
        }

        public static SeveralSupertypesWithSameConstructorPolicy valueOf(String string) {
            return Enum.valueOf(SeveralSupertypesWithSameConstructorPolicy.class, string);
        }
    }

    public static final class LowerCapturedTypePolicy
    extends Enum<LowerCapturedTypePolicy> {
        public static final /* enum */ LowerCapturedTypePolicy CHECK_ONLY_LOWER;
        public static final /* enum */ LowerCapturedTypePolicy CHECK_SUBTYPE_AND_LOWER;
        public static final /* enum */ LowerCapturedTypePolicy SKIP_LOWER;
        private static final /* synthetic */ LowerCapturedTypePolicy[] $VALUES;

        static {
            LowerCapturedTypePolicy[] lowerCapturedTypePolicyArray = new LowerCapturedTypePolicy[3];
            LowerCapturedTypePolicy[] lowerCapturedTypePolicyArray2 = lowerCapturedTypePolicyArray;
            lowerCapturedTypePolicyArray[0] = CHECK_ONLY_LOWER = new LowerCapturedTypePolicy();
            lowerCapturedTypePolicyArray[1] = CHECK_SUBTYPE_AND_LOWER = new LowerCapturedTypePolicy();
            lowerCapturedTypePolicyArray[2] = SKIP_LOWER = new LowerCapturedTypePolicy();
            $VALUES = lowerCapturedTypePolicyArray;
        }

        public static LowerCapturedTypePolicy[] values() {
            return (LowerCapturedTypePolicy[])$VALUES.clone();
        }

        public static LowerCapturedTypePolicy valueOf(String string) {
            return Enum.valueOf(LowerCapturedTypePolicy.class, string);
        }
    }
}

