/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a\n\u0010\u0005\u001a\u00020\u0003*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0003*\u00020\u0006\u001a\n\u0010\b\u001a\u00020\u0003*\u00020\u0006\u001a\f\u0010\t\u001a\u00020\u0003*\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"INLINE_ONLY_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "hasInlineOnlyAnnotation", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isEffectivelyInlineOnly", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "isInlineOnly", "isInlineOnlyOrReifiable", "isReifiable", "frontend"})
public final class InlineOnlyKt {
    private static final FqName INLINE_ONLY_ANNOTATION_FQ_NAME = new FqName("kotlin.internal.InlineOnly");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineOnlyOrReifiable(@NotNull MemberDescriptor $this$isInlineOnlyOrReifiable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isInlineOnlyOrReifiable, (String)"$this$isInlineOnlyOrReifiable");
        if (!($this$isInlineOnlyOrReifiable instanceof CallableMemberDescriptor)) return false;
        if (InlineOnlyKt.isReifiable((CallableMemberDescriptor)$this$isInlineOnlyOrReifiable)) return true;
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember((CallableMemberDescriptor)$this$isInlineOnlyOrReifiable);
        Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"DescriptorUtils.getDirectMember(this)");
        if (InlineOnlyKt.isReifiable(callableMemberDescriptor)) return true;
        if (!InlineOnlyKt.isInlineOnly($this$isInlineOnlyOrReifiable)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEffectivelyInlineOnly(@NotNull MemberDescriptor $this$isEffectivelyInlineOnly) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$isEffectivelyInlineOnly, (String)"$this$isEffectivelyInlineOnly");
        if (InlineOnlyKt.isInlineOnlyOrReifiable($this$isEffectivelyInlineOnly)) return true;
        if (!($this$isEffectivelyInlineOnly instanceof FunctionDescriptor)) return false;
        if (!((FunctionDescriptor)$this$isEffectivelyInlineOnly).isSuspend()) return false;
        if (!((FunctionDescriptor)$this$isEffectivelyInlineOnly).isInline()) return false;
        List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)$this$isEffectivelyInlineOnly).getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueParameters");
        Iterable $this$any$iv = list2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                boolean bl2 = false;
                if (!it.isCrossinline()) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        if (!Intrinsics.areEqual((Object)((FunctionDescriptor)$this$isEffectivelyInlineOnly).getVisibility(), (Object)Visibilities.PRIVATE)) return false;
        return true;
    }

    public static final boolean isInlineOnly(@NotNull MemberDescriptor $this$isInlineOnly) {
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)$this$isInlineOnly, (String)"$this$isInlineOnly");
                if (!($this$isInlineOnly instanceof FunctionDescriptor)) break block4;
                if (InlineOnlyKt.hasInlineOnlyAnnotation((CallableMemberDescriptor)$this$isInlineOnly)) break block5;
                CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember((CallableMemberDescriptor)$this$isInlineOnly);
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"DescriptorUtils.getDirectMember(this)");
                if (InlineOnlyKt.hasInlineOnlyAnnotation(callableMemberDescriptor)) break block5;
            }
            return false;
        }
        boolean bl = ((FunctionDescriptor)$this$isInlineOnly).isInline();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Function is not inline: " + $this$isInlineOnly;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return true;
    }

    private static final boolean isReifiable(@NotNull CallableMemberDescriptor $this$isReifiable) {
        boolean bl;
        block3: {
            List<TypeParameterDescriptor> list2 = $this$isReifiable.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"typeParameters");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    TypeParameterDescriptor typeParameterDescriptor = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"it");
                    if (!typeParameterDescriptor.isReified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean hasInlineOnlyAnnotation(@NotNull CallableMemberDescriptor $this$hasInlineOnlyAnnotation) {
        return $this$hasInlineOnlyAnnotation.getAnnotations().hasAnnotation(INLINE_ONLY_ANNOTATION_FQ_NAME);
    }
}

