/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaLightTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;

public class FileLocalResolver {
    private final LighterAST myTree;

    public FileLocalResolver(@NotNull LighterAST tree) {
        if (tree == null) {
            FileLocalResolver.$$$reportNull$$$0(0);
        }
        this.myTree = tree;
    }

    @NotNull
    public LighterAST getLightTree() {
        LighterAST lighterAST = this.myTree;
        if (lighterAST == null) {
            FileLocalResolver.$$$reportNull$$$0(1);
        }
        return lighterAST;
    }

    @NotNull
    public LightResolveResult resolveLocally(@NotNull LighterASTNode ref) {
        String refName;
        if (ref == null) {
            FileLocalResolver.$$$reportNull$$$0(2);
        }
        if ((refName = JavaLightTreeUtil.getNameIdentifierText(this.myTree, ref)) == null) {
            LightResolveResult lightResolveResult = LightResolveResult.UNKNOWN;
            if (lightResolveResult == null) {
                FileLocalResolver.$$$reportNull$$$0(3);
            }
            return lightResolveResult;
        }
        if (!this.canResolveToLocalVariable(this.myTree, ref)) {
            LightResolveResult lightResolveResult = LightResolveResult.NON_LOCAL;
            if (lightResolveResult == null) {
                FileLocalResolver.$$$reportNull$$$0(4);
            }
            return lightResolveResult;
        }
        boolean passedClass = false;
        LighterASTNode lastParent = ref;
        while (true) {
            ProgressManager.checkCanceled();
            LighterASTNode scope = this.myTree.getParent(lastParent);
            if (scope == null) {
                LightResolveResult lightResolveResult = LightResolveResult.NON_LOCAL;
                if (lightResolveResult == null) {
                    FileLocalResolver.$$$reportNull$$$0(5);
                }
                return lightResolveResult;
            }
            for (LighterASTNode var : this.getDeclarations(scope, lastParent)) {
                if (!refName.equals(JavaLightTreeUtil.getNameIdentifierText(this.myTree, var))) continue;
                if (passedClass) {
                    LightResolveResult lightResolveResult = var.getTokenType() == JavaElementType.FIELD ? LightResolveResult.NON_LOCAL : LightResolveResult.UNKNOWN;
                    if (lightResolveResult == null) {
                        FileLocalResolver.$$$reportNull$$$0(6);
                    }
                    return lightResolveResult;
                }
                LightResolveResult lightResolveResult = LightResolveResult.resolved(var);
                if (lightResolveResult == null) {
                    FileLocalResolver.$$$reportNull$$$0(7);
                }
                return lightResolveResult;
            }
            lastParent = scope;
            passedClass |= scope.getTokenType() == JavaElementType.CLASS || scope.getTokenType() == JavaElementType.ANONYMOUS_CLASS;
        }
    }

    private boolean canResolveToLocalVariable(@NotNull LighterAST tree, @NotNull LighterASTNode ref) {
        LighterASTNode parent2;
        if (tree == null) {
            FileLocalResolver.$$$reportNull$$$0(8);
        }
        if (ref == null) {
            FileLocalResolver.$$$reportNull$$$0(9);
        }
        return (parent2 = tree.getParent(ref)) != null && parent2.getTokenType() != JavaElementType.METHOD_CALL_EXPRESSION && !this.hasQualifier(ref);
    }

    private boolean hasQualifier(@NotNull LighterASTNode ref) {
        if (ref == null) {
            FileLocalResolver.$$$reportNull$$$0(10);
        }
        return LightTreeUtil.firstChildOfType(this.myTree, ref, ElementType.EXPRESSION_BIT_SET) != null;
    }

    @NotNull
    private Iterable<LighterASTNode> getDeclarations(LighterASTNode scope, @Nullable LighterASTNode lastParent) {
        IElementType type2 = scope.getTokenType();
        if (type2 == JavaElementType.CODE_BLOCK) {
            JBIterable<LighterASTNode> jBIterable = this.walkChildrenScopes(FileLocalResolver.before(LightTreeUtil.getChildrenOfType(this.myTree, scope, JavaElementType.DECLARATION_STATEMENT), lastParent));
            if (jBIterable == null) {
                FileLocalResolver.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }
        if (type2 == JavaElementType.DECLARATION_STATEMENT) {
            JBIterable<LighterASTNode> jBIterable = FileLocalResolver.before(LightTreeUtil.getChildrenOfType(this.myTree, scope, JavaElementType.LOCAL_VARIABLE), lastParent);
            if (jBIterable == null) {
                FileLocalResolver.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }
        if (type2 == JavaElementType.FOR_STATEMENT) {
            JBIterable<LighterASTNode> jBIterable = this.walkChildrenScopes(FileLocalResolver.before(LightTreeUtil.getChildrenOfType(this.myTree, scope, ElementType.JAVA_STATEMENT_BIT_SET), lastParent));
            if (jBIterable == null) {
                FileLocalResolver.$$$reportNull$$$0(13);
            }
            return jBIterable;
        }
        if (type2 == JavaElementType.FOREACH_STATEMENT || type2 == JavaElementType.CATCH_SECTION) {
            JBIterable<LighterASTNode> jBIterable = JBIterable.of(LightTreeUtil.firstChildOfType(this.myTree, scope, JavaElementType.PARAMETER));
            if (jBIterable == null) {
                FileLocalResolver.$$$reportNull$$$0(14);
            }
            return jBIterable;
        }
        if (type2 == JavaElementType.TRY_STATEMENT) {
            JBIterable<LighterASTNode> jBIterable = this.walkChildrenScopes(FileLocalResolver.before(LightTreeUtil.getChildrenOfType(this.myTree, scope, JavaElementType.RESOURCE_LIST), lastParent));
            if (jBIterable == null) {
                FileLocalResolver.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }
        if (type2 == JavaElementType.RESOURCE_LIST) {
            JBIterable<LighterASTNode> jBIterable = FileLocalResolver.before(LightTreeUtil.getChildrenOfType(this.myTree, scope, JavaElementType.RESOURCE_VARIABLE), lastParent);
            if (jBIterable == null) {
                FileLocalResolver.$$$reportNull$$$0(16);
            }
            return jBIterable;
        }
        if (type2 == JavaElementType.CLASS) {
            List<LighterASTNode> list2 = LightTreeUtil.getChildrenOfType(this.myTree, scope, JavaElementType.FIELD);
            if (list2 == null) {
                FileLocalResolver.$$$reportNull$$$0(17);
            }
            return list2;
        }
        if (type2 == JavaElementType.LAMBDA_EXPRESSION || type2 == JavaElementType.METHOD) {
            LighterASTNode paramList = LightTreeUtil.firstChildOfType(this.myTree, scope, JavaElementType.PARAMETER_LIST);
            List<LighterASTNode> list3 = paramList == null ? ContainerUtil.emptyList() : LightTreeUtil.getChildrenOfType(this.myTree, paramList, JavaElementType.PARAMETER);
            if (list3 == null) {
                FileLocalResolver.$$$reportNull$$$0(18);
            }
            return list3;
        }
        List<LighterASTNode> list4 = Collections.emptyList();
        if (list4 == null) {
            FileLocalResolver.$$$reportNull$$$0(19);
        }
        return list4;
    }

    @NotNull
    private JBIterable<LighterASTNode> walkChildrenScopes(JBIterable<LighterASTNode> children2) {
        JBIterable<LighterASTNode> jBIterable = children2.flatMap(child -> this.getDeclarations((LighterASTNode)child, null));
        if (jBIterable == null) {
            FileLocalResolver.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<LighterASTNode> before(List<LighterASTNode> children2, @Nullable LighterASTNode lastParent) {
        JBIterable<LighterASTNode> jBIterable = JBIterable.from(children2).filter(node -> lastParent == null || node.getStartOffset() < lastParent.getStartOffset());
        if (jBIterable == null) {
            FileLocalResolver.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    @Nullable
    public String getShortClassTypeName(@NotNull LighterASTNode var) {
        LighterASTNode typeRef;
        String refName;
        if (var == null) {
            FileLocalResolver.$$$reportNull$$$0(22);
        }
        if ((refName = JavaLightTreeUtil.getNameIdentifierText(this.myTree, typeRef = LightTreeUtil.firstChildOfType(this.myTree, LightTreeUtil.firstChildOfType(this.myTree, var, JavaElementType.TYPE), JavaElementType.JAVA_CODE_REFERENCE))) == null) {
            return null;
        }
        if (LightTreeUtil.firstChildOfType(this.myTree, typeRef, JavaElementType.JAVA_CODE_REFERENCE) != null) {
            return refName;
        }
        if (this.isTypeParameter(refName, var)) {
            return null;
        }
        return refName;
    }

    private boolean isTypeParameter(String name, LighterASTNode place) {
        LighterASTNode scope = place;
        while (scope != null) {
            if (scope.getTokenType() == JavaElementType.CLASS || scope.getTokenType() == JavaElementType.METHOD) {
                if (this.hasOwnTypeParameter(name, scope)) {
                    return true;
                }
                if (this.isStatic(scope)) break;
            }
            scope = this.myTree.getParent(scope);
        }
        return false;
    }

    private boolean hasOwnTypeParameter(String name, LighterASTNode member) {
        LighterASTNode typeParams = LightTreeUtil.firstChildOfType(this.myTree, member, JavaElementType.TYPE_PARAMETER_LIST);
        if (typeParams != null) {
            for (LighterASTNode param : LightTreeUtil.getChildrenOfType(this.myTree, typeParams, JavaElementType.TYPE_PARAMETER)) {
                if (!name.equals(JavaLightTreeUtil.getNameIdentifierText(this.myTree, param))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStatic(LighterASTNode scope) {
        LighterASTNode modList2 = LightTreeUtil.firstChildOfType(this.myTree, scope, JavaElementType.MODIFIER_LIST);
        return modList2 != null && LightTreeUtil.firstChildOfType(this.myTree, modList2, JavaTokenType.STATIC_KEYWORD) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/FileLocalResolver";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/FileLocalResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightTree";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocally";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "walkChildrenScopes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "before";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocally";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canResolveToLocalVariable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasQualifier";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getShortClassTypeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LightResolveResult {
        public static final LightResolveResult UNKNOWN = new LightResolveResult();
        public static final LightResolveResult NON_LOCAL = new LightResolveResult();

        @NotNull
        static LightResolveResult resolved(final @NotNull LighterASTNode target) {
            if (target == null) {
                LightResolveResult.$$$reportNull$$$0(0);
            }
            LightResolveResult lightResolveResult = new LightResolveResult(){

                @Override
                @Nullable
                public LighterASTNode getTarget() {
                    return target;
                }
            };
            if (lightResolveResult == null) {
                LightResolveResult.$$$reportNull$$$0(1);
            }
            return lightResolveResult;
        }

        @Nullable
        public LighterASTNode getTarget() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/FileLocalResolver$LightResolveResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/FileLocalResolver$LightResolveResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolved";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolved";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

