/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FunctionsFromAnyGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class FunctionsFromAnyGeneratorImpl
extends FunctionsFromAnyGenerator {
    private final ClassDescriptor classDescriptor;
    private final Type classAsmType;
    private final FieldOwnerContext<?> fieldOwnerContext;
    private final ClassBuilder v;
    private final GenerationState generationState;
    private final KotlinTypeMapper typeMapper;
    private final JvmKotlinType underlyingType;

    public FunctionsFromAnyGeneratorImpl(@NotNull KtClassOrObject declaration, @NotNull BindingContext bindingContext, @NotNull ClassDescriptor descriptor2, @NotNull Type type2, @NotNull FieldOwnerContext<?> fieldOwnerContext, @NotNull ClassBuilder v2, @NotNull GenerationState state2) {
        if (declaration == null) {
            FunctionsFromAnyGeneratorImpl.$$$reportNull$$$0(0);
        }
        if (bindingContext == null) {
            FunctionsFromAnyGeneratorImpl.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            FunctionsFromAnyGeneratorImpl.$$$reportNull$$$0(2);
        }
        if (type2 == null) {
            FunctionsFromAnyGeneratorImpl.$$$reportNull$$$0(3);
        }
        if (fieldOwnerContext == null) {
            FunctionsFromAnyGeneratorImpl.$$$reportNull$$$0(4);
        }
        if (v2 == null) {
            FunctionsFromAnyGeneratorImpl.$$$reportNull$$$0(5);
        }
        if (state2 == null) {
            FunctionsFromAnyGeneratorImpl.$$$reportNull$$$0(6);
        }
        super(declaration, bindingContext);
        this.classDescriptor = descriptor2;
        this.classAsmType = type2;
        this.fieldOwnerContext = fieldOwnerContext;
        this.v = v2;
        this.generationState = state2;
        this.typeMapper = state2.getTypeMapper();
        this.underlyingType = new JvmKotlinType(this.typeMapper.mapType(descriptor2), InlineClassesUtilsKt.substitutedUnderlyingType(descriptor2.getDefaultType()));
    }

    @Override
    protected void generateToStringMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> properties2) {
        if (function2 == null) {
            FunctionsFromAnyGeneratorImpl.$$$reportNull$$$0(7);
        }
        if (properties2 == null) {
            FunctionsFromAnyGeneratorImpl.$$$reportNull$$$0(8);
        }
        MethodContext context = this.fieldOwnerContext.intoFunction(function2);
        JvmDeclarationOrigin methodOrigin = JvmDeclarationOriginKt.OtherOrigin(function2);
        String toStringMethodName = this.mapFunctionName(function2);
        MethodVisitor mv = this.v.newMethod(methodOrigin, this.getAccess(), toStringMethodName, this.getToStringDesc(), null, null);
        if (this.fieldOwnerContext.getContextKind() != OwnerKind.ERASED_INLINE_CLASS && this.classDescriptor.isInline()) {
            FunctionCodegen.generateMethodInsideInlineClassWrapper(methodOrigin, function2, this.classDescriptor, mv, this.typeMapper);
            return;
        }
        FunctionsFromAnyGeneratorImpl.visitEndForAnnotationVisitor(mv.visitAnnotation(Type.getDescriptor(NotNull.class), false));
        if (!this.generationState.getClassBuilderMode().generateBodies) {
            FunctionCodegen.endVisit(mv, toStringMethodName, this.getDeclaration());
            return;
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        mv.visitCode();
        AsmUtil.genStringBuilderConstructor(iv);
        boolean first2 = true;
        for (PropertyDescriptor propertyDescriptor2 : properties2) {
            if (first2) {
                iv.aconst(this.classDescriptor.getName() + "(" + propertyDescriptor2.getName().asString() + "=");
                first2 = false;
            } else {
                iv.aconst(", " + propertyDescriptor2.getName().asString() + "=");
            }
            AsmUtil.genInvokeAppendMethod(iv, AsmTypes.JAVA_STRING_TYPE, null);
            JvmKotlinType type2 = this.genOrLoadOnStack(iv, context, propertyDescriptor2, 0);
            Type asmType = type2.getType();
            KotlinType kotlinType2 = type2.getKotlinType();
            if (asmType.getSort() == 9) {
                Type elementType = AsmUtil.correctElementType(asmType);
                if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                    iv.invokestatic("java/util/Arrays", "toString", "([Ljava/lang/Object;)Ljava/lang/String;", false);
                    asmType = AsmTypes.JAVA_STRING_TYPE;
                    kotlinType2 = DescriptorUtilsKt.getBuiltIns(function2).getStringType();
                } else if (elementType.getSort() != 2) {
                    iv.invokestatic("java/util/Arrays", "toString", "(" + asmType.getDescriptor() + ")Ljava/lang/String;", false);
                    asmType = AsmTypes.JAVA_STRING_TYPE;
                    kotlinType2 = DescriptorUtilsKt.getBuiltIns(function2).getStringType();
                }
            }
            AsmUtil.genInvokeAppendMethod(iv, asmType, kotlinType2, this.typeMapper);
        }
        iv.aconst(")");
        AsmUtil.genInvokeAppendMethod(iv, AsmTypes.JAVA_STRING_TYPE, null);
        iv.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        iv.areturn(AsmTypes.JAVA_STRING_TYPE);
        FunctionCodegen.endVisit(mv, toStringMethodName, this.getDeclaration());
    }

    @Override
    protected void generateHashCodeMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> properties2) {
        if (function2 == null) {
            FunctionsFromAnyGeneratorImpl.$$$reportNull$$$0(9);
        }
        if (properties2 == null) {
            FunctionsFromAnyGeneratorImpl.$$$reportNull$$$0(10);
        }
        MethodContext context = this.fieldOwnerContext.intoFunction(function2);
        JvmDeclarationOrigin methodOrigin = JvmDeclarationOriginKt.OtherOrigin(function2);
        String hashCodeMethodName = this.mapFunctionName(function2);
        MethodVisitor mv = this.v.newMethod(methodOrigin, this.getAccess(), hashCodeMethodName, this.getHashCodeDesc(), null, null);
        if (this.fieldOwnerContext.getContextKind() != OwnerKind.ERASED_INLINE_CLASS && this.classDescriptor.isInline()) {
            FunctionCodegen.generateMethodInsideInlineClassWrapper(methodOrigin, function2, this.classDescriptor, mv, this.typeMapper);
            return;
        }
        if (!this.generationState.getClassBuilderMode().generateBodies) {
            FunctionCodegen.endVisit(mv, hashCodeMethodName, this.getDeclaration());
            return;
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        mv.visitCode();
        boolean first2 = true;
        for (PropertyDescriptor propertyDescriptor2 : properties2) {
            if (!first2) {
                iv.iconst(31);
                iv.mul(Type.INT_TYPE);
            }
            JvmKotlinType propertyType = this.genOrLoadOnStack(iv, context, propertyDescriptor2, 0);
            KotlinType kotlinType2 = propertyDescriptor2.getReturnType();
            Type asmType = this.typeMapper.mapType(kotlinType2);
            StackValue.coerce(propertyType.getType(), propertyType.getKotlinType(), asmType, kotlinType2, iv);
            Label ifNull = null;
            if (!AsmUtil.isPrimitive(asmType)) {
                ifNull = new Label();
                iv.dup();
                iv.ifnull(ifNull);
            }
            AsmUtil.genHashCode(mv, iv, asmType, this.generationState.getTarget());
            if (ifNull != null) {
                Label end = new Label();
                iv.goTo(end);
                iv.mark(ifNull);
                iv.pop();
                iv.iconst(0);
                iv.mark(end);
            }
            if (first2) {
                first2 = false;
                continue;
            }
            iv.add(Type.INT_TYPE);
        }
        mv.visitInsn(172);
        FunctionCodegen.endVisit(mv, hashCodeMethodName, this.getDeclaration());
    }

    private String mapFunctionName(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            FunctionsFromAnyGeneratorImpl.$$$reportNull$$$0(11);
        }
        return this.typeMapper.mapFunctionName(functionDescriptor, this.fieldOwnerContext.getContextKind());
    }

    @Override
    protected void generateEqualsMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> properties2) {
        boolean isErasedInlineClassKind;
        if (function2 == null) {
            FunctionsFromAnyGeneratorImpl.$$$reportNull$$$0(12);
        }
        if (properties2 == null) {
            FunctionsFromAnyGeneratorImpl.$$$reportNull$$$0(13);
        }
        MethodContext context = this.fieldOwnerContext.intoFunction(function2);
        JvmDeclarationOrigin methodOrigin = JvmDeclarationOriginKt.OtherOrigin(function2);
        String equalsMethodName = this.mapFunctionName(function2);
        MethodVisitor mv = this.v.newMethod(methodOrigin, this.getAccess(), equalsMethodName, this.getEqualsDesc(), null, null);
        boolean bl = isErasedInlineClassKind = this.fieldOwnerContext.getContextKind() == OwnerKind.ERASED_INLINE_CLASS;
        if (!isErasedInlineClassKind && this.classDescriptor.isInline()) {
            FunctionCodegen.generateMethodInsideInlineClassWrapper(methodOrigin, function2, this.classDescriptor, mv, this.typeMapper);
            return;
        }
        FunctionsFromAnyGeneratorImpl.visitEndForAnnotationVisitor(mv.visitParameterAnnotation(isErasedInlineClassKind ? 1 : 0, Type.getDescriptor(Nullable.class), false));
        if (!this.generationState.getClassBuilderMode().generateBodies) {
            FunctionCodegen.endVisit(mv, equalsMethodName, this.getDeclaration());
            return;
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        mv.visitCode();
        Label eq = new Label();
        Label ne = new Label();
        int storedValueIndex = this.generateBasicChecksAndStoreTarget(iv, eq, ne);
        for (PropertyDescriptor propertyDescriptor2 : properties2) {
            KotlinType kotlinType2 = propertyDescriptor2.getReturnType();
            Type asmType = this.typeMapper.mapType(kotlinType2);
            StackValue thisPropertyValue = StackValue.operation(asmType, kotlinType2, (Function1<InstructionAdapter, Unit>)((Function1)iiv -> {
                JvmKotlinType thisPropertyType = this.genOrLoadOnStack((InstructionAdapter)iiv, context, propertyDescriptor2, 0);
                StackValue.coerce(thisPropertyType.getType(), thisPropertyType.getKotlinType(), asmType, kotlinType2, iiv);
                return Unit.INSTANCE;
            }));
            StackValue otherPropertyValue = StackValue.operation(asmType, kotlinType2, (Function1<InstructionAdapter, Unit>)((Function1)iiv -> {
                JvmKotlinType otherPropertyType = this.genOrLoadOnStack((InstructionAdapter)iiv, context, propertyDescriptor2, storedValueIndex);
                StackValue.coerce(otherPropertyType.getType(), otherPropertyType.getKotlinType(), asmType, kotlinType2, iiv);
                return Unit.INSTANCE;
            }));
            if (asmType.getSort() == 6) {
                thisPropertyValue.put(asmType, kotlinType2, iv);
                otherPropertyValue.put(asmType, kotlinType2, iv);
                iv.invokestatic("java/lang/Float", "compare", "(FF)I", false);
                iv.ifne(ne);
                continue;
            }
            if (asmType.getSort() == 8) {
                thisPropertyValue.put(asmType, kotlinType2, iv);
                otherPropertyValue.put(asmType, kotlinType2, iv);
                iv.invokestatic("java/lang/Double", "compare", "(DD)I", false);
                iv.ifne(ne);
                continue;
            }
            StackValue value = AsmUtil.genEqualsForExpressionsOnStack(KtTokens.EQEQ, thisPropertyValue, otherPropertyValue);
            value.put(Type.BOOLEAN_TYPE, iv);
            iv.ifeq(ne);
        }
        iv.mark(eq);
        iv.iconst(1);
        iv.areturn(Type.INT_TYPE);
        iv.mark(ne);
        iv.iconst(0);
        iv.areturn(Type.INT_TYPE);
        FunctionCodegen.endVisit(mv, equalsMethodName, this.getDeclaration());
    }

    private static void visitEndForAnnotationVisitor(@Nullable AnnotationVisitor annotation2) {
        if (annotation2 != null) {
            annotation2.visitEnd();
        }
    }

    private int generateBasicChecksAndStoreTarget(InstructionAdapter iv, Label eq, Label ne) {
        if (this.fieldOwnerContext.getContextKind() == OwnerKind.ERASED_INLINE_CLASS) {
            SimpleType wrapperKotlinType = this.classDescriptor.getDefaultType();
            Type wrapperType = this.typeMapper.mapTypeAsDeclaration(wrapperKotlinType);
            int secondParameterIndex = this.underlyingType.getType().getSize();
            iv.load(secondParameterIndex, AsmTypes.OBJECT_TYPE);
            iv.instanceOf(wrapperType);
            iv.ifeq(ne);
            int unboxedValueIndex = secondParameterIndex + 1;
            iv.load(secondParameterIndex, AsmTypes.OBJECT_TYPE);
            iv.checkcast(wrapperType);
            StackValue.unboxInlineClass(wrapperType, wrapperKotlinType, iv);
            iv.store(unboxedValueIndex, this.underlyingType.getType());
            return unboxedValueIndex;
        }
        iv.load(0, AsmTypes.OBJECT_TYPE);
        iv.load(1, AsmTypes.OBJECT_TYPE);
        iv.ifacmpeq(eq);
        iv.load(1, AsmTypes.OBJECT_TYPE);
        iv.instanceOf(this.classAsmType);
        iv.ifeq(ne);
        iv.load(1, AsmTypes.OBJECT_TYPE);
        iv.checkcast(this.classAsmType);
        iv.store(2, AsmTypes.OBJECT_TYPE);
        return 2;
    }

    private JvmKotlinType genOrLoadOnStack(InstructionAdapter iv, MethodContext context, PropertyDescriptor propertyDescriptor2, int index2) {
        if (this.fieldOwnerContext.getContextKind() == OwnerKind.ERASED_INLINE_CLASS) {
            iv.load(index2, this.underlyingType.getType());
            return this.underlyingType;
        }
        return ImplementationBodyCodegen.genPropertyOnStack(iv, context, propertyDescriptor2, this.classAsmType, index2, this.generationState);
    }

    private String getToStringDesc() {
        return "(" + this.getFirstParameterDesc() + ")Ljava/lang/String;";
    }

    private String getHashCodeDesc() {
        return "(" + this.getFirstParameterDesc() + ")I";
    }

    private String getEqualsDesc() {
        return "(" + this.getFirstParameterDesc() + "Ljava/lang/Object;)Z";
    }

    private String getFirstParameterDesc() {
        return this.fieldOwnerContext.getContextKind() == OwnerKind.ERASED_INLINE_CLASS ? this.underlyingType.getType().getDescriptor() : "";
    }

    private int getAccess() {
        int access = 1;
        if (this.fieldOwnerContext.getContextKind() == OwnerKind.ERASED_INLINE_CLASS) {
            access |= 8;
        }
        return access;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldOwnerContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/FunctionsFromAnyGeneratorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "generateToStringMethod";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "generateHashCodeMethod";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "mapFunctionName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "generateEqualsMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

