/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.recomp.ClasspathChangeDependentsFinder;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.tasks.incremental.InputFileDetails;

public class ClasspathEntryChangeProcessor {
    private final ClasspathChangeDependentsFinder dependentsFinder;

    public ClasspathEntryChangeProcessor(ClasspathSnapshot classpathSnapshot, PreviousCompilation previousCompilation) {
        this.dependentsFinder = new ClasspathChangeDependentsFinder(classpathSnapshot, previousCompilation);
    }

    public void processChange(InputFileDetails input, RecompilationSpec spec) {
        DependentsSet actualDependents = this.dependentsFinder.getActualDependents(input, input.getFile());
        if (actualDependents.isDependencyToAll()) {
            spec.setFullRebuildCause(actualDependents.getDescription(), input.getFile());
            return;
        }
        spec.getClassesToCompile().addAll(actualDependents.getDependentClasses());
        spec.getResourcesToGenerate().addAll(actualDependents.getDependentResources());
    }
}

