/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProducerAwareProperty;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.util.DeprecationLogger;

public abstract class AbstractProperty<T>
extends AbstractMinimalProvider<T>
implements PropertyInternal<T>,
ProducerAwareProperty {
    private State state = State.InitialValue;
    private boolean finalizeOnNextGet;
    private Task producer;

    @Override
    public void attachProducer(Task task) {
        if (this.producer != null && this.producer != task) {
            throw new IllegalStateException("This property already has a producer task associated with it.");
        }
        this.producer = task;
    }

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        if (this.producer != null) {
            context.add(this.producer);
            return true;
        }
        return false;
    }

    @Override
    public void finalizeValue() {
        if (this.state != State.FinalStrict) {
            this.makeFinal();
        }
        this.state = State.FinalStrict;
    }

    @Override
    public void finalizeValueOnReadAndWarnAboutChanges() {
        this.finalizeOnNextGet = true;
    }

    protected abstract void applyDefaultValue();

    protected abstract void makeFinal();

    protected void beforeRead() {
        if (this.state == State.FinalLenient || this.state == State.FinalStrict) {
            return;
        }
        if (this.finalizeOnNextGet) {
            this.makeFinal();
            this.state = State.FinalLenient;
        }
    }

    protected boolean beforeMutate() {
        if (this.state == State.FinalStrict) {
            throw new IllegalStateException("The value for this property is final and cannot be changed any further.");
        }
        if (this.state == State.FinalLenient) {
            DeprecationLogger.nagUserOfDiscontinuedInvocation((String)"Changing the value for a property with a final value");
            return false;
        }
        if (this.state == State.Convention) {
            this.applyDefaultValue();
            this.state = State.InitialValue;
        }
        return true;
    }

    protected void afterMutate() {
        if (this.state == State.InitialValue || this.state == State.Convention) {
            this.state = State.Mutable;
        }
    }

    protected boolean shouldApplyConvention() {
        if (!this.beforeMutate()) {
            return false;
        }
        if (this.state == State.InitialValue) {
            this.state = State.Convention;
            return true;
        }
        return this.state == State.Convention;
    }

    private static enum State {
        InitialValue,
        Convention,
        Mutable,
        FinalLenient,
        FinalStrict;

    }
}

