/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import java.io.File;
import java.util.Map;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.properties.ValidationAction;
import org.gradle.internal.typeconversion.UnsupportedNotationException;

public enum ValidationActions implements ValidationAction
{
    NO_OP("file collection"){

        @Override
        public void doValidate(String propertyName, Object value, TaskValidationContext context) {
        }
    }
    ,
    INPUT_FILE_VALIDATOR("file"){

        @Override
        public void doValidate(String propertyName, Object value, TaskValidationContext context) {
            File file = ValidationActions.toFile(context, value);
            if (!file.exists()) {
                context.visitError(String.format("File '%s' specified for property '%s' does not exist.", file, propertyName));
            } else if (!file.isFile()) {
                context.visitError(String.format("File '%s' specified for property '%s' is not a file.", file, propertyName));
            }
        }
    }
    ,
    INPUT_DIRECTORY_VALIDATOR("directory"){

        @Override
        public void doValidate(String propertyName, Object value, TaskValidationContext context) {
            File directory = ValidationActions.toDirectory(context, value);
            if (!directory.exists()) {
                context.visitError(String.format("Directory '%s' specified for property '%s' does not exist.", directory, propertyName));
            } else if (!directory.isDirectory()) {
                context.visitError(String.format("Directory '%s' specified for property '%s' is not a directory.", directory, propertyName));
            }
        }
    }
    ,
    OUTPUT_DIRECTORY_VALIDATOR("file"){

        @Override
        public void doValidate(String propertyName, Object value, TaskValidationContext context) {
            File directory = ValidationActions.toFile(context, value);
            ValidationActions.validateNotInReservedFileSystemLocation(context, directory);
            if (directory.exists()) {
                if (!directory.isDirectory()) {
                    context.visitError(String.format("Directory '%s' specified for property '%s' is not a directory.", directory, propertyName));
                }
            } else {
                for (File candidate = directory.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    context.visitError(String.format("Cannot write to directory '%s' specified for property '%s', as ancestor '%s' is not a directory.", directory, propertyName, candidate));
                    return;
                }
            }
        }
    }
    ,
    OUTPUT_DIRECTORIES_VALIDATOR("file collection"){

        @Override
        public void doValidate(String propertyName, Object values, TaskValidationContext context) {
            for (File directory : ValidationActions.toFiles(context, values)) {
                OUTPUT_DIRECTORY_VALIDATOR.validate(propertyName, directory, context);
            }
        }
    }
    ,
    OUTPUT_FILE_VALIDATOR("file"){

        @Override
        public void doValidate(String propertyName, Object value, TaskValidationContext context) {
            block2: {
                File file;
                block1: {
                    file = ValidationActions.toFile(context, value);
                    ValidationActions.validateNotInReservedFileSystemLocation(context, file);
                    if (!file.exists()) break block1;
                    if (!file.isDirectory()) break block2;
                    context.visitError(String.format("Cannot write to file '%s' specified for property '%s' as it is a directory.", file, propertyName));
                    break block2;
                }
                for (File candidate = file.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    context.visitError(String.format("Cannot write to file '%s' specified for property '%s', as ancestor '%s' is not a directory.", file, propertyName, candidate));
                    break;
                }
            }
        }
    }
    ,
    OUTPUT_FILES_VALIDATOR("file collection"){

        @Override
        public void doValidate(String propertyName, Object values, TaskValidationContext context) {
            for (File file : ValidationActions.toFiles(context, values)) {
                OUTPUT_FILE_VALIDATOR.validate(propertyName, file, context);
            }
        }
    };

    private final String targetType;

    private static void validateNotInReservedFileSystemLocation(TaskValidationContext context, File location) {
        if (context.isInReservedFileSystemLocation(location)) {
            context.visitError(String.format("The output %s must not be in a reserved location.", location));
        }
    }

    private ValidationActions(String targetType) {
        this.targetType = targetType;
    }

    protected abstract void doValidate(String var1, Object var2, TaskValidationContext var3);

    @Override
    public void validate(String propertyName, Object value, TaskValidationContext context) {
        try {
            this.doValidate(propertyName, value, context);
        }
        catch (UnsupportedNotationException ignored) {
            context.visitError(String.format("Value '%s' specified for property '%s' cannot be converted to a %s.", value, propertyName, this.targetType));
        }
    }

    private static File toDirectory(TaskValidationContext context, Object value) {
        if (value instanceof ConfigurableFileTree) {
            return ((ConfigurableFileTree)value).getDir();
        }
        return ValidationActions.toFile(context, value);
    }

    private static File toFile(TaskValidationContext context, Object value) {
        return context.getResolver().resolve(value);
    }

    private static Iterable<? extends File> toFiles(TaskValidationContext context, Object value) {
        if (value instanceof Map) {
            return ValidationActions.toFiles(context, ((Map)value).values());
        }
        if (value instanceof FileCollection) {
            return (FileCollection)value;
        }
        return context.getResolver().resolveFiles(new Object[]{value});
    }
}

