/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.ValidatingProperty;
import org.gradle.api.internal.tasks.properties.ValidationAction;
import org.gradle.util.DeferredUtil;

public abstract class AbstractValidatingProperty
implements ValidatingProperty {
    private final String propertyName;
    private final PropertyValue value;
    private final boolean optional;
    private final ValidationAction validationAction;

    public AbstractValidatingProperty(String propertyName, PropertyValue value, boolean optional, ValidationAction validationAction) {
        this.propertyName = propertyName;
        this.value = value;
        this.optional = optional;
        this.validationAction = validationAction;
    }

    @Override
    public void validate(TaskValidationContext context) {
        Object unpacked = DeferredUtil.unpack((Object)this.value.call());
        if (unpacked == null) {
            if (!this.optional) {
                context.visitError(String.format("No value has been specified for property '%s'.", this.propertyName));
            }
        } else {
            this.validationAction.validate(this.propertyName, unpacked, context);
        }
    }

    @Override
    public void prepareValue() {
        this.value.maybeFinalizeValue();
    }

    @Override
    public void cleanupValue() {
    }
}

