/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.execution.SelfDescribingSpec;
import org.gradle.api.internal.tasks.execution.TaskCacheabilityResolver;
import org.gradle.api.internal.tasks.properties.CacheableOutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.file.RelativeFilePathResolver;

public class DefaultTaskCacheabilityResolver
implements TaskCacheabilityResolver {
    private static final CachingDisabledReason CACHING_NOT_ENABLED = new CachingDisabledReason(CachingDisabledReasonCategory.NOT_CACHEABLE, "Caching has not been enabled for the task");
    private static final CachingDisabledReason NO_OUTPUTS_DECLARED = new CachingDisabledReason(CachingDisabledReasonCategory.NO_OUTPUTS_DECLARED, "No outputs declared");
    private final RelativeFilePathResolver relativeFilePathResolver;

    public DefaultTaskCacheabilityResolver(RelativeFilePathResolver relativeFilePathResolver) {
        this.relativeFilePathResolver = relativeFilePathResolver;
    }

    @Override
    public Optional<CachingDisabledReason> shouldDisableCaching(boolean hasDeclaredOutputs, ImmutableSortedSet<OutputFilePropertySpec> outputFileProperties, TaskInternal task, Collection<SelfDescribingSpec<TaskInternal>> cacheIfSpecs, Collection<SelfDescribingSpec<TaskInternal>> doNotCacheIfSpecs, @Nullable OverlappingOutputs overlappingOutputs) {
        if (cacheIfSpecs.isEmpty()) {
            return Optional.of(CACHING_NOT_ENABLED);
        }
        if (!hasDeclaredOutputs) {
            return Optional.of(NO_OUTPUTS_DECLARED);
        }
        if (overlappingOutputs != null) {
            String relativePath = this.relativeFilePathResolver.resolveAsRelativePath((Object)overlappingOutputs.getOverlappedFilePath());
            return Optional.of(new CachingDisabledReason(CachingDisabledReasonCategory.OVERLAPPING_OUTPUTS, "Gradle does not know how file '" + relativePath + "' was created (output property '" + overlappingOutputs.getPropertyName() + "'). Task output caching requires exclusive access to output paths to guarantee correctness."));
        }
        for (OutputFilePropertySpec spec : outputFileProperties) {
            if (spec instanceof CacheableOutputFilePropertySpec) continue;
            return Optional.of(new CachingDisabledReason(CachingDisabledReasonCategory.NON_CACHEABLE_OUTPUT, "Output property '" + spec.getPropertyName() + "' contains a file tree"));
        }
        for (SelfDescribingSpec cacheIfSpec : cacheIfSpecs) {
            if (cacheIfSpec.isSatisfiedBy(task)) continue;
            return Optional.of(new CachingDisabledReason(CachingDisabledReasonCategory.ENABLE_CONDITION_NOT_SATISFIED, "'" + cacheIfSpec.getDisplayName() + "' not satisfied"));
        }
        for (SelfDescribingSpec doNotCacheIfSpec : doNotCacheIfSpecs) {
            if (!doNotCacheIfSpec.isSatisfiedBy(task)) continue;
            return Optional.of(new CachingDisabledReason(CachingDisabledReasonCategory.DISABLE_CONDITION_SATISFIED, "'" + doNotCacheIfSpec.getDisplayName() + "' satisfied"));
        }
        return Optional.empty();
    }
}

