/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.util.html.CompletelyDifferentHTMLDataTypeRepresentationWrapper;
import ghidra.app.util.html.HTMLDataTypeRepresentationDiffInput;
import ghidra.app.util.html.PlaceHolderLine;
import ghidra.app.util.html.TextLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DefaultDataType;
import ghidra.util.HTMLUtilities;
import ghidra.util.StringUtilities;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public abstract class HTMLDataTypeRepresentation {
    protected static final String EMPTY_TAG = "<I></I>";
    protected static final int MAX_COMPONENTS = 50;
    protected static final int MAX_CHARACTER_LENGTH = 80;
    protected static final int MAX_LINE_LENGTH = 240;
    protected static final String HTML_OPEN = "<HTML>";
    protected static final String HTML_CLOSE = "</HTML>";
    protected static final String HTML_SPACE = "&nbsp;";
    protected static final String CHARACTER_SPACE = " ";
    protected static final String TAB = HTMLDataTypeRepresentation.createSpace(4);
    protected static final String BR = "<BR>";
    protected static final String TABLE_OPEN = "<TABLE>";
    protected static final String TABLE_CLOSE = "</TABLE>";
    protected static final String TR_OPEN = "<TR>";
    protected static final String TR_CLOSE = "</TR>";
    protected static final String TD_OPEN = "<TD ALIGN=LEFT VALIGN=TOP>";
    protected static final String TD_CLOSE = "</TD>";
    protected static final String TT_OPEN = "<TT>";
    protected static final String TT_CLOSE = "</TT>";
    protected static final String INDENT_OPEN = "<DIV STYLE='margin-left: 10px;'>";
    protected static final String INDENT_CLOSE = "</DIV>";
    protected static final String ELLIPSES = "...";
    protected static final String LENGTH_PREFIX = "Length: ";
    protected static final String FORWARD_SLASH = "&#47;";
    protected static final String START_COMMENT = "&#47;*<BR>";
    protected static final String MIDDLE_COMMENT = "&nbsp;*&nbsp;";
    protected static final String END_COMMENT = "&nbsp;*&#47;<BR>";
    protected static final Color DIFF_COLOR = ValidatableLine.INVALID_COLOR;
    protected String originalHTMLData;

    private static String createSpace(int numberOfSpaces) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < numberOfSpaces; ++i) {
            buffer.append(HTML_SPACE);
        }
        return buffer.toString();
    }

    protected static StringBuilder addDataTypeLength(String dataTypeLengthString, StringBuilder buffer) {
        buffer.append(BR);
        buffer.append(LENGTH_PREFIX);
        buffer.append(dataTypeLengthString);
        return buffer;
    }

    protected static StringBuilder addDataTypeLength(DataType dt, StringBuilder buffer) {
        buffer.append(BR);
        buffer.append(LENGTH_PREFIX);
        buffer.append(HTMLDataTypeRepresentation.getDataTypeLengthString(dt));
        return buffer;
    }

    protected static String getDataTypeLengthString(DataType dt) {
        int length;
        String lengthString = null;
        lengthString = dt == null ? "<i>Unknown</i>" : ((length = dt.getLength()) >= 0 ? Integer.toString(length) : " <i>Unsized</i>");
        return lengthString;
    }

    protected static String getCommentForDataType(DataType dataType) {
        String comment = null;
        if (dataType instanceof DataTypeComponent) {
            comment = ((DataTypeComponent)dataType).getComment();
        }
        if (comment == null) {
            comment = dataType.getDescription();
        }
        return comment == null ? "" : HTMLUtilities.escapeHTML((String)comment);
    }

    protected static String truncateAsNecessary(String string) {
        return HTMLDataTypeRepresentation.truncateAsNecessary(string, 80);
    }

    protected static String truncateAsNecessary(String string, int length) {
        if (string == null) {
            return "";
        }
        if (string.length() > length) {
            return string.substring(0, length) + ELLIPSES;
        }
        return string;
    }

    private static List<String> breakCommentAsNecessary(String string) {
        ArrayList<String> list = new ArrayList<String>();
        for (String nativeCommentLine : string.split("\n")) {
            List<String> wrappedLines = HTMLDataTypeRepresentation.breakLongLineAtWordBoundaries(nativeCommentLine, 80 - MIDDLE_COMMENT.length());
            for (int i = 0; i < wrappedLines.size(); ++i) {
                String wrappedLine = wrappedLines.get(i);
                list.add(MIDDLE_COMMENT + wrappedLine + BR);
            }
        }
        return list;
    }

    static List<String> breakLongLineAtWordBoundaries(String lineStr, int maxLineLen) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder lineBuffer = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(lineStr, CHARACTER_SPACE, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            while (!token.isEmpty()) {
                int lineCharsAvail = maxLineLen - lineBuffer.length();
                if (lineCharsAvail < token.length() && token.length() < maxLineLen) {
                    result.add(lineBuffer.toString());
                    lineBuffer.setLength(0);
                    lineCharsAvail = maxLineLen;
                }
                int partLen = Math.min(lineCharsAvail, token.length());
                String part = token.substring(0, partLen);
                lineBuffer.append(part);
                token = token.substring(partLen);
                if (lineBuffer.length() < maxLineLen) continue;
                result.add(lineBuffer.toString());
                lineBuffer.setLength(0);
            }
        }
        if (lineBuffer.length() > 0) {
            result.add(lineBuffer.toString());
        }
        return result;
    }

    protected static String wrapStringInColor(String string, Color color) {
        if (color == null) {
            return string;
        }
        return HTMLUtilities.colorString((Color)color, (String)string);
    }

    protected static List<TextLine> createCommentLines(String comment, int maxLines) {
        if (comment == null || comment.length() == 0) {
            return Collections.emptyList();
        }
        List<String> commentLines = HTMLDataTypeRepresentation.breakCommentAsNecessary(comment);
        int origCommentLineCount = commentLines.size();
        if (origCommentLineCount > maxLines) {
            commentLines = commentLines.subList(0, maxLines - 1);
            commentLines.add("&nbsp;*&nbsp;<i>" + (origCommentLineCount - maxLines + 1) + " lines ommitted...</i><BR>");
        }
        ArrayList<TextLine> newList = new ArrayList<TextLine>();
        newList.add(new TextLine(START_COMMENT));
        for (String commentLine : commentLines) {
            newList.add(new TextLine(commentLine));
        }
        newList.add(new TextLine(END_COMMENT));
        newList.add(new TextLine(BR));
        return newList;
    }

    protected static DataType getLocatableDataType(DataType type) {
        if (type instanceof DefaultDataType) {
            return null;
        }
        UniversalID id = type.getUniversalID();
        if (id == null) {
            type = DataTypeUtils.getNamedBaseDataType(type);
            id = type.getUniversalID();
        }
        if (id == null) {
            return null;
        }
        DataTypeManager manager = type.getDataTypeManager();
        if (manager == null) {
            return null;
        }
        return type;
    }

    protected HTMLDataTypeRepresentation() {
    }

    protected HTMLDataTypeRepresentation(String htmlText) {
        this.originalHTMLData = htmlText.trim();
        boolean htmlStart = StringUtilities.startsWithIgnoreCase((String)htmlText, (String)HTML_OPEN);
        boolean htmlEnd = StringUtilities.startsWithIgnoreCase((String)htmlText, (String)HTML_CLOSE);
        if (htmlStart || htmlEnd) {
            throw new AssertException("Invalid HTML format: text must not include HTML tag");
        }
    }

    public String getHTMLString() {
        return this.getFullHTMLString();
    }

    public String getFullHTMLString() {
        return HTML_OPEN + this.originalHTMLData + HTML_CLOSE;
    }

    public String getHTMLContentString() {
        return this.originalHTMLData;
    }

    public String getFullHTMLContentString() {
        return this.originalHTMLData;
    }

    public abstract HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation var1);

    protected List<ValidatableLine> buildHeaderText(DataType dataType) {
        String comment = HTMLDataTypeRepresentation.getCommentForDataType(dataType);
        ArrayList<ValidatableLine> headerLines = new ArrayList<ValidatableLine>();
        headerLines.addAll(HTMLDataTypeRepresentation.createCommentLines(comment, 4));
        CategoryPath path = dataType.getCategoryPath();
        if (!path.equals((Object)CategoryPath.ROOT)) {
            headerLines.add(new TextLine(HTMLUtilities.escapeHTML((String)path.getPath())));
            headerLines.add(new TextLine(BR));
        }
        return headerLines;
    }

    protected TextLine buildFooterText(DataType dataType) {
        int length = dataType.getLength();
        return new TextLine(length >= 0 ? Integer.toString(length) : " <i>Unsized</i>");
    }

    protected HTMLDataTypeRepresentationDiffInput getDiffInput(ValidatableLine line) {
        return new HTMLDataTypeRepresentationDiffInput(this, Arrays.asList(line));
    }

    protected HTMLDataTypeRepresentationDiffInput getDiffInput(List<ValidatableLine> lines) {
        return new HTMLDataTypeRepresentationDiffInput(this, lines);
    }

    protected HTMLDataTypeRepresentation[] completelyDifferentDiff(HTMLDataTypeRepresentation other) {
        return new HTMLDataTypeRepresentation[]{new CompletelyDifferentHTMLDataTypeRepresentationWrapper(this), new CompletelyDifferentHTMLDataTypeRepresentationWrapper(other)};
    }

    protected List<ValidatableLine> copyLines(List<ValidatableLine> lines) {
        ArrayList<ValidatableLine> newLines = new ArrayList<ValidatableLine>();
        for (ValidatableLine line : lines) {
            newLines.add(line.copy());
        }
        return newLines;
    }

    protected void diffTextLine(TextLine textLine, TextLine otherTextLine) {
        if (!textLine.getText().equals(otherTextLine.getText())) {
            textLine.setValidationLine(otherTextLine);
        }
    }

    protected PlaceHolderLine createPlaceHolderLine(ValidatableLine oppositeLine) {
        return null;
    }
}

