/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import ghidra.app.util.DomainObjectService;
import ghidra.app.util.Option;
import ghidra.app.util.exporter.Exporter;
import ghidra.app.util.exporter.ExporterException;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.mem.AddressSourceInfo;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.reloc.Relocation;
import ghidra.util.Conv;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import utilities.util.FileUtilities;

public abstract class AbstractLoaderExporter
extends Exporter {
    protected AbstractLoaderExporter(String name, HelpLocation help) {
        super(name, "", help);
    }

    protected abstract boolean supportsFileFormat(String var1);

    @Override
    public boolean export(File file, DomainObject domainObj, AddressSetView addrSet, TaskMonitor monitor) throws IOException, ExporterException {
        if (!(domainObj instanceof Program)) {
            this.log.appendMsg("Unsupported type: " + domainObj.getClass().getSimpleName());
            return false;
        }
        Program program = (Program)domainObj;
        Memory memory = program.getMemory();
        String fileFormat = program.getExecutableFormat();
        if (!this.supportsFileFormat(fileFormat)) {
            this.log.appendMsg("Unsupported file format: " + fileFormat);
            return false;
        }
        List fileBytes = memory.getAllFileBytes();
        if (fileBytes.isEmpty()) {
            this.log.appendMsg("Exporting a program with no file source bytes is not supported");
            return false;
        }
        if (fileBytes.size() > 1) {
            this.log.appendMsg("Exporting a program with more than 1 file source is not supported");
            return false;
        }
        File tempFile = File.createTempFile("ghidra_export_", null);
        try (FileOutputStream out = new FileOutputStream(tempFile, false);){
            FileUtilities.copyStreamToStream((InputStream)new FileBytesInputStream((FileBytes)fileBytes.get(0)), (OutputStream)out, (TaskMonitor)monitor);
        }
        try (RandomAccessFile fout = new RandomAccessFile(tempFile, "rw");){
            Iterable relocs = () -> program.getRelocationTable().getRelocations();
            for (Relocation reloc : relocs) {
                long offset;
                Address addr = reloc.getAddress();
                AddressSourceInfo addrSourceInfo = memory.getAddressSourceInfo(addr);
                if (addrSourceInfo == null || (offset = addrSourceInfo.getFileOffset()) < 0L) continue;
                MemoryBlockSourceInfo memSourceInfo = addrSourceInfo.getMemoryBlockSourceInfo();
                byte[] bytes = reloc.getBytes();
                int len = Math.min(bytes.length, (int)memSourceInfo.getMaxAddress().subtract(addr) + 1);
                fout.seek(offset);
                fout.write(bytes, 0, len);
            }
        }
        catch (Exception e) {
            if (!tempFile.delete()) {
                this.log.appendMsg("Failed to delete malformed file: " + tempFile);
            }
            return false;
        }
        Path from = Paths.get(tempFile.toURI());
        Path to = Paths.get(file.toURI());
        Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
        return true;
    }

    @Override
    public List<Option> getOptions(DomainObjectService domainObjectService) {
        return EMPTY_OPTIONS;
    }

    @Override
    public void setOptions(List<Option> options) {
    }

    private static class FileBytesInputStream
    extends InputStream {
        private final FileBytes fileBytes;
        private final long size;
        private long pos;

        FileBytesInputStream(FileBytes fileBytes) {
            this.fileBytes = fileBytes;
            this.size = fileBytes.getSize();
            this.pos = 0L;
        }

        @Override
        public int read() throws IOException {
            return this.pos < this.size ? Conv.byteToInt((byte)this.fileBytes.getModifiedByte(this.pos++)) : -1;
        }
    }
}

