/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.app.util.datatype.microsoft.RTTIDataType;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.program.model.mem.WrappedMemBuffer;
import ghidra.util.Msg;

public class RTTI0DataType
extends RTTIDataType {
    private static final long serialVersionUID = 1L;
    private static final int VF_TABLE_POINTER_OFFSET = 0;

    public RTTI0DataType() {
        this(null);
    }

    public RTTI0DataType(DataTypeManager dtm) {
        super("RTTI_0", dtm);
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new RTTI0DataType(dtm);
    }

    public String getDescription() {
        return "RTTI 0 (RTTI Type Descriptor) Structure used to provide type information for a C++ class.";
    }

    public String getMnemonic(Settings settings) {
        return "RTTI_0";
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    protected DataTypeComponent[] getAllComponents(MemBuffer buf) {
        int pointerSize;
        Program program = buf.getMemory().getProgram();
        PointerDataType pointer = new PointerDataType((DataTypeManager)program.getDataTypeManager());
        DataTypeComponent[] comps = new DataTypeComponent[3];
        comps[0] = new ReadOnlyDataTypeComponent((DataType)pointer, (DynamicDataType)this, pointer.getLength(), 0, 0, "pVFTable", "vfTablePointer");
        int dataPointerOffset = this.getSpareDataOffset(program);
        comps[1] = new ReadOnlyDataTypeComponent((DataType)pointer, (DynamicDataType)this, pointer.getLength(), 1, dataPointerOffset, "spare", "pointer to spare data");
        Address start = buf.getAddress();
        int nameOffset = this.getNameOffset(program);
        Address nameAddress = start.add((long)nameOffset);
        MemoryBufferImpl nameBuf = new MemoryBufferImpl(buf.getMemory(), nameAddress, 1024);
        DataTypeInstance dti = DataTypeInstance.getDataTypeInstance((DataType)new TerminatedStringDataType(), (MemBuffer)nameBuf);
        comps[2] = dti != null ? new ReadOnlyDataTypeComponent(dti.getDataType(), (DynamicDataType)this, dti.getLength(), 2, nameOffset, "name", null) : new ReadOnlyDataTypeComponent(DataType.DEFAULT, (DynamicDataType)this, 1, 2, nameOffset, "name", null);
        int length = nameOffset + dti.getLength();
        int mod = length % (pointerSize = MSDataTypeUtils.is64Bit(program) ? 8 : 4);
        if (mod == 0) {
            return comps;
        }
        int offset = length;
        int bytesNeeded = mod != 0 ? pointerSize - mod : 0;
        ArrayDataType dt = new ArrayDataType((DataType)new ByteDataType(), bytesNeeded, 1);
        DataTypeComponent[] alignedComps = new DataTypeComponent[4];
        System.arraycopy(comps, 0, alignedComps, 0, 3);
        alignedComps[3] = new ReadOnlyDataTypeComponent((DataType)dt, (DynamicDataType)this, bytesNeeded, 3, offset, "alignmentBytes", null);
        return alignedComps;
    }

    private int getSpareDataOffset(Program program) {
        return MSDataTypeUtils.is64Bit(program) ? 8 : 4;
    }

    private int getNameOffset(Program program) {
        return MSDataTypeUtils.is64Bit(program) ? 16 : 8;
    }

    public Address getVFTableAddress(Memory memory, Address rtti0Address) {
        return MSDataTypeUtils.getAbsoluteAddress(memory.getProgram(), rtti0Address);
    }

    public Address getSpareDataAddress(Memory memory, Address rtti0Address) {
        int spareDataOffset = this.getSpareDataOffset(memory.getProgram());
        return MSDataTypeUtils.getAbsoluteAddress(memory.getProgram(), rtti0Address.add((long)spareDataOffset));
    }

    public String getVFTableName(MemBuffer buf) {
        DataTypeInstance dti = null;
        WrappedMemBuffer nameBuf = null;
        try {
            nameBuf = new WrappedMemBuffer(buf, this.getNameOffset(buf.getMemory().getProgram()));
            dti = DataTypeInstance.getDataTypeInstance((DataType)new TerminatedStringDataType(), (MemBuffer)nameBuf);
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            // empty catch block
        }
        if (dti == null || dti.getLength() > 1024) {
            Msg.warn((Object)((Object)this), (Object)("Couldn't get vf table name @ " + buf.getAddress() + "."));
            return null;
        }
        String s = dti.getDataType().getValue((MemBuffer)nameBuf, SettingsImpl.NO_SETTINGS, dti.getLength()).toString();
        return s;
    }

    public int getLength(Memory memory, Address address, byte[] bytes) {
        int lengthWithoutAlignPadding;
        int pointerSize;
        Program program = memory.getProgram();
        int n = pointerSize = MSDataTypeUtils.is64Bit(program) ? 8 : 4;
        if (address.getOffset() % (long)pointerSize != 0L) {
            return 0;
        }
        if (bytes.length < pointerSize * 2 + 1) {
            return 0;
        }
        Address vfTableAddress = MSDataTypeUtils.getAbsoluteAddress(program, address);
        if (vfTableAddress == null || !memory.contains(vfTableAddress)) {
            return 0;
        }
        int nameOffset = this.getNameOffset(program);
        for (int i = this.getSpareDataOffset(program); i < nameOffset; ++i) {
            if (bytes[i] == 0) continue;
            return 0;
        }
        String vfTableName = this.getVFTableName((MemBuffer)new MemoryBufferImpl(memory, address));
        if (vfTableName == null) {
            return 0;
        }
        int nameLength = vfTableName.length();
        if (nameLength == 0) {
            return 0;
        }
        int mod = (lengthWithoutAlignPadding = nameOffset + nameLength) % pointerSize;
        int padSize = mod == 0 ? 0 : pointerSize - mod;
        int paddedLength = lengthWithoutAlignPadding + padSize;
        if (paddedLength > bytes.length) {
            return 0;
        }
        if (this.containsWhitespace(vfTableName)) {
            return 0;
        }
        return paddedLength;
    }

    private boolean containsWhitespace(String s) {
        int checkLength = s.length();
        if (s.charAt(checkLength - 1) == '\u0000') {
            --checkLength;
        }
        for (int i = 0; i < checkLength; ++i) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid(Program program, Address startAddress, DataValidationOptions validationOptions) {
        Memory memory = program.getMemory();
        AddressSetView loadedAndInitializedSet = memory.getLoadedAndInitializedAddressSet();
        Listing listing = program.getListing();
        if (!memory.contains(startAddress)) {
            return false;
        }
        int pointerSize = MSDataTypeUtils.is64Bit(program) ? 8 : 4;
        Address endAddress = startAddress.add((long)(pointerSize * 2));
        try {
            MSDataTypeUtils.getBytes(memory, startAddress, pointerSize * 2);
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        if (startAddress.getOffset() % (long)pointerSize != 0L) {
            return false;
        }
        Address vfTableAddress = MSDataTypeUtils.getAbsoluteAddress(program, startAddress);
        if (vfTableAddress == null || !memory.contains(vfTableAddress)) {
            return false;
        }
        try {
            Address spareDataAddress = this.getSpareDataAddress(memory, startAddress);
            if (spareDataAddress != null && spareDataAddress.getOffset() != 0L && !loadedAndInitializedSet.contains(spareDataAddress)) {
                return false;
            }
        }
        catch (AddressOutOfBoundsException e1) {
            return false;
        }
        String vfTableName = this.getVFTableName((MemBuffer)new MemoryBufferImpl(memory, startAddress));
        if (vfTableName == null) {
            return false;
        }
        int nameLength = vfTableName.length();
        if (nameLength == 0) {
            return false;
        }
        int lengthWithoutAlignPadding = this.getNameOffset(program) + nameLength;
        int mod = lengthWithoutAlignPadding % pointerSize;
        int padSize = mod == 0 ? 0 : pointerSize - mod;
        int paddedLength = lengthWithoutAlignPadding + padSize;
        try {
            MSDataTypeUtils.getBytes(memory, startAddress, paddedLength);
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        if (this.containsWhitespace(vfTableName)) {
            return false;
        }
        if (!validationOptions.shouldIgnoreInstructions() && this.containsInstruction(listing, startAddress, endAddress)) {
            return false;
        }
        return validationOptions.shouldIgnoreDefinedData() || !this.containsDefinedData(listing, startAddress, endAddress);
    }

    public int getLength(Memory memory, Address startAddress) {
        DumbMemBufferImpl nameMemBuffer;
        int preNameLength;
        Program program = memory.getProgram();
        int totalLength = preNameLength = this.getNameOffset(program);
        Address nameAddress = startAddress.add((long)preNameLength);
        TerminatedStringDataType terminatedStringDt = new TerminatedStringDataType((DataTypeManager)program.getDataTypeManager());
        int nameLength = terminatedStringDt.getLength((MemBuffer)(nameMemBuffer = new DumbMemBufferImpl(memory, nameAddress)), 16384);
        if (nameLength <= 0) {
            return 0;
        }
        int alignment = this.getAlignment();
        int mod = (totalLength += nameLength) % alignment;
        if (mod != 0) {
            int numAlignBytes = alignment - mod;
            totalLength += numAlignBytes;
        }
        return totalLength;
    }

    public String getDefaultLabelPrefix() {
        return "RTTI_0";
    }
}

