/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfSymbol;
import java.io.IOException;
import java.util.ArrayList;

public class OmfExternalSymbol
extends OmfRecord {
    private boolean isStatic;
    protected OmfSymbol[] symbol;

    protected OmfExternalSymbol(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public OmfExternalSymbol(BinaryReader reader, boolean isStatic) throws IOException {
        this.isStatic = isStatic;
        this.readRecordHeader(reader);
        long max = reader.getPointerIndex() + (long)this.getRecordLength() - 1L;
        ArrayList<OmfSymbol> symbollist = new ArrayList<OmfSymbol>();
        while (reader.getPointerIndex() < max) {
            String name = OmfRecord.readString(reader);
            int type = OmfRecord.readIndex(reader);
            OmfSymbol subrec = new OmfSymbol(name, type, 0L, 0, 0);
            symbollist.add(subrec);
        }
        this.readCheckSumByte(reader);
        this.symbol = new OmfSymbol[symbollist.size()];
        symbollist.toArray(this.symbol);
    }

    public OmfSymbol[] getSymbols() {
        return this.symbol;
    }

    public boolean isStatic() {
        return this.isStatic;
    }
}

